/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.support;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.TimeZone;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.TriggerContext;
import org.springframework.scheduling.support.CronExpression;
import org.springframework.util.Assert;

public class CronTrigger
implements Trigger {
    private final CronExpression expression;
    @Nullable
    private final ZoneId zoneId;

    public CronTrigger(String expression) {
        this.expression = CronExpression.parse(expression);
        this.zoneId = null;
    }

    public CronTrigger(String expression, TimeZone timeZone) {
        this.expression = CronExpression.parse(expression);
        Assert.notNull((Object)timeZone, "TimeZone must not be null");
        this.zoneId = timeZone.toZoneId();
    }

    public CronTrigger(String expression, ZoneId zoneId) {
        this.expression = CronExpression.parse(expression);
        Assert.notNull((Object)zoneId, "ZoneId must not be null");
        this.zoneId = zoneId;
    }

    public String getExpression() {
        return this.expression.toString();
    }

    @Override
    public Date nextExecutionTime(TriggerContext triggerContext) {
        Date timestamp = triggerContext.lastCompletionTime();
        if (timestamp != null) {
            Date scheduled = triggerContext.lastScheduledExecutionTime();
            if (scheduled != null && timestamp.before(scheduled)) {
                timestamp = scheduled;
            }
        } else {
            timestamp = new Date(triggerContext.getClock().millis());
        }
        ZoneId zone = this.zoneId != null ? this.zoneId : triggerContext.getClock().getZone();
        ZonedDateTime zonedTimestamp = ZonedDateTime.ofInstant(timestamp.toInstant(), zone);
        ZonedDateTime nextTimestamp = this.expression.next(zonedTimestamp);
        return nextTimestamp != null ? Date.from(nextTimestamp.toInstant()) : null;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof CronTrigger && this.expression.equals(((CronTrigger)other).expression);
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public String toString() {
        return this.expression.toString();
    }
}

