/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.discovery;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import org.jolokia.discovery.AbstractDiscoveryMessage;
import org.jolokia.discovery.AgentDetailsHolder;
import org.jolokia.discovery.DiscoveryIncomingMessage;
import org.jolokia.discovery.DiscoveryOutgoingMessage;
import org.jolokia.discovery.MulticastUtil;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.util.LogHandler;
import org.jolokia.util.NetworkUtil;

class MulticastSocketListenerThread
extends Thread {
    private final AgentDetailsHolder agentDetailsHolder;
    private final Restrictor restrictor;
    private final String multicastGroup;
    private final int multicastPort;
    private final LogHandler logHandler;
    private final InetAddress address;
    private boolean running;
    private MulticastSocket socket;

    MulticastSocketListenerThread(String name, InetAddress pHostAddress, AgentDetailsHolder pAgentDetailsHolder, Restrictor pRestrictor, String pMulticastGroup, int pMulticastPort, LogHandler pLogHandler) throws IOException {
        super(name);
        this.address = pHostAddress != null ? pHostAddress : NetworkUtil.getLocalAddressWithMulticast();
        this.agentDetailsHolder = pAgentDetailsHolder;
        this.restrictor = pRestrictor;
        this.multicastGroup = pMulticastGroup;
        this.multicastPort = pMulticastPort;
        this.logHandler = pLogHandler;
        this.socket = MulticastUtil.newMulticastSocket(this.address, this.multicastGroup, this.multicastPort, this.logHandler);
        this.logHandler.debug(this.address + "<-- Listening for queries");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        this.setRunning(true);
        try {
            while (this.isRunning()) {
                this.refreshSocket();
                this.logHandler.debug(this.address + "<-- Waiting");
                DiscoveryIncomingMessage msg = this.receiveMessage();
                if (!this.shouldMessageBeProcessed(msg)) continue;
                this.handleQuery(msg);
            }
        }
        catch (IllegalStateException e) {
            this.logHandler.error(this.address + "<-- Cannot reopen socket, exiting listener thread: " + e.getCause(), e.getCause());
        }
        finally {
            if (this.socket != null) {
                this.socket.close();
            }
            this.logHandler.debug(this.address + "<-- Stop listening");
        }
    }

    private synchronized void setRunning(boolean pRunning) {
        this.running = pRunning;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void shutdown() {
        this.setRunning(false);
        this.interrupt();
        this.socket.close();
    }

    private boolean shouldMessageBeProcessed(DiscoveryIncomingMessage pMsg) {
        return pMsg != null && this.restrictor.isRemoteAccessAllowed(pMsg.getSourceAddress().getHostAddress()) && pMsg.isQuery();
    }

    private DiscoveryIncomingMessage receiveMessage() {
        byte[] buf = new byte[8972];
        DatagramPacket packet = new DatagramPacket(buf, buf.length);
        try {
            packet.setLength(buf.length);
            this.socket.receive(packet);
            return new DiscoveryIncomingMessage(packet);
        }
        catch (IOException e) {
            if (!this.socket.isClosed()) {
                this.logHandler.info("Error while handling discovery request" + (packet.getAddress() != null ? " from " + packet.getAddress() : "") + ". Ignoring this request. --> " + e);
            }
            return null;
        }
    }

    private void refreshSocket() {
        if (this.socket.isClosed()) {
            this.logHandler.info(this.address + "<-- Socket closed, reopening it");
            try {
                this.socket = MulticastUtil.newMulticastSocket(this.address, this.multicastGroup, this.multicastPort, this.logHandler);
            }
            catch (IOException exp) {
                this.logHandler.error("Cannot reopen socket. Exiting multicast listener thread ...", exp);
                throw new SocketVerificationFailedException(exp);
            }
        }
    }

    private void handleQuery(DiscoveryIncomingMessage pMsg) {
        DiscoveryOutgoingMessage answer = new DiscoveryOutgoingMessage.Builder(AbstractDiscoveryMessage.MessageType.RESPONSE).respondTo(pMsg).agentDetails(this.agentDetailsHolder.getAgentDetails()).build();
        this.logHandler.debug(this.address + "<-- Discovery request from " + pMsg.getSourceAddress() + ":" + pMsg.getSourcePort());
        this.send(answer);
    }

    private void send(DiscoveryOutgoingMessage pAnswer) {
        byte[] message = pAnswer.getData();
        DatagramPacket packet = new DatagramPacket(message, message.length, pAnswer.getTargetAddress(), pAnswer.getTargetPort());
        if (!this.socket.isClosed()) {
            try {
                this.socket.send(packet);
            }
            catch (IOException exp) {
                this.logHandler.info(this.address + "<-- Can not send discovery response to " + packet.getAddress());
            }
        }
    }

    private static class SocketVerificationFailedException
    extends RuntimeException {
        public SocketVerificationFailedException(IOException e) {
            super(e);
        }
    }
}

