/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.util;

import org.apache.camel.NoSuchBeanException;
import org.apache.camel.spi.Registry;
import org.springframework.expression.AccessException;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;

public final class RegistryBeanResolver
implements BeanResolver {
    private final Registry registry;

    public RegistryBeanResolver(Registry registry) {
        this.registry = registry;
    }

    public Object resolve(EvaluationContext context, String beanName) throws AccessException {
        Object bean = null;
        try {
            bean = this.registry.lookupByName(beanName);
        }
        catch (NoSuchBeanException noSuchBeanException) {
            // empty catch block
        }
        if (bean == null) {
            throw new AccessException("Could not resolve bean reference against Registry");
        }
        return bean;
    }
}

