/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.policy;

import java.util.Arrays;
import javax.jms.MessageFormatRuntimeException;
import org.apache.activemq.broker.ProducerBrokerExchange;
import org.apache.activemq.broker.region.policy.MessageInterceptorStrategy;
import org.apache.activemq.command.Message;

public class ChainMessageInterceptorStrategy
implements MessageInterceptorStrategy {
    private MessageInterceptorStrategy[] messageInterceptorStrategies;

    @Override
    public void process(ProducerBrokerExchange producerBrokerExchange, Message message) throws MessageFormatRuntimeException {
        if (this.messageInterceptorStrategies == null || this.messageInterceptorStrategies.length == 0) {
            return;
        }
        Arrays.stream(this.messageInterceptorStrategies).forEach(m -> m.process(producerBrokerExchange, message));
    }

    public void setMessageStrategies(MessageInterceptorStrategy[] messageInterceptorStrategies) {
        this.messageInterceptorStrategies = messageInterceptorStrategies;
    }

    public MessageInterceptorStrategy[] getMessageInterceptorStrategies() {
        return this.messageInterceptorStrategies;
    }
}

