/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.restrictor.policy;

import java.util.HashSet;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jolokia.restrictor.policy.AbstractChecker;
import org.jolokia.restrictor.policy.MBeanPolicyConfig;
import org.jolokia.util.RequestType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MBeanAccessChecker
extends AbstractChecker<Arg> {
    private MBeanPolicyConfig allow;
    private MBeanPolicyConfig deny;

    public MBeanAccessChecker(Document pDoc) throws MalformedObjectNameException {
        for (String tag : new String[]{"allow", "mbeans"}) {
            NodeList nodes = pDoc.getElementsByTagName(tag);
            if (nodes.getLength() <= 0) continue;
            if (this.allow == null) {
                this.allow = new MBeanPolicyConfig();
            }
            this.extractMbeanConfiguration(nodes, this.allow);
        }
        NodeList nodes = pDoc.getElementsByTagName("deny");
        if (nodes.getLength() > 0) {
            this.deny = new MBeanPolicyConfig();
            this.extractMbeanConfiguration(nodes, this.deny);
        }
    }

    @Override
    public boolean check(Arg pArg) {
        if (pArg.isTypeAllowed()) {
            return this.deny == null || !this.matches(this.deny, pArg);
        }
        return this.allow != null && this.matches(this.allow, pArg);
    }

    private void extractMbeanConfiguration(NodeList pNodes, MBeanPolicyConfig pConfig) throws MalformedObjectNameException {
        for (int i = 0; i < pNodes.getLength(); ++i) {
            Node node = pNodes.item(i);
            if (node.getNodeType() != 1) continue;
            this.extractPolicyConfig(pConfig, node.getChildNodes());
        }
    }

    private void extractPolicyConfig(MBeanPolicyConfig pConfig, NodeList pChilds) throws MalformedObjectNameException {
        for (int j = 0; j < pChilds.getLength(); ++j) {
            Node mBeanNode = pChilds.item(j);
            if (mBeanNode.getNodeType() != 1) continue;
            this.assertNodeName(mBeanNode, "mbean");
            this.extractMBeanPolicy(pConfig, mBeanNode);
        }
    }

    private void extractMBeanPolicy(MBeanPolicyConfig pConfig, Node pMBeanNode) throws MalformedObjectNameException {
        NodeList params = pMBeanNode.getChildNodes();
        String name = null;
        HashSet<String> readAttributes = new HashSet<String>();
        HashSet<String> writeAttributes = new HashSet<String>();
        HashSet<String> operations = new HashSet<String>();
        for (int k = 0; k < params.getLength(); ++k) {
            Node param = params.item(k);
            if (param.getNodeType() != 1) continue;
            this.assertNodeName(param, "name", "attribute", "operation");
            String tag = param.getNodeName();
            if (tag.equals("name")) {
                if (name != null) {
                    throw new SecurityException("<name> given twice as MBean name");
                }
                name = param.getTextContent().trim();
                continue;
            }
            if (tag.equals("attribute")) {
                this.extractAttribute(readAttributes, writeAttributes, param);
                continue;
            }
            if (tag.equals("operation")) {
                operations.add(param.getTextContent().trim());
                continue;
            }
            throw new SecurityException("Tag <" + tag + "> invalid");
        }
        if (name == null) {
            throw new SecurityException("No <name> given for <mbean>");
        }
        pConfig.addValues(new ObjectName(name), readAttributes, writeAttributes, operations);
    }

    private void extractAttribute(Set<String> pReadAttributes, Set<String> pWriteAttributes, Node pParam) {
        Node mode = pParam.getAttributes().getNamedItem("mode");
        pReadAttributes.add(pParam.getTextContent().trim());
        if (mode == null || !mode.getNodeValue().equalsIgnoreCase("read")) {
            pWriteAttributes.add(pParam.getTextContent().trim());
        }
    }

    private boolean matches(MBeanPolicyConfig pConfig, Arg pArg) {
        ObjectName pattern;
        Set<String> values = pConfig.getValues(pArg.getType(), pArg.getName());
        if (values == null && (pattern = pConfig.findMatchingMBeanPattern(pArg.getName())) != null) {
            values = pConfig.getValues(pArg.getType(), pattern);
        }
        return values != null && (values.contains(pArg.getValue()) || this.wildcardMatch(values, pArg.getValue()));
    }

    private boolean wildcardMatch(Set<String> pValues, String pValue) {
        for (String pattern : pValues) {
            if (!pattern.contains("*") || !pValue.matches(pattern.replaceAll("\\*", ".*"))) continue;
            return true;
        }
        return false;
    }

    public static class Arg {
        private boolean isTypeAllowed;
        private RequestType type;
        private ObjectName name;
        private String value;

        public Arg(boolean pIsTypeAllowed, RequestType pType, ObjectName pName, String pValue) {
            this.isTypeAllowed = pIsTypeAllowed;
            this.type = pType;
            this.name = pName;
            this.value = pValue;
        }

        public boolean isTypeAllowed() {
            return this.isTypeAllowed;
        }

        public RequestType getType() {
            return this.type;
        }

        public ObjectName getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

