/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.util.Collection;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.CamelOpenMBeanTypes;
import org.apache.camel.api.management.mbean.ManagedTransformerRegistryMBean;
import org.apache.camel.management.mbean.ManagedService;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.Transformer;
import org.apache.camel.spi.TransformerRegistry;
import org.apache.camel.util.ObjectHelper;

@ManagedResource(description="Managed TransformerRegistry")
public class ManagedTransformerRegistry
extends ManagedService
implements ManagedTransformerRegistryMBean {
    private final TransformerRegistry transformerRegistry;

    public ManagedTransformerRegistry(CamelContext context, TransformerRegistry transformerRegistry) {
        super(context, transformerRegistry);
        this.transformerRegistry = transformerRegistry;
    }

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
    }

    public TransformerRegistry getTransformerRegistry() {
        return this.transformerRegistry;
    }

    @Override
    public String getSource() {
        return this.transformerRegistry.toString();
    }

    @Override
    public Integer getDynamicSize() {
        return this.transformerRegistry.dynamicSize();
    }

    @Override
    public Integer getStaticSize() {
        return this.transformerRegistry.staticSize();
    }

    @Override
    public Integer getSize() {
        return this.transformerRegistry.size();
    }

    @Override
    public Integer getMaximumCacheSize() {
        return this.transformerRegistry.getMaximumCacheSize();
    }

    @Override
    public void purge() {
        this.transformerRegistry.purge();
    }

    @Override
    public TabularData listTransformers() {
        try {
            TabularDataSupport answer = new TabularDataSupport(CamelOpenMBeanTypes.listTransformersTabularType());
            Collection transformers = this.transformerRegistry.values();
            for (Transformer transformer : transformers) {
                CompositeType ct = CamelOpenMBeanTypes.listTransformersCompositeType();
                String scheme = transformer.getModel();
                DataType from = transformer.getFrom();
                DataType to = transformer.getTo();
                String desc = transformer.toString();
                boolean fromStatic = scheme != null ? this.transformerRegistry.isStatic(scheme) : this.transformerRegistry.isStatic(from, to);
                boolean fromDynamic = scheme != null ? this.transformerRegistry.isDynamic(scheme) : this.transformerRegistry.isDynamic(from, to);
                CompositeDataSupport data = new CompositeDataSupport(ct, new String[]{"scheme", "from", "to", "static", "dynamic", "description"}, new Object[]{scheme, from.toString(), to.toString(), fromStatic, fromDynamic, desc});
                answer.put(data);
            }
            return answer;
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
    }
}

