/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.console.command.AbstractCommand;
import org.apache.activemq.console.command.DefaultPasswordFactory;
import org.apache.activemq.console.command.PasswordFactory;

public abstract class AbstractAmqCommand
extends AbstractCommand {
    private URI brokerUrl;
    private ConnectionFactory factory;
    private String factoryClassString;
    private String username;
    private String password;
    private PasswordFactory passwordFactory;
    private final List<Connection> connections = new ArrayList<Connection>();
    private String passwordFactoryClassString;

    protected Connection createConnection() throws JMSException {
        return this.createConnection(this.getUsername(), this.getPassword());
    }

    protected Connection createConnection(String username, String password) throws JMSException {
        if (this.getBrokerUrl() == null) {
            this.context.printException(new IllegalStateException("You must specify a broker URL to connect to using the --amqurl option."));
            return null;
        }
        ConnectionFactory factory = this.getConnectionFactory();
        Connection conn = null == username && null == password ? factory.createConnection() : factory.createConnection(username, password);
        this.connections.add(conn);
        conn.start();
        return conn;
    }

    protected void closeAllConnections() {
        Iterator<Connection> i = this.connections.iterator();
        while (i.hasNext()) {
            try {
                i.next().close();
            }
            catch (Exception exception) {}
        }
        this.connections.clear();
    }

    protected void handleOption(String token, List tokens) throws Exception {
        if (token.equals("--amqurl")) {
            if (tokens.isEmpty() || ((String)tokens.get(0)).startsWith("-")) {
                this.context.printException(new IllegalArgumentException("Broker URL not specified."));
                tokens.clear();
                return;
            }
            if (this.getBrokerUrl() != null) {
                this.context.printException(new IllegalArgumentException("Multiple broker URL cannot be specified."));
                tokens.clear();
                return;
            }
            String strBrokerUrl = (String)tokens.remove(0);
            try {
                this.setBrokerUrl(new URI(strBrokerUrl));
            }
            catch (URISyntaxException e) {
                this.context.printException(e);
                tokens.clear();
                return;
            }
        } else if (token.equals("--factory")) {
            this.factoryClassString = (String)tokens.remove(0);
        } else if (token.equals("--passwordFactory")) {
            this.passwordFactoryClassString = (String)tokens.remove(0);
        } else if (token.equals("--password")) {
            this.password = (String)tokens.remove(0);
        } else if (token.equals("--user")) {
            this.username = (String)tokens.remove(0);
        } else {
            super.handleOption(token, tokens);
        }
    }

    protected void setBrokerUrl(URI brokerUrl) {
        this.brokerUrl = brokerUrl;
    }

    protected void setBrokerUrl(String address) throws URISyntaxException {
        this.brokerUrl = new URI(address);
    }

    protected URI getBrokerUrl() {
        return this.brokerUrl;
    }

    public ConnectionFactory getConnectionFactory() {
        if (this.factory == null && this.factoryClassString != null) {
            try {
                Class<?> klass = Class.forName(this.factoryClassString);
                this.factory = this.getUsername() != null || this.getPassword() != null ? (ConnectionFactory)klass.getConstructor(String.class, String.class, URI.class).newInstance(this.getUsername(), this.getPassword(), this.getBrokerUrl()) : (ConnectionFactory)klass.getConstructor(URI.class).newInstance(this.getBrokerUrl());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.factory == null) {
            this.factory = this.getUsername() != null || this.getPassword() != null ? new ActiveMQConnectionFactory(this.getUsername(), this.getPassword(), this.getBrokerUrl()) : new ActiveMQConnectionFactory(this.getBrokerUrl());
        }
        return this.factory;
    }

    public String getUsername() {
        return this.username;
    }

    public void setFactory(ConnectionFactory factory) {
        this.factory = factory;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        if (null == this.password) {
            return null;
        }
        return this.getPasswordFactory().getPassword(this.password);
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public PasswordFactory getPasswordFactory() {
        if (this.passwordFactory == null && this.passwordFactoryClassString != null) {
            try {
                Class<?> klass = Class.forName(this.passwordFactoryClassString);
                this.passwordFactory = (PasswordFactory)PasswordFactory.class.cast(klass.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.passwordFactory == null) {
            this.passwordFactory = DefaultPasswordFactory.factory;
        }
        return this.passwordFactory;
    }

    public void setPasswordFactory(PasswordFactory passwordFactory) {
        this.passwordFactory = passwordFactory;
    }
}

