/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import javax.jmdns.ServiceInfo;
import javax.jmdns.impl.ServiceTypeDecoder;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;

public abstract class DNSEntry {
    private final String _key;
    private final String _name;
    private final String _type;
    private final DNSRecordType _recordType;
    private final DNSRecordClass _dnsClass;
    private final boolean _unique;
    final Map<ServiceInfo.Fields, String> _qualifiedNameMap;

    DNSEntry(String name, DNSRecordType recordType, DNSRecordClass recordClass, boolean unique) {
        this._name = name;
        this._recordType = recordType;
        this._dnsClass = recordClass;
        this._unique = unique;
        this._qualifiedNameMap = ServiceTypeDecoder.decodeQualifiedNameMapForType(this.getName());
        String domain = this._qualifiedNameMap.get((Object)ServiceInfo.Fields.Domain);
        String protocol = this._qualifiedNameMap.get((Object)ServiceInfo.Fields.Protocol);
        String application = this._qualifiedNameMap.get((Object)ServiceInfo.Fields.Application);
        String instance = this._qualifiedNameMap.get((Object)ServiceInfo.Fields.Instance).toLowerCase();
        this._type = this.buildType(application, protocol, domain);
        this._key = (!instance.isEmpty() ? instance + "." + this._type : this._type).toLowerCase();
    }

    private String buildType(String application, String protocol, String domain) {
        StringBuilder type = new StringBuilder();
        if (application != null && !application.isEmpty()) {
            type.append('_').append(application).append('.');
        }
        if (protocol != null && !protocol.isEmpty()) {
            type.append('_').append(protocol).append('.');
        }
        if (domain != null && !domain.isEmpty()) {
            type.append(domain).append('.');
        }
        if (type.length() == 0) {
            return ".";
        }
        return type.toString();
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof DNSEntry) {
            DNSEntry other = (DNSEntry)obj;
            result = this.getKey().equals(other.getKey()) && this.getRecordType().equals((Object)other.getRecordType()) && this.getRecordClass() == other.getRecordClass();
        }
        return result;
    }

    public boolean isSameEntry(DNSEntry entry) {
        boolean sameKey = this.getKey().equals(entry.getKey());
        boolean sameRecordType = this.matchRecordType(entry.getRecordType());
        boolean sameRecordClass = this.matchRecordClass(entry.getRecordClass());
        boolean sameSubtype = this.sameSubtype(entry);
        return sameKey && sameRecordType && sameRecordClass && sameSubtype;
    }

    public boolean sameSubtype(DNSEntry other) {
        return this.getSubtype().equals(other.getSubtype());
    }

    public boolean matchRecordClass(DNSRecordClass recordClass) {
        return DNSRecordClass.CLASS_ANY == recordClass || DNSRecordClass.CLASS_ANY == this.getRecordClass() || this.getRecordClass().equals((Object)recordClass);
    }

    public boolean matchRecordType(DNSRecordType recordType) {
        return this.getRecordType().equals((Object)recordType);
    }

    public String getSubtype() {
        String subtype = this.getQualifiedNameMap().get((Object)ServiceInfo.Fields.Subtype);
        return subtype != null ? subtype : "";
    }

    public String getName() {
        return this._name != null ? this._name : "";
    }

    public String getType() {
        return this._type != null ? this._type : "";
    }

    public String getKey() {
        return this._key != null ? this._key : "";
    }

    public DNSRecordType getRecordType() {
        return this._recordType != null ? this._recordType : DNSRecordType.TYPE_IGNORE;
    }

    public DNSRecordClass getRecordClass() {
        return this._dnsClass != null ? this._dnsClass : DNSRecordClass.CLASS_UNKNOWN;
    }

    public boolean isUnique() {
        return this._unique;
    }

    public Map<ServiceInfo.Fields, String> getQualifiedNameMap() {
        return Collections.unmodifiableMap(this._qualifiedNameMap);
    }

    public boolean isServicesDiscoveryMetaQuery() {
        return this._qualifiedNameMap.get((Object)ServiceInfo.Fields.Application).equals("dns-sd") && this._qualifiedNameMap.get((Object)ServiceInfo.Fields.Instance).equals("_services");
    }

    public boolean isDomainDiscoveryQuery() {
        if (this._qualifiedNameMap.get((Object)ServiceInfo.Fields.Application).equals("dns-sd")) {
            String name = this._qualifiedNameMap.get((Object)ServiceInfo.Fields.Instance);
            return "b".equals(name) || "db".equals(name) || "r".equals(name) || "dr".equals(name) || "lb".equals(name);
        }
        return false;
    }

    public boolean isReverseLookup() {
        return this.isV4ReverseLookup() || this.isV6ReverseLookup();
    }

    public boolean isV4ReverseLookup() {
        return this._qualifiedNameMap.get((Object)ServiceInfo.Fields.Domain).endsWith("in-addr.arpa");
    }

    public boolean isV6ReverseLookup() {
        return this._qualifiedNameMap.get((Object)ServiceInfo.Fields.Domain).endsWith("ip6.arpa");
    }

    public abstract boolean isStale(long var1);

    public abstract boolean isExpired(long var1);

    public boolean isSameRecordClass(DNSEntry entry) {
        return entry != null && entry.getRecordClass() == this.getRecordClass();
    }

    public boolean isSameType(DNSEntry entry) {
        return entry != null && entry.getRecordType() == this.getRecordType();
    }

    protected void toByteArray(DataOutputStream dout) throws IOException {
        dout.write(this.getName().getBytes(StandardCharsets.UTF_8));
        dout.writeShort(this.getRecordType().indexValue());
        dout.writeShort(this.getRecordClass().indexValue());
    }

    protected byte[] toByteArray() {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            this.toByteArray(dout);
            dout.close();
            return bout.toByteArray();
        }
        catch (IOException e) {
            throw new InternalError();
        }
    }

    public int compareTo(DNSEntry that) {
        byte[] thisBytes = this.toByteArray();
        byte[] thatBytes = that.toByteArray();
        int n = Math.min(thisBytes.length, thatBytes.length);
        for (int i = 0; i < n; ++i) {
            if (thisBytes[i] > thatBytes[i]) {
                return 1;
            }
            if (thisBytes[i] >= thatBytes[i]) continue;
            return -1;
        }
        return thisBytes.length - thatBytes.length;
    }

    public int hashCode() {
        return this.getKey().hashCode() + this.getRecordType().indexValue() + this.getRecordClass().indexValue();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append('[').append(this.getClass().getSimpleName()).append('@').append(System.identityHashCode(this));
        sb.append(" type: ").append((Object)this.getRecordType());
        sb.append(", class: ").append((Object)this.getRecordClass());
        sb.append(this._unique ? "-unique," : ",");
        sb.append(" name: ").append(this._name);
        this.toString(sb);
        sb.append(']');
        return sb.toString();
    }

    protected void toString(StringBuilder sb) {
    }
}

