/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.store.MessageRecoveryListener;

public class MessageRecoveryContext
implements MessageRecoveryListener {
    public static final int DEFAULT_MAX_MESSAGE_COUNT_RETURNED = 100;
    public static final boolean DEFAULT_USE_DEDICATED_CURSOR = true;
    private final boolean useDedicatedCursor;
    private final int maxMessageCountReturned;
    private final Long offset;
    private final String startMessageId;
    private String endMessageId = null;
    private final MessageRecoveryListener messageRecoveryListener;
    private Long endSequenceId = Long.MAX_VALUE;
    private final AtomicInteger recoveredCount = new AtomicInteger(0);

    MessageRecoveryContext(MessageRecoveryListener messageRecoveryListener, String startMessageId, String endMessageId, Long offset, Integer maxMessageCountReturned, Boolean useDedicatedCursor) {
        if (maxMessageCountReturned != null && maxMessageCountReturned < 0) {
            throw new IllegalArgumentException("maxMessageCountReturned must be a positive integer value");
        }
        if (messageRecoveryListener == null) {
            throw new IllegalArgumentException("MessageRecoveryListener must be specified");
        }
        if (offset != null) {
            if (offset < 0L) {
                throw new IllegalArgumentException("offset must be a non-negative integer value");
            }
            if (startMessageId != null) {
                throw new IllegalArgumentException("Only one of offset and startMessageId may be specified");
            }
        }
        this.endMessageId = endMessageId;
        this.maxMessageCountReturned = maxMessageCountReturned != null ? maxMessageCountReturned : 100;
        this.messageRecoveryListener = messageRecoveryListener;
        this.offset = offset;
        this.startMessageId = startMessageId;
        this.useDedicatedCursor = useDedicatedCursor != null ? useDedicatedCursor : true;
    }

    public boolean isUseDedicatedCursor() {
        return this.useDedicatedCursor;
    }

    public int getMaxMessageCountReturned() {
        return this.maxMessageCountReturned;
    }

    public Long getOffset() {
        return this.offset;
    }

    public String getEndMessageId() {
        return this.endMessageId;
    }

    public String getStartMessageId() {
        return this.startMessageId;
    }

    public MessageRecoveryListener getMessageRecoveryListener() {
        return this.messageRecoveryListener;
    }

    public void setEndSequenceId(long endSequenceId) {
        this.endSequenceId = endSequenceId;
    }

    public boolean canRecoveryNextMessage(Long sequenceId) {
        return this.getRecoveredCount() < this.getMaxMessageCountReturned() && this.messageRecoveryListener.canRecoveryNextMessage() && sequenceId < this.endSequenceId;
    }

    @Override
    public boolean recoverMessage(Message message) throws Exception {
        boolean tmpReturned = this.messageRecoveryListener.recoverMessage(message);
        if (tmpReturned) {
            this.recoveredCount.incrementAndGet();
        }
        return tmpReturned;
    }

    @Override
    public boolean recoverMessageReference(MessageId ref) throws Exception {
        return this.messageRecoveryListener.recoverMessageReference(ref);
    }

    @Override
    public boolean hasSpace() {
        return this.messageRecoveryListener.hasSpace();
    }

    @Override
    public boolean isDuplicate(MessageId ref) {
        return this.messageRecoveryListener.isDuplicate(ref);
    }

    public int getRecoveredCount() {
        return this.recoveredCount.get();
    }

    public String toString() {
        return "MessageRecoveryContext [useDedicatedCursor=" + this.useDedicatedCursor + ", maxMessageCountReturned=" + this.maxMessageCountReturned + ", offset=" + this.offset + ", startMessageId=" + this.startMessageId + ", endMessageId=" + this.endMessageId + ", messageRecoveryListener=" + String.valueOf(this.messageRecoveryListener) + ", endSequenceId=" + this.endSequenceId + ", recoveredCount=" + String.valueOf(this.recoveredCount) + "]";
    }

    public static class Builder {
        private Boolean useDedicatedCursor;
        private Integer maxMessageCountReturned;
        private Long offset;
        private String startMessageId;
        private String endMessageId;
        private MessageRecoveryListener messageRecoveryListener;

        public Builder useDedicatedCursor(boolean useDedicatedCursor) {
            this.useDedicatedCursor = useDedicatedCursor;
            return this;
        }

        public Builder maxMessageCountReturned(int maxMessageCountReturned) {
            this.maxMessageCountReturned = maxMessageCountReturned;
            return this;
        }

        public Builder offset(long offset) {
            this.offset = offset;
            return this;
        }

        public Builder endMessageId(String endMessageId) {
            this.endMessageId = endMessageId;
            return this;
        }

        public Builder startMessageId(String startMessageId) {
            this.startMessageId = startMessageId;
            return this;
        }

        public Builder messageRecoveryListener(MessageRecoveryListener messageRecoveryListener) {
            this.messageRecoveryListener = messageRecoveryListener;
            return this;
        }

        public MessageRecoveryContext build() {
            return new MessageRecoveryContext(this.messageRecoveryListener, this.startMessageId, this.endMessageId, this.offset, this.maxMessageCountReturned, this.useDedicatedCursor);
        }
    }
}

