/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.mgt;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.CacheManagerAware;
import org.apache.shiro.event.EventBus;
import org.apache.shiro.event.EventBusAware;
import org.apache.shiro.mgt.CachingSecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.util.LifecycleUtils;

public abstract class RealmSecurityManager
extends CachingSecurityManager {
    private Collection<Realm> realms;

    public void setRealm(Realm realm) {
        if (realm == null) {
            throw new IllegalArgumentException("Realm argument cannot be null");
        }
        ArrayList<Realm> realms = new ArrayList<Realm>(1);
        realms.add(realm);
        this.setRealms(realms);
    }

    public void setRealms(Collection<Realm> realms) {
        if (realms == null) {
            throw new IllegalArgumentException("Realms collection argument cannot be null.");
        }
        if (realms.isEmpty()) {
            throw new IllegalArgumentException("Realms collection argument cannot be empty.");
        }
        this.realms = realms;
        this.afterRealmsSet();
    }

    protected void afterRealmsSet() {
        this.applyCacheManagerToRealms();
        this.applyEventBusToRealms();
    }

    public Collection<Realm> getRealms() {
        return this.realms;
    }

    protected void applyCacheManagerToRealms() {
        CacheManager cacheManager = this.getCacheManager();
        Collection<Realm> realms = this.getRealms();
        if (cacheManager != null && realms != null && !realms.isEmpty()) {
            for (Realm realm : realms) {
                if (!(realm instanceof CacheManagerAware)) continue;
                ((CacheManagerAware)((Object)realm)).setCacheManager(cacheManager);
            }
        }
    }

    protected void applyEventBusToRealms() {
        EventBus eventBus = this.getEventBus();
        Collection<Realm> realms = this.getRealms();
        if (eventBus != null && realms != null && !realms.isEmpty()) {
            for (Realm realm : realms) {
                if (!(realm instanceof EventBusAware)) continue;
                ((EventBusAware)((Object)realm)).setEventBus(eventBus);
            }
        }
    }

    @Override
    protected void afterCacheManagerSet() {
        super.afterCacheManagerSet();
        this.applyCacheManagerToRealms();
    }

    @Override
    protected void afterEventBusSet() {
        super.afterEventBusSet();
        this.applyEventBusToRealms();
    }

    @Override
    public void destroy() {
        LifecycleUtils.destroy(this.getRealms());
        this.realms = null;
        super.destroy();
    }
}

