/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.sketches.theta;

import com.yahoo.memory.Memory;
import com.yahoo.sketches.ResizeFactor;
import com.yahoo.sketches.hash.MurmurHash3;
import com.yahoo.sketches.theta.CompactSketch;
import com.yahoo.sketches.theta.DirectCompactOrderedSketch;
import com.yahoo.sketches.theta.DirectCompactSketch;
import com.yahoo.sketches.theta.HeapCompactOrderedSketch;
import com.yahoo.sketches.theta.HeapCompactSketch;
import com.yahoo.sketches.theta.Sketch;
import com.yahoo.sketches.theta.UpdateReturnState;
import com.yahoo.sketches.theta.UpdateSketchBuilder;
import java.nio.charset.StandardCharsets;

public abstract class UpdateSketch
extends Sketch {
    UpdateSketch() {
    }

    @Override
    public abstract boolean isEmpty();

    @Override
    public boolean isCompact() {
        return false;
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    public static final UpdateSketchBuilder builder() {
        return new UpdateSketchBuilder();
    }

    public abstract void reset();

    public CompactSketch compact(boolean dstOrdered, Memory dstMem) {
        CompactSketch sketchOut = null;
        int sw = (dstOrdered ? 2 : 0) | (dstMem != null ? 1 : 0);
        switch (sw) {
            case 0: {
                sketchOut = new HeapCompactSketch(this);
                break;
            }
            case 1: {
                sketchOut = new DirectCompactSketch(this, dstMem);
                break;
            }
            case 2: {
                sketchOut = new HeapCompactOrderedSketch(this);
                break;
            }
            case 3: {
                sketchOut = new DirectCompactOrderedSketch(this, dstMem);
            }
        }
        return sketchOut;
    }

    public CompactSketch compact() {
        return this.compact(true, null);
    }

    public abstract UpdateSketch rebuild();

    public abstract ResizeFactor getResizeFactor();

    public UpdateReturnState update(long datum) {
        long[] data = new long[]{datum};
        return this.hashUpdate(MurmurHash3.hash(data, this.getSeed())[0] >>> 1);
    }

    public UpdateReturnState update(double datum) {
        double d = datum == 0.0 ? 0.0 : datum;
        long[] data = new long[]{Double.doubleToLongBits(d)};
        return this.hashUpdate(MurmurHash3.hash(data, this.getSeed())[0] >>> 1);
    }

    public UpdateReturnState update(String datum) {
        if (datum == null || datum.isEmpty()) {
            return UpdateReturnState.RejectedNullOrEmpty;
        }
        byte[] data = datum.getBytes(StandardCharsets.UTF_8);
        return this.hashUpdate(MurmurHash3.hash(data, this.getSeed())[0] >>> 1);
    }

    public UpdateReturnState update(byte[] data) {
        if (data == null || data.length == 0) {
            return UpdateReturnState.RejectedNullOrEmpty;
        }
        return this.hashUpdate(MurmurHash3.hash(data, this.getSeed())[0] >>> 1);
    }

    public UpdateReturnState update(char[] data) {
        if (data == null || data.length == 0) {
            return UpdateReturnState.RejectedNullOrEmpty;
        }
        return this.hashUpdate(MurmurHash3.hash(data, this.getSeed())[0] >>> 1);
    }

    public UpdateReturnState update(int[] data) {
        if (data == null || data.length == 0) {
            return UpdateReturnState.RejectedNullOrEmpty;
        }
        return this.hashUpdate(MurmurHash3.hash(data, this.getSeed())[0] >>> 1);
    }

    public UpdateReturnState update(long[] data) {
        if (data == null || data.length == 0) {
            return UpdateReturnState.RejectedNullOrEmpty;
        }
        return this.hashUpdate(MurmurHash3.hash(data, this.getSeed())[0] >>> 1);
    }

    abstract UpdateReturnState hashUpdate(long var1);

    abstract int getLgArrLongs();

    abstract int getLgNomLongs();

    abstract int getLgResizeFactor();

    abstract float getP();

    abstract long getSeed();

    abstract boolean isDirty();
}

