/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.formula.geometry;

import java.util.Comparator;
import org.psjava.ds.geometry.Point2D;
import org.psjava.ds.numbersystrem.MultipliableNumberSystem;
import org.psjava.formula.geometry.CCW;
import org.psjava.formula.geometry.LeftTurnFromCCW;
import org.psjava.formula.geometry.RightTurnFromCCW;
import org.psjava.formula.geometry.StraightOrderFromCCW;

public class PointByDirectionComparator {
    public static <T> Comparator<Point2D<T>> create(final MultipliableNumberSystem<T> ns, final Point2D<T> center, final Point2D<T> basis) {
        return new Comparator<Point2D<T>>(){

            @Override
            public int compare(Point2D<T> p1, Point2D<T> p2) {
                int z2;
                int z1 = this.calcZoneOrder(p1);
                if (z1 != (z2 = this.calcZoneOrder(p2))) {
                    return z1 - z2;
                }
                if (z1 == 0 || z1 == 2) {
                    return 0;
                }
                Object ccw = CCW.ccw(ns, p1, center, p2);
                if (RightTurnFromCCW.is(ns, ccw)) {
                    return -1;
                }
                if (LeftTurnFromCCW.is(ns, ccw)) {
                    return 1;
                }
                return 0;
            }

            int calcZoneOrder(Point2D<T> p) {
                Object ccw = CCW.ccw(ns, basis, center, p);
                if (StraightOrderFromCCW.is(ns, basis, center, p, ccw)) {
                    return 2;
                }
                if (RightTurnFromCCW.is(ns, ccw)) {
                    return 1;
                }
                if (LeftTurnFromCCW.is(ns, ccw)) {
                    return 3;
                }
                return 0;
            }
        };
    }

    private PointByDirectionComparator() {
    }
}

