/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.corretto.crypto.provider;

import com.amazon.corretto.crypto.provider.AccessibleByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class InputBuffer<T, S, X extends Throwable>
implements Cloneable {
    private final int buffSize;
    private AccessibleByteArrayOutputStream buff;
    private boolean firstData = true;
    private S state;
    private ArrayStateConsumer<S> arrayUpdater;
    private FinalHandlerFunction<S, T, X> finalHandler;
    private StateSupplier<S> stateSupplier = object -> object;
    private Optional<Function<S, S>> stateCloner = Optional.empty();
    private Optional<ByteBufferBiConsumer<S>> bufferUpdater = Optional.empty();
    private Optional<ArrayFunction<S, RuntimeException>> initialArrayUpdater = Optional.empty();
    private Optional<ByteBufferFunction<S>> initialBufferUpdater = Optional.empty();
    private Optional<ArrayFunction<T, X>> singlePassArray = Optional.empty();

    InputBuffer(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Capacity must be positive");
        }
        this.buff = new AccessibleByteArrayOutputStream(0, n);
        this.buffSize = n;
    }

    public void reset() {
        this.buff.reset();
        this.firstData = true;
    }

    public int size() {
        return this.buff.size();
    }

    public InputBuffer<T, S, X> withInitialUpdater(ArrayFunction<S, RuntimeException> arrayFunction) {
        this.initialArrayUpdater = Optional.ofNullable(arrayFunction);
        return this;
    }

    public InputBuffer<T, S, X> withUpdater(ArrayStateConsumer<S> arrayStateConsumer) {
        this.arrayUpdater = arrayStateConsumer;
        return this;
    }

    public InputBuffer<T, S, X> withInitialUpdater(ByteBufferFunction<S> byteBufferFunction) {
        this.initialBufferUpdater = Optional.ofNullable(byteBufferFunction);
        return this;
    }

    public InputBuffer<T, S, X> withUpdater(ByteBufferBiConsumer<S> byteBufferBiConsumer) {
        this.bufferUpdater = Optional.ofNullable(byteBufferBiConsumer);
        return this;
    }

    public InputBuffer<T, S, X> withDoFinal(FinalHandlerFunction<S, T, X> finalHandlerFunction) {
        this.finalHandler = finalHandlerFunction;
        return this;
    }

    public InputBuffer<T, S, X> withSinglePass(ArrayFunction<T, X> arrayFunction) {
        this.singlePassArray = Optional.ofNullable(arrayFunction);
        return this;
    }

    public InputBuffer<T, S, X> withStateCloner(Function<S, S> function) {
        this.stateCloner = Optional.ofNullable(function);
        return this;
    }

    public InputBuffer<T, S, X> withInitialStateSupplier(StateSupplier<S> stateSupplier) {
        this.stateSupplier = stateSupplier;
        return this;
    }

    private boolean fillBuffer(byte[] byArray, int n, int n2) {
        if (this.buffSize - this.buff.size() < n2) {
            return false;
        }
        try {
            this.buff.write(byArray, n, n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(indexOutOfBoundsException.toString());
        }
        return true;
    }

    private boolean fillBuffer(byte by) {
        if (this.buffSize - this.buff.size() < 1) {
            return false;
        }
        try {
            this.buff.write(by);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(indexOutOfBoundsException.toString());
        }
        return true;
    }

    private boolean fillBuffer(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        if (this.buffSize - this.buff.size() < n) {
            return false;
        }
        this.buff.write(byteBuffer);
        return true;
    }

    private void processBuffer(boolean bl) {
        if (this.firstData && (bl || this.buff.size() > 0)) {
            if (this.initialArrayUpdater.isPresent()) {
                this.state = this.initialArrayUpdater.get().apply(this.buff.getDataBuffer(), 0, this.buff.size());
                this.buff.reset();
            } else {
                this.state = this.stateSupplier.apply(this.state);
            }
            this.firstData = false;
        }
        if (this.buff.size() > 0) {
            this.arrayUpdater.accept(this.state, this.buff.getDataBuffer(), 0, this.buff.size());
            this.buff.reset();
        }
    }

    public void update(ByteBuffer byteBuffer) {
        try {
            if (!byteBuffer.isDirect() || this.firstData && !this.initialBufferUpdater.isPresent() && !this.bufferUpdater.isPresent() || !this.firstData && !this.bufferUpdater.isPresent()) {
                ShimArray shimArray = new ShimArray(byteBuffer);
                this.update(shimArray.array, shimArray.offset, shimArray.length);
                return;
            }
            if (this.fillBuffer(byteBuffer)) {
                return;
            }
            this.processBuffer(false);
            if (this.fillBuffer(byteBuffer)) {
                return;
            }
            if (this.firstData) {
                if (this.initialBufferUpdater.isPresent()) {
                    this.state = this.initialBufferUpdater.get().apply(byteBuffer.slice());
                } else {
                    this.state = this.stateSupplier.apply(this.state);
                    this.bufferUpdater.get().accept(this.state, byteBuffer.slice());
                }
            } else {
                this.bufferUpdater.get().accept(this.state, byteBuffer.slice());
            }
            this.firstData = false;
        }
        finally {
            byteBuffer.position(byteBuffer.limit());
        }
    }

    public void update(byte[] byArray, int n, int n2) {
        if (this.fillBuffer(byArray, n, n2)) {
            return;
        }
        this.processBuffer(false);
        if (this.fillBuffer(byArray, n, n2)) {
            return;
        }
        if (this.firstData) {
            if (this.initialArrayUpdater.isPresent()) {
                this.state = this.initialArrayUpdater.get().apply(byArray, n, n2);
            } else {
                this.state = this.stateSupplier.apply(this.state);
                this.arrayUpdater.accept(this.state, byArray, n, n2);
            }
        } else {
            this.arrayUpdater.accept(this.state, byArray, n, n2);
        }
        this.firstData = false;
    }

    public void update(byte by) {
        if (this.fillBuffer(by)) {
            return;
        }
        this.processBuffer(false);
        if (this.fillBuffer(by)) {
            return;
        }
        throw new AssertionError((Object)"Unreachable code. Cannot buffer even a single byte");
    }

    public T doFinal() throws X {
        if (!this.firstData || !this.singlePassArray.isPresent()) {
            this.processBuffer(true);
            return this.finalHandler.apply(this.state);
        }
        return this.singlePassArray.get().apply(this.buff.getDataBuffer(), 0, this.buff.size());
    }

    protected InputBuffer<T, S, X> clone() throws CloneNotSupportedException {
        if (this.state != null && !this.stateCloner.isPresent()) {
            throw new CloneNotSupportedException("No stateCloner configured");
        }
        InputBuffer inputBuffer = (InputBuffer)super.clone();
        inputBuffer.state = this.state != null ? this.stateCloner.get().apply(this.state) : null;
        inputBuffer.buff = this.buff.clone();
        return inputBuffer;
    }

    private static class ShimArray {
        private final ByteBuffer backingBuffer;
        public final byte[] array;
        public final int offset;
        public final int length;

        public ShimArray(ByteBuffer byteBuffer) {
            byte[] byArray;
            this.backingBuffer = byteBuffer.slice();
            this.length = this.backingBuffer.limit();
            boolean bl = this.backingBuffer.hasArray();
            byte[] byArray2 = byArray = bl ? this.backingBuffer.array() : null;
            if (byArray == null) {
                byArray = new byte[this.length];
                this.backingBuffer.duplicate().get(byArray);
                this.offset = 0;
            } else {
                this.offset = this.backingBuffer.arrayOffset() + this.backingBuffer.position();
            }
            this.array = byArray;
        }
    }

    @FunctionalInterface
    public static interface StateSupplier<S>
    extends Function<S, S> {
        @Override
        public S apply(S var1);
    }

    @FunctionalInterface
    public static interface ByteBufferBiConsumer<S>
    extends BiConsumer<S, ByteBuffer> {
        @Override
        public void accept(S var1, ByteBuffer var2);
    }

    @FunctionalInterface
    public static interface ByteBufferFunction<S>
    extends Function<ByteBuffer, S> {
        @Override
        public S apply(ByteBuffer var1);
    }

    public static interface FinalHandlerFunction<T, R, X extends Throwable> {
        public R apply(T var1) throws X;
    }

    @FunctionalInterface
    public static interface ArrayFunction<T, X extends Throwable> {
        public T apply(byte[] var1, int var2, int var3) throws X;
    }

    @FunctionalInterface
    public static interface ArrayStateConsumer<S> {
        public void accept(S var1, byte[] var2, int var3, int var4);
    }
}

