/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sqlserver;

import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.dba.JdbcActionBuilder;
import org.apache.cayenne.dba.sqlserver.SQLServerBatchAction;
import org.apache.cayenne.dba.sqlserver.SQLServerProcedureAction;
import org.apache.cayenne.dba.sqlserver.SQLServerSelectAction;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.FluentSelect;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SelectQuery;

public class SQLServerActionBuilder
extends JdbcActionBuilder {
    private final Integer version;

    public SQLServerActionBuilder(DataNode dataNode) {
        this(dataNode, null);
    }

    public SQLServerActionBuilder(DataNode dataNode, Integer version) {
        super(dataNode);
        this.version = version;
    }

    @Override
    public SQLAction batchAction(BatchQuery query) {
        boolean useOptimisticLock = query.isUsingOptimisticLocking();
        boolean runningAsBatch = !useOptimisticLock && this.dataNode.getAdapter().supportsBatchUpdates();
        return new SQLServerBatchAction(query, this.dataNode, runningAsBatch);
    }

    @Override
    public SQLAction procedureAction(ProcedureQuery query) {
        return new SQLServerProcedureAction(query, this.dataNode);
    }

    @Override
    public <T> SQLAction objectSelectAction(SelectQuery<T> query) {
        return new SQLServerSelectAction(query, this.dataNode, this.needInMemoryOffset(query));
    }

    @Override
    public <T> SQLAction objectSelectAction(FluentSelect<T> query) {
        return new SQLServerSelectAction(query, this.dataNode, this.needInMemoryOffset(query));
    }

    private boolean needInMemoryOffset(SelectQuery<?> query) {
        return query.getOrderings() == null || query.getOrderings().size() == 0 || this.version == null || this.version < 12;
    }

    private boolean needInMemoryOffset(FluentSelect<?> query) {
        return query.getOrderings() == null || query.getOrderings().size() == 0 || this.version == null || this.version < 12;
    }
}

