/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Random;
import org.apache.commons.io.input.CharSequenceInputStream;
import org.apache.commons.io.input.DemuxInputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.DemuxOutputStream;
import org.apache.commons.io.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DemuxInputStreamTest {
    private static final Random RANDOM = new Random();
    private static final String DATA1 = "Data for thread1";
    private static final String DATA2 = "Data for thread2";
    private static final String DATA3 = "Data for thread3";
    private static final String DATA4 = "Data for thread4";
    private static final String T1 = "Thread1";
    private static final String T2 = "Thread2";
    private static final String T3 = "Thread3";
    private static final String T4 = "Thread4";
    private final HashMap<String, ByteArrayOutputStream> outputMap = new HashMap();
    private final HashMap<String, Thread> threadMap = new HashMap();

    DemuxInputStreamTest() {
    }

    private void doJoin() throws InterruptedException {
        for (String name : this.threadMap.keySet()) {
            Thread thread = this.threadMap.get(name);
            thread.join();
        }
    }

    private void doStart() {
        this.threadMap.keySet().forEach(name -> this.threadMap.get(name).start());
    }

    private String getInput(String threadName) {
        ReaderThread thread = (ReaderThread)this.threadMap.get(threadName);
        Assertions.assertNotNull((Object)thread, (String)"getInput()");
        return thread.getData();
    }

    private String getOutput(String threadName) {
        ByteArrayOutputStream output = this.outputMap.get(threadName);
        Assertions.assertNotNull((Object)output, (String)"getOutput()");
        return output.toString(StandardCharsets.UTF_8);
    }

    private void startReader(String name, String data, DemuxInputStream demux) {
        CharSequenceInputStream input = ((CharSequenceInputStream.Builder)CharSequenceInputStream.builder().setCharSequence((CharSequence)data)).get();
        ReaderThread thread = new ReaderThread(name, (InputStream)input, demux);
        this.threadMap.put(name, thread);
    }

    private void startWriter(String name, String data, DemuxOutputStream demux) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.outputMap.put(name, output);
        WriterThread thread = new WriterThread(name, data, (OutputStream)output, demux);
        this.threadMap.put(name, thread);
    }

    @Test
    void testInputStream() throws Exception {
        try (DemuxInputStream input = new DemuxInputStream();){
            this.startReader(T1, DATA1, input);
            this.startReader(T2, DATA2, input);
            this.startReader(T3, DATA3, input);
            this.startReader(T4, DATA4, input);
            this.doStart();
            this.doJoin();
            Assertions.assertEquals((Object)DATA1, (Object)this.getInput(T1), (String)"Data1");
            Assertions.assertEquals((Object)DATA2, (Object)this.getInput(T2), (String)"Data2");
            Assertions.assertEquals((Object)DATA3, (Object)this.getInput(T3), (String)"Data3");
            Assertions.assertEquals((Object)DATA4, (Object)this.getInput(T4), (String)"Data4");
        }
    }

    @Test
    void testOutputStream() throws Exception {
        try (DemuxOutputStream output = new DemuxOutputStream();){
            this.startWriter(T1, DATA1, output);
            this.startWriter(T2, DATA2, output);
            this.startWriter(T3, DATA3, output);
            this.startWriter(T4, DATA4, output);
            this.doStart();
            this.doJoin();
            Assertions.assertEquals((Object)DATA1, (Object)this.getOutput(T1), (String)"Data1");
            Assertions.assertEquals((Object)DATA2, (Object)this.getOutput(T2), (String)"Data2");
            Assertions.assertEquals((Object)DATA3, (Object)this.getOutput(T3), (String)"Data3");
            Assertions.assertEquals((Object)DATA4, (Object)this.getOutput(T4), (String)"Data4");
        }
    }

    @Test
    void testReadEOF() throws Exception {
        try (DemuxInputStream input = new DemuxInputStream();){
            Assertions.assertEquals((int)-1, (int)input.read());
        }
    }

    private static final class ReaderThread
    extends Thread {
        private final DemuxInputStream demuxInputStream;
        private final InputStream inputStream;
        private final StringBuffer stringBuffer = new StringBuffer();

        ReaderThread(String name, InputStream input, DemuxInputStream demux) {
            super(name);
            this.inputStream = input;
            this.demuxInputStream = demux;
        }

        public String getData() {
            return this.stringBuffer.toString();
        }

        @Override
        public void run() {
            this.demuxInputStream.bindStream(this.inputStream);
            try {
                int ch = this.demuxInputStream.read();
                while (-1 != ch) {
                    this.stringBuffer.append((char)ch);
                    int sleepMillis = Math.abs(RANDOM.nextInt() % 10);
                    TestUtils.sleep(sleepMillis);
                    ch = this.demuxInputStream.read();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static final class WriterThread
    extends Thread {
        private final byte[] byteArray;
        private final DemuxOutputStream demuxOutputStream;
        private final OutputStream outputStream;

        WriterThread(String name, String data, OutputStream output, DemuxOutputStream demux) {
            super(name);
            this.outputStream = output;
            this.demuxOutputStream = demux;
            this.byteArray = data.getBytes();
        }

        @Override
        public void run() {
            this.demuxOutputStream.bindStream(this.outputStream);
            for (byte element : this.byteArray) {
                try {
                    this.demuxOutputStream.write((int)element);
                    int sleepMillis = Math.abs(RANDOM.nextInt() % 10);
                    TestUtils.sleep(sleepMillis);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

