/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.javascript;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.common.xmlschema.XmlSchemaUtils;
import org.apache.cxf.javascript.ItemInfo;
import org.apache.cxf.javascript.JavascriptUtils;
import org.apache.cxf.javascript.NamespacePrefixAccumulator;
import org.apache.cxf.javascript.UnsupportedConstruct;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaChoice;
import org.apache.ws.commons.schema.XmlSchemaChoiceMember;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSequenceMember;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.constants.Constants;

public final class ParticleInfo
implements ItemInfo {
    private static final Logger LOG = LogUtils.getL7dLogger(ParticleInfo.class);
    private XmlSchemaParticle particle;
    private String javascriptName;
    private String xmlName;
    private XmlSchemaType containingType;
    private XmlSchemaType type;
    private boolean empty;
    private boolean isGroup;
    private List<ParticleInfo> children;
    private long minOccurs;
    private long maxOccurs;
    private boolean nillable;
    private boolean any;
    private boolean anyType;
    private String defaultValue;
    private boolean global;

    private ParticleInfo() {
    }

    public static ParticleInfo forGlobalElement(XmlSchemaElement element, XmlSchema currentSchema, SchemaCollection schemaCollection, NamespacePrefixAccumulator prefixAccumulator) {
        ParticleInfo elementInfo = new ParticleInfo();
        elementInfo.particle = element;
        elementInfo.minOccurs = element.getMinOccurs();
        elementInfo.maxOccurs = element.getMaxOccurs();
        elementInfo.nillable = element.isNillable();
        elementInfo.global = true;
        ParticleInfo.factoryCommon((XmlSchemaParticle)element, currentSchema, schemaCollection, prefixAccumulator, elementInfo);
        return elementInfo;
    }

    public static ParticleInfo forPartElement(XmlSchemaElement element, SchemaCollection schemaCollection, String javascriptName, String xmlElementName) {
        ParticleInfo elementInfo = new ParticleInfo();
        elementInfo.particle = element;
        if (element == null) {
            elementInfo.minOccurs = 1L;
            elementInfo.maxOccurs = 1L;
        } else {
            elementInfo.minOccurs = element.getMinOccurs();
            elementInfo.maxOccurs = element.getMaxOccurs();
            elementInfo.nillable = element.isNillable();
            ParticleInfo.factorySetupType(element, schemaCollection, elementInfo);
        }
        elementInfo.javascriptName = javascriptName;
        elementInfo.xmlName = xmlElementName;
        elementInfo.global = true;
        return elementInfo;
    }

    public static ParticleInfo forLocalItem(XmlSchemaObject sequenceObject, XmlSchema currentSchema, SchemaCollection schemaCollection, NamespacePrefixAccumulator prefixAccumulator, QName contextName) {
        XmlSchemaParticle sequenceParticle = JavascriptUtils.getObjectParticle(sequenceObject, contextName, currentSchema);
        ParticleInfo elementInfo = new ParticleInfo();
        XmlSchemaParticle realParticle = sequenceParticle;
        elementInfo.setMinOccurs(sequenceParticle.getMinOccurs());
        elementInfo.setMaxOccurs(sequenceParticle.getMaxOccurs());
        if (sequenceParticle instanceof XmlSchemaElement) {
            XmlSchemaElement sequenceElement = (XmlSchemaElement)sequenceParticle;
            if (sequenceElement.getRef().getTargetQName() != null) {
                XmlSchemaElement refElement = (XmlSchemaElement)sequenceElement.getRef().getTarget();
                if (refElement == null) {
                    Message message = new Message("ELEMENT_DANGLING_REFERENCE", LOG, new Object[]{sequenceElement.getQName(), sequenceElement.getRef().getTargetQName()});
                    throw new UnsupportedConstruct(message.toString());
                }
                realParticle = refElement;
                elementInfo.global = true;
            }
            elementInfo.nillable = ((XmlSchemaElement)realParticle).isNillable();
        } else if (sequenceParticle instanceof XmlSchemaChoice) {
            XmlSchemaChoice choice = (XmlSchemaChoice)sequenceParticle;
            if (sequenceParticle.getMaxOccurs() > 1L) {
                Message message = new Message("GROUP_ELEMENT_MULTI_OCCURS", LOG, new Object[]{sequenceParticle.getClass().getSimpleName()});
                throw new UnsupportedConstruct(message.toString());
            }
            elementInfo.children = new LinkedList<ParticleInfo>();
            List items = choice.getItems();
            for (XmlSchemaChoiceMember item : items) {
                XmlSchemaParticle schemaObject = JavascriptUtils.getObjectParticle((XmlSchemaObject)item, contextName, currentSchema);
                ParticleInfo childParticle = ParticleInfo.forLocalItem((XmlSchemaObject)schemaObject, currentSchema, schemaCollection, prefixAccumulator, contextName);
                if (childParticle.isAny()) {
                    Message message = new Message("GROUP_ELEMENT_ANY", LOG, new Object[]{sequenceParticle.getClass().getSimpleName()});
                    throw new UnsupportedConstruct(message.toString());
                }
                childParticle.setMinOccurs(0L);
                elementInfo.children.add(childParticle);
            }
        } else if (sequenceParticle instanceof XmlSchemaSequence) {
            XmlSchemaSequence nestedSequence = (XmlSchemaSequence)sequenceParticle;
            if (sequenceParticle.getMaxOccurs() > 1L) {
                Message message = new Message("SEQUENCE_ELEMENT_MULTI_OCCURS", LOG, new Object[]{sequenceParticle.getClass().getSimpleName()});
                throw new UnsupportedConstruct(message.toString());
            }
            elementInfo.children = new LinkedList<ParticleInfo>();
            List items = nestedSequence.getItems();
            for (XmlSchemaSequenceMember item : items) {
                XmlSchemaParticle schemaObject = JavascriptUtils.getObjectParticle((XmlSchemaObject)item, contextName, currentSchema);
                ParticleInfo childParticle = ParticleInfo.forLocalItem((XmlSchemaObject)schemaObject, currentSchema, schemaCollection, prefixAccumulator, contextName);
                if (childParticle.isAny()) {
                    Message message = new Message("SEQUENCE_ELEMENT_ANY", LOG, new Object[]{sequenceParticle.getClass().getSimpleName()});
                    throw new UnsupportedConstruct(message.toString());
                }
                if (sequenceParticle.getMinOccurs() == 0L) {
                    childParticle.setMinOccurs(0L);
                }
                elementInfo.children.add(childParticle);
            }
        }
        ParticleInfo.factoryCommon(realParticle, currentSchema, schemaCollection, prefixAccumulator, elementInfo);
        elementInfo.particle = realParticle;
        return elementInfo;
    }

    private static void factoryCommon(XmlSchemaParticle particle, XmlSchema currentSchema, SchemaCollection schemaCollection, NamespacePrefixAccumulator prefixAccumulator, ParticleInfo elementInfo) {
        if (particle instanceof XmlSchemaElement) {
            XmlSchemaElement element = (XmlSchemaElement)particle;
            QName elementQName = XmlSchemaUtils.getElementQualifiedName((XmlSchemaElement)element, (XmlSchema)currentSchema);
            String elementNamespaceURI = elementQName.getNamespaceURI();
            boolean elementNoNamespace = "".equals(elementNamespaceURI);
            XmlSchema elementSchema = null;
            if (!elementNoNamespace && (elementSchema = schemaCollection.getSchemaByTargetNamespace(elementNamespaceURI)) == null) {
                throw new RuntimeException("Missing schema " + elementNamespaceURI);
            }
            boolean qualified = !elementNoNamespace && XmlSchemaUtils.isElementQualified((XmlSchemaElement)element, (boolean)true, (XmlSchema)currentSchema, (XmlSchema)elementSchema);
            elementInfo.xmlName = prefixAccumulator.xmlElementString(elementQName, qualified);
            elementInfo.javascriptName = elementQName.getLocalPart();
            String schemaDefaultValue = element.getDefaultValue();
            elementInfo.defaultValue = schemaDefaultValue = ParticleInfo.protectDefaultValue(schemaDefaultValue);
            ParticleInfo.factorySetupType(element, schemaCollection, elementInfo);
            elementInfo.isGroup = false;
        } else if (particle instanceof XmlSchemaChoice) {
            elementInfo.isGroup = true;
        } else if (particle instanceof XmlSchemaSequence) {
            elementInfo.isGroup = true;
        } else {
            elementInfo.any = true;
            elementInfo.xmlName = null;
            elementInfo.javascriptName = "any";
            elementInfo.type = null;
            elementInfo.isGroup = false;
        }
    }

    private static String protectDefaultValue(String schemaDefaultValue) {
        if (schemaDefaultValue == null) {
            return null;
        }
        boolean leaveAlone = false;
        try {
            Long.parseLong(schemaDefaultValue);
            leaveAlone = true;
        }
        catch (NumberFormatException nfe) {
            try {
                Double.parseDouble(schemaDefaultValue);
                leaveAlone = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!leaveAlone) {
            StringBuilder builder = new StringBuilder();
            builder.append('\'');
            for (char c : schemaDefaultValue.toCharArray()) {
                if (c == '\'') {
                    builder.append("\\'");
                    continue;
                }
                if (c == '\\') {
                    builder.append("\\\\");
                    continue;
                }
                builder.append(c);
            }
            builder.append('\'');
            schemaDefaultValue = builder.toString();
        }
        return schemaDefaultValue;
    }

    private static void factorySetupType(XmlSchemaElement element, SchemaCollection schemaCollection, ParticleInfo elementInfo) {
        elementInfo.type = element.getSchemaType();
        if (elementInfo.type == null) {
            if (element.getSchemaTypeName() == null || element.getSchemaTypeName().equals(Constants.XSD_ANYTYPE)) {
                elementInfo.anyType = true;
            } else {
                elementInfo.type = schemaCollection.getTypeByQName(element.getSchemaTypeName());
                if (elementInfo.type == null && !element.getSchemaTypeName().getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                    throw JavascriptUtils.unsupportedConstruct("MISSING_TYPE", element.getSchemaTypeName().toString(), element.getQName(), (XmlSchemaObject)element);
                }
            }
        } else if (elementInfo.type.getQName() != null && Constants.XSD_ANYTYPE.equals(elementInfo.type.getQName())) {
            elementInfo.anyType = true;
        }
    }

    public QName getControllingName() {
        XmlSchemaElement element;
        if (this.type != null && this.type.getQName() != null) {
            return this.type.getQName();
        }
        if (this.particle instanceof XmlSchemaElement && (element = (XmlSchemaElement)this.particle).getQName() != null) {
            return element.getQName();
        }
        Message message = new Message("IMPOSSIBLE_GLOBAL_ITEM", LOG, new Object[]{JavascriptUtils.cleanedUpSchemaSource((XmlSchemaObject)this.particle)});
        LOG.severe(message.toString());
        throw new UnsupportedConstruct(message);
    }

    public XmlSchemaParticle getParticle() {
        return this.particle;
    }

    @Override
    public String getJavascriptName() {
        return this.javascriptName;
    }

    public void setJavascriptName(String name) {
        this.javascriptName = name;
    }

    public String getXmlName() {
        return this.xmlName;
    }

    public void setXmlName(String elementXmlName) {
        this.xmlName = elementXmlName;
    }

    public XmlSchemaType getContainingType() {
        return this.containingType;
    }

    public void setContainingType(XmlSchemaType containingType) {
        this.containingType = containingType;
    }

    @Override
    public XmlSchemaType getType() {
        return this.type;
    }

    public void setType(XmlSchemaType type) {
        this.type = type;
    }

    public boolean isGroup() {
        return this.isGroup;
    }

    public List<ParticleInfo> getChildren() {
        return this.children;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    public long getMinOccurs() {
        return this.minOccurs;
    }

    private void setMinOccurs(long value) {
        this.minOccurs = value;
        if (this.isGroup()) {
            for (ParticleInfo child : this.getChildren()) {
                child.setMinOccurs(value);
            }
        }
    }

    public long getMaxOccurs() {
        return this.maxOccurs;
    }

    private void setMaxOccurs(long value) {
        this.maxOccurs = value;
        if (this.isGroup()) {
            for (ParticleInfo child : this.getChildren()) {
                child.setMaxOccurs(value);
            }
        }
    }

    @Override
    public boolean isArray() {
        return this.maxOccurs > 1L;
    }

    @Override
    public boolean isOptional() {
        return this.minOccurs == 0L && this.maxOccurs == 1L;
    }

    @Override
    public boolean isNillable() {
        return this.nillable;
    }

    @Override
    public boolean isAny() {
        return this.any;
    }

    public boolean isAnyType() {
        return this.anyType;
    }

    @Override
    public String getDefaultValue() {
        if (this.isOptional()) {
            return "null";
        }
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public String toString() {
        return "ItemInfo: " + this.javascriptName;
    }
}

