/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.drivers;

import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.activemq.artemis.journal.ActiveMQJournalLogger;
import org.apache.activemq.artemis.utils.ClassloadingUtil;
import org.apache.commons.beanutils.BeanUtilsBean;

public class JDBCDataSourceUtils {
    public static DataSource getDataSource(String dataSourceClassName, Map<String, Object> dataSourceProperties) {
        ActiveMQJournalLogger.LOGGER.initializingJdbcDataSource(dataSourceClassName, dataSourceProperties.keySet().stream().map(key -> key + "=" + String.valueOf(key.equalsIgnoreCase("password") ? "****" : dataSourceProperties.get(key))).collect(Collectors.joining(", ", "{", "}")));
        try {
            DataSource dataSource = (DataSource)ClassloadingUtil.getInstanceWithTypeCheck((String)dataSourceClassName, DataSource.class, (ClassLoader)JDBCDataSourceUtils.class.getClassLoader());
            for (Map.Entry<String, Object> entry : dataSourceProperties.entrySet()) {
                BeanUtilsBean.getInstance().setProperty((Object)dataSource, entry.getKey(), entry.getValue());
            }
            return dataSource;
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Could not find class: " + dataSourceClassName);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate DataSource", e);
        }
    }
}

