/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config;

import java.io.Serializable;
import java.util.Objects;

public class WildcardConfiguration
implements Serializable {
    public static final WildcardConfiguration DEFAULT_WILDCARD_CONFIGURATION = new WildcardConfiguration();
    private static final long serialVersionUID = 1L;
    static final char SINGLE_WORD = '*';
    static final char ANY_WORDS = '#';
    static final char DELIMITER = '.';
    static final char ESCAPE = '\\';
    boolean routingEnabled = true;
    char singleWord = (char)42;
    char anyWords = (char)35;
    char delimiter = (char)46;
    String singleWordString = String.valueOf(this.singleWord);
    String anyWordsString = String.valueOf(this.anyWords);
    String delimiterString = String.valueOf(this.delimiter);
    String escapeString = String.valueOf('\\');

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof WildcardConfiguration)) {
            return false;
        }
        WildcardConfiguration other = (WildcardConfiguration)obj;
        return this.routingEnabled == other.routingEnabled && this.singleWord == other.singleWord && this.anyWords == other.anyWords && this.delimiter == other.delimiter;
    }

    public int hashCode() {
        return Objects.hash(this.routingEnabled, Character.valueOf(this.singleWord), Character.valueOf(this.anyWords), Character.valueOf(this.delimiter));
    }

    public String toString() {
        return "WildcardConfiguration{routingEnabled=" + this.routingEnabled + ", anyWords=" + this.anyWords + ", singleWord=" + this.singleWord + ", delimiter=" + this.delimiter + "}";
    }

    public boolean isRoutingEnabled() {
        return this.routingEnabled;
    }

    public WildcardConfiguration setRoutingEnabled(boolean routingEnabled) {
        this.routingEnabled = routingEnabled;
        return this;
    }

    public char getAnyWords() {
        return this.anyWords;
    }

    public String getAnyWordsString() {
        return this.anyWordsString;
    }

    public WildcardConfiguration setAnyWords(char anyWords) {
        this.anyWords = anyWords;
        this.anyWordsString = String.valueOf(anyWords);
        return this;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public String getDelimiterString() {
        return this.delimiterString;
    }

    public WildcardConfiguration setDelimiter(char delimiter) {
        this.delimiter = delimiter;
        this.delimiterString = String.valueOf(delimiter);
        return this;
    }

    public char getSingleWord() {
        return this.singleWord;
    }

    public String getSingleWordString() {
        return this.singleWordString;
    }

    public WildcardConfiguration setSingleWord(char singleWord) {
        this.singleWord = singleWord;
        this.singleWordString = String.valueOf(singleWord);
        return this;
    }

    public String convert(String input, WildcardConfiguration target) {
        if (this.equals(target)) {
            return input;
        }
        boolean escaped = this.isEscaped(input);
        StringBuilder result = !escaped ? new StringBuilder(target.escape(input, this)) : new StringBuilder(input);
        this.replaceChar(result, this.getDelimiter(), target.getDelimiter());
        this.replaceChar(result, this.getSingleWord(), target.getSingleWord());
        this.replaceChar(result, this.getAnyWords(), target.getAnyWords());
        if (escaped) {
            return this.unescape(result.toString());
        }
        return result.toString();
    }

    public boolean isWild(CharSequence input) {
        if (input == null || input.isEmpty()) {
            return false;
        }
        if (input.charAt(0) == this.getSingleWord() || input.charAt(0) == this.getAnyWords()) {
            return true;
        }
        for (int i = 1; i < input.length(); ++i) {
            if (input.charAt(i) != this.getSingleWord() && input.charAt(i) != this.getAnyWords() || input.charAt(i - 1) == '\\') continue;
            return true;
        }
        return false;
    }

    private String escape(String input, WildcardConfiguration from) {
        String result = input.replace(this.escapeString, this.escapeString + this.escapeString);
        if (this.delimiter != from.getDelimiter()) {
            result = result.replace(this.getDelimiterString(), this.escapeString + this.getDelimiterString());
        }
        if (this.singleWord != from.getSingleWord()) {
            result = result.replace(this.getSingleWordString(), this.escapeString + this.getSingleWordString());
        }
        if (this.anyWords != from.getAnyWords()) {
            result = result.replace(this.getAnyWordsString(), this.escapeString + this.getAnyWordsString());
        }
        return result;
    }

    private String unescape(String input) {
        return input.replace(this.escapeString + this.escapeString, this.escapeString).replace("\\" + this.getDelimiterString(), this.getDelimiterString()).replace("\\" + this.getSingleWordString(), this.getSingleWordString()).replace("\\" + this.getAnyWordsString(), this.getAnyWordsString());
    }

    private boolean isEscaped(CharSequence input) {
        for (int i = 0; i < input.length() - 1; ++i) {
            if (input.charAt(i) != '\\' || input.charAt(i + 1) != this.getDelimiter() && input.charAt(i + 1) != this.getSingleWord() && input.charAt(i + 1) != this.getAnyWords()) continue;
            return true;
        }
        return false;
    }

    private void replaceChar(StringBuilder result, char replace, char replacement) {
        if (replace == replacement) {
            return;
        }
        for (int i = 0; i < result.length(); ++i) {
            if (result.charAt(i) != replace || i != 0 && result.charAt(i - 1) == '\\') continue;
            result.setCharAt(i, replacement);
        }
    }
}

