/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.clustering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.clustering.FailoverStrategy;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;

public abstract class AbstractStaticFailoverStrategy
implements FailoverStrategy {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractStaticFailoverStrategy.class);
    private List<String> alternateAddresses;
    private long delayBetweenRetries;

    public void setDelayBetweenRetries(long delay) {
        this.delayBetweenRetries = delay;
    }

    public long getDelayBetweenRetries() {
        return this.delayBetweenRetries;
    }

    public void setAlternateAddresses(List<String> alternateAddresses) {
        this.alternateAddresses = alternateAddresses;
    }

    @Override
    public List<String> getAlternateAddresses(Exchange exchange) {
        return this.alternateAddresses != null ? new ArrayList<String>(this.alternateAddresses) : null;
    }

    @Override
    public String selectAlternateAddress(List<String> alternates) {
        String selected = null;
        if (alternates != null && !alternates.isEmpty()) {
            selected = this.getNextAlternate(alternates);
        }
        if (selected != null) {
            Level level = this.getLogLevel();
            if (LOG.isLoggable(level)) {
                LOG.log(level, "FAILING_OVER_TO_ADDRESS_OVERRIDE", selected);
            }
        } else {
            LOG.warning("NO_ALTERNATE_TARGETS_REMAIN");
        }
        return selected;
    }

    @Override
    public List<Endpoint> getAlternateEndpoints(Exchange exchange) {
        return this.getEndpoints(exchange, false);
    }

    @Override
    public Endpoint selectAlternateEndpoint(List<Endpoint> alternates) {
        Endpoint selected = null;
        if (alternates != null && !alternates.isEmpty()) {
            selected = this.getNextAlternate(alternates);
        }
        if (selected != null) {
            Level level = this.getLogLevel();
            if (LOG.isLoggable(level)) {
                LOG.log(level, "FAILING_OVER_TO_ALTERNATE_ENDPOINT", new Object[]{selected.getEndpointInfo().getName(), selected.getEndpointInfo().getAddress()});
            }
        } else {
            LOG.warning("NO_ALTERNATE_TARGETS_REMAIN");
        }
        return selected;
    }

    protected List<Endpoint> getEndpoints(Exchange exchange, boolean acceptCandidatesWithSameAddress) {
        Endpoint endpoint = exchange.getEndpoint();
        List services = endpoint.getService().getServiceInfos();
        if (services.isEmpty() && acceptCandidatesWithSameAddress) {
            return new ArrayList<Endpoint>(Collections.singleton(endpoint));
        }
        QName currentBinding = endpoint.getBinding().getBindingInfo().getName();
        ArrayList<Endpoint> alternates = new ArrayList<Endpoint>();
        for (ServiceInfo service : services) {
            Collection candidates = service.getEndpoints();
            for (EndpointInfo candidate : candidates) {
                QName candidateBinding = candidate.getBinding().getName();
                if (candidateBinding.equals(currentBinding)) {
                    Endpoint alternate;
                    if (!acceptCandidatesWithSameAddress && candidate.getAddress().equals(endpoint.getEndpointInfo().getAddress()) || (alternate = (Endpoint)endpoint.getService().getEndpoints().get(candidate.getName())) == null) continue;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "FAILOVER_CANDIDATE_ACCEPTED", candidate.getName());
                    }
                    alternates.add(alternate);
                    continue;
                }
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.log(Level.FINE, "FAILOVER_CANDIDATE_REJECTED", new Object[]{candidate.getName(), candidateBinding});
            }
        }
        return alternates;
    }

    protected abstract <T> T getNextAlternate(List<T> var1);

    protected Level getLogLevel() {
        return Level.WARNING;
    }
}

