/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.EntityPart;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.Providers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;
import org.apache.cxf.jaxrs.ext.multipart.InputStreamDataSource;
import org.apache.cxf.jaxrs.ext.multipart.MultipartOutputFilter;
import org.apache.cxf.jaxrs.impl.EntityPartImpl;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.multipart.AttachmentUtils;

@Consumes(value={"multipart/form-data"})
@Produces(value={"multipart/form-data"})
@Provider
public class EntityPartProvider
extends AbstractConfigurableProvider
implements MessageBodyReader<List<EntityPart>>,
MessageBodyWriter<List<EntityPart>> {
    private static final Logger LOG = LogUtils.getL7dLogger(EntityPartProvider.class);
    @Context
    private Providers providers;
    @Context
    private MessageContext mc;
    private String attachmentDir;
    private String attachmentThreshold;
    private String attachmentMaxSize;

    public void setAttachmentDirectory(String dir) {
        this.attachmentDir = dir;
    }

    public void setAttachmentThreshold(String threshold) {
        this.attachmentThreshold = threshold;
    }

    public void setAttachmentMaxSize(String maxSize) {
        this.attachmentMaxSize = maxSize;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        Type arg;
        if (List.class.isAssignableFrom(type) && ParameterizedType.class.isInstance(genericType) && (arg = ((ParameterizedType)genericType).getActualTypeArguments()[0]) instanceof Class) {
            return EntityPart.class.isAssignableFrom((Class)arg);
        }
        return false;
    }

    public void writeTo(List<EntityPart> parts, Class<?> type, Type genericType, Annotation[] anns, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream os) throws IOException, WebApplicationException {
        List<Attachment> handlers = EntityPartProvider.convertToDataHandlers(parts, type, genericType, anns);
        if (this.mc.get("multipart.output.filters") != null) {
            List filters = CastUtils.cast((List)((List)this.mc.get("multipart.output.filters")));
            for (MultipartOutputFilter filter : filters) {
                filter.filter(handlers);
            }
        }
        this.mc.put("org.apache.cxf.jaxrs.attachments.outbound", handlers);
        handlers.get(0).getDataHandler().writeTo(os);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        Type arg;
        if (List.class.isAssignableFrom(type) && ParameterizedType.class.isInstance(genericType) && (arg = ((ParameterizedType)genericType).getActualTypeArguments()[0]) instanceof Class) {
            return EntityPart.class.isAssignableFrom((Class)arg);
        }
        return false;
    }

    public List<EntityPart> readFrom(Class<List<EntityPart>> type, Type genericType, Annotation[] anns, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream is) throws IOException, WebApplicationException {
        this.checkContentLength();
        List<Attachment> infos = AttachmentUtils.getAttachments(this.mc, this.attachmentDir, this.attachmentThreshold, this.attachmentMaxSize);
        ArrayList<EntityPart> parts = new ArrayList<EntityPart>();
        for (Attachment a : infos) {
            parts.add(this.fromAttachment(a, InputStream.class, genericType, anns, headers, mediaType));
        }
        return parts;
    }

    private <T> EntityPart fromAttachment(Attachment attachment, Class<T> c, Type type, Annotation[] anns, MultivaluedMap<String, String> headers, MediaType mediaType) throws IOException {
        GenericType genericType = type != null ? new GenericType(type) : null;
        MessageBodyReader r = this.providers.getMessageBodyReader(c, type, anns, attachment.getContentType());
        if (r != null) {
            InputStream is = attachment.getDataHandler().getInputStream();
            ContentDisposition cd = attachment.getContentDisposition();
            String fileName = cd != null ? cd.getFilename() : null;
            String cdName = cd == null ? null : cd.getParameter("name");
            String contentId = attachment.getContentId();
            if (!StringUtils.isEmpty((String)fileName)) {
                return new EntityPartImpl(this.mc.getProviders(), contentId, fileName, is, c, genericType, attachment.getHeaders(), attachment.getContentType());
            }
            String name = StringUtils.isEmpty((String)cdName) ? contentId : cdName.replace("\"", "").replace("'", "");
            return new EntityPartImpl(this.mc.getProviders(), name, null, is, c, genericType, attachment.getHeaders(), attachment.getContentType());
        }
        throw ExceptionUtils.toBadRequestException(null, null);
    }

    protected void checkContentLength() {
        if (this.mc != null && this.isPayloadEmpty(this.mc.getHttpHeaders())) {
            String message = new Message("EMPTY_BODY", BUNDLE, new Object[0]).toString();
            LOG.warning(message);
            throw new WebApplicationException(400);
        }
    }

    private static <T> List<Attachment> convertToDataHandlers(List<EntityPart> parts, Class<T> type, Type genericType, Annotation[] anns) throws IOException {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>(parts.size());
        for (EntityPart part : parts) {
            attachments.add(EntityPartProvider.createDataHandler(part, type, genericType, anns));
        }
        return attachments;
    }

    private static <T> Attachment createDataHandler(EntityPart part, Class<T> type, Type genericType, Annotation[] anns) throws IOException {
        String mt = Objects.requireNonNullElse(part.getMediaType(), MediaType.APPLICATION_OCTET_STREAM_TYPE).toString();
        MultivaluedHashMap headers = new MultivaluedHashMap();
        if (part.getHeaders() != null) {
            headers.putAll((Map)part.getHeaders());
        }
        return part.getFileName().map(fileName -> {
            ContentDisposition cd = new ContentDisposition("form-data;name=file;filename=" + fileName);
            return new Attachment(part.getName(), part.getContent(), cd);
        }).orElseGet(() -> EntityPartProvider.lambda$createDataHandler$1((MultivaluedMap)headers, mt, part));
    }

    private static /* synthetic */ Attachment lambda$createDataHandler$1(MultivaluedMap headers, String mt, EntityPart part) {
        headers.putSingle((Object)"Content-Type", (Object)mt);
        return new Attachment(part.getName(), new DataHandler((DataSource)new InputStreamDataSource(part.getContent(), mt)), (MultivaluedMap<String, String>)headers);
    }
}

