/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.hll;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.hll.AbstractHllArray;
import org.apache.datasketches.hll.CurMode;
import org.apache.datasketches.hll.DirectHllArray;
import org.apache.datasketches.hll.HllArray;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.HllUnion;
import org.apache.datasketches.hll.HllUtil;
import org.apache.datasketches.hll.TgtHllType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UnionCaseTest {
    private static final String LS = System.getProperty("line.separator");
    long v = 0L;
    static final int maxLgK = 12;
    HllSketch source;
    String hfmt = "%10s%10s%10s%10s%10s%10s%10s%10s%10s%10s%10s" + LS;
    String hdr = String.format(this.hfmt, "caseNum", "srcLgKStr", "gdtLgKStr", "srcType", "gdtType", "srcSeg", "gdtSeg", "srcMode", "gdtMode", "srcOoof", "gdtOoof");

    @Test
    public void checkAllCases() {
        int i;
        UnionCaseTest.print(this.hdr);
        for (i = 0; i < 24; ++i) {
            this.checkCase(i, TgtHllType.HLL_4, false);
        }
        UnionCaseTest.println("");
        UnionCaseTest.print(this.hdr);
        for (i = 0; i < 24; ++i) {
            this.checkCase(i, TgtHllType.HLL_6, false);
        }
        UnionCaseTest.println("");
        UnionCaseTest.print(this.hdr);
        for (i = 0; i < 24; ++i) {
            this.checkCase(i, TgtHllType.HLL_8, false);
        }
        UnionCaseTest.println("");
        UnionCaseTest.print(this.hdr);
        for (i = 0; i < 24; ++i) {
            this.checkCase(i, TgtHllType.HLL_4, true);
        }
        UnionCaseTest.println("");
        UnionCaseTest.print(this.hdr);
        for (i = 0; i < 24; ++i) {
            this.checkCase(i, TgtHllType.HLL_6, true);
        }
        UnionCaseTest.println("");
        UnionCaseTest.print(this.hdr);
        for (i = 0; i < 24; ++i) {
            this.checkCase(i, TgtHllType.HLL_8, true);
        }
        UnionCaseTest.println("");
    }

    private void checkCase(int caseNum, TgtHllType srcType, boolean srcSeg) {
        this.source = this.getSource(caseNum, srcType, srcSeg);
        boolean gdtSeg = (caseNum & 1) > 0;
        HllUnion union = this.getUnion(caseNum, gdtSeg);
        union.update(this.source);
        int totalU = UnionCaseTest.getSrcCount(caseNum, 12) + UnionCaseTest.getUnionCount(caseNum);
        this.output(caseNum, this.source, union, totalU);
    }

    private void output(int caseNum, HllSketch source, HllUnion union, int totalU) {
        double estU = union.getEstimate();
        double err = Math.abs(estU / (double)totalU - 1.0);
        int gdtLgK = union.getLgConfigK();
        boolean uooof = union.isOutOfOrder();
        double rseFactor = uooof ? HllUtil.HLL_NON_HIP_RSE_FACTOR : HllUtil.HLL_HIP_RSE_FACTOR;
        double rse = rseFactor * 3.0 / Math.sqrt(1 << gdtLgK);
        String caseNumStr = Integer.toString(caseNum);
        String srcLgKStr = Integer.toString(source.getLgConfigK());
        String gdtLgKStr = Integer.toString(union.getLgConfigK());
        String srcType = source.getTgtHllType().toString();
        String gdtType = union.getTgtHllType().toString();
        String srcSeg = Boolean.toString(source.hasMemorySegment());
        String gdtSeg = Boolean.toString(union.hasMemorySegment());
        String srcMode = source.getCurMode().toString();
        String gdtMode = union.getCurMode().toString();
        String srcOoof = Boolean.toString(source.isOutOfOrder());
        String gdtOoof = Boolean.toString(union.isOutOfOrder());
        UnionCaseTest.printf(this.hfmt, caseNumStr, srcLgKStr, gdtLgKStr, srcType, gdtType, srcSeg, gdtSeg, srcMode, gdtMode, srcOoof, gdtOoof);
        Assert.assertTrue((err < rse ? 1 : 0) != 0, (String)("Err: " + err + ", RSE: " + rse));
    }

    private HllSketch getSource(int caseNum, TgtHllType tgtHllType, boolean useMemorySegment) {
        int srcLgK = UnionCaseTest.getSrcLgK(caseNum, 12);
        int srcU = UnionCaseTest.getSrcCount(caseNum, 12);
        if (useMemorySegment) {
            return this.buildMemorySegmentSketch(srcLgK, tgtHllType, srcU);
        }
        return this.buildHeapSketch(srcLgK, tgtHllType, srcU);
    }

    private HllUnion getUnion(int caseNum, boolean useMemorySegment) {
        int unionU = UnionCaseTest.getUnionCount(caseNum);
        return useMemorySegment ? this.buildMemorSegmentUnion(12, unionU) : this.buildHeapUnion(12, unionU);
    }

    private static int getUnionCount(int caseNum) {
        int gdtMode = caseNum >> 1 & 3;
        return gdtMode == 0 ? 4 : (gdtMode == 1 ? 380 : (gdtMode == 2 ? 400 : 0));
    }

    private static int getSrcCount(int caseNum, int maxLgK) {
        int srcLgK = UnionCaseTest.getSrcLgK(caseNum, maxLgK);
        return (1 << srcLgK) * 3 / 4 + 100;
    }

    private static int getSrcLgK(int caseNum, int maxLgK) {
        int srcLgK = maxLgK;
        int bits34 = caseNum >> 3 & 3;
        if (bits34 == 1) {
            srcLgK = maxLgK - 1;
        }
        if (bits34 == 2) {
            srcLgK = maxLgK + 1;
        }
        return srcLgK;
    }

    @Test
    public void checkMisc() {
        HllUnion u = this.buildHeapUnion(12, 0);
        int bytes = u.getCompactSerializationBytes();
        Assert.assertEquals((int)bytes, (int)8);
        bytes = HllUnion.getMaxSerializationBytes((int)7);
        Assert.assertEquals((int)bytes, (int)168);
        double v = u.getEstimate();
        Assert.assertEquals((double)v, (double)0.0, (double)0.0);
        v = u.getLowerBound(1);
        Assert.assertEquals((double)v, (double)0.0, (double)0.0);
        v = u.getUpperBound(1);
        Assert.assertEquals((double)v, (double)0.0, (double)0.0);
        Assert.assertTrue((boolean)u.isEmpty());
        u.reset();
        Assert.assertTrue((boolean)u.isEmpty());
        UnionCaseTest.println(u.toString(true, false, false, false));
        byte[] bArr = u.toCompactByteArray();
        Assert.assertEquals((int)bArr.length, (int)8);
    }

    @Test
    public void checkSrcListList() {
        int n1 = 2;
        int n2 = 3;
        int n3 = 2;
        int sum = 7;
        HllUnion u = this.buildHeapUnion(12, 2);
        HllSketch h2 = this.buildHeapSketch(11, TgtHllType.HLL_6, 3);
        HllSketch h3 = this.buildHeapSketch(10, TgtHllType.HLL_8, 2);
        u.update(h2);
        UnionCaseTest.println(u.toString());
        Assert.assertEquals((Object)u.getCurMode(), (Object)CurMode.LIST);
        u.update(h3);
        UnionCaseTest.println(u.toString());
        Assert.assertEquals((Object)u.getCurMode(), (Object)CurMode.LIST);
        Assert.assertEquals((int)u.getLgConfigK(), (int)12);
        Assert.assertFalse((boolean)u.isOutOfOrder());
        double err = 7.0 * UnionCaseTest.errorFactor(u.getLgConfigK(), u.isOutOfOrder(), 3.0);
        UnionCaseTest.println("ErrToll: " + err);
        Assert.assertEquals((double)u.getEstimate(), (double)7.0, (double)err);
    }

    @Test
    public void checkSrcListSet() {
        int n1 = 5;
        int n2 = 2;
        int n3 = 16;
        int sum = 23;
        HllUnion u = this.buildHeapUnion(12, 5);
        HllSketch h2 = this.buildHeapSketch(11, TgtHllType.HLL_6, 2);
        HllSketch h3 = this.buildHeapSketch(10, TgtHllType.HLL_8, 16);
        u.update(h2);
        UnionCaseTest.println(u.toString());
        Assert.assertEquals((Object)u.getCurMode(), (Object)CurMode.LIST);
        u.update(h3);
        UnionCaseTest.println(u.toString());
        Assert.assertEquals((Object)u.getCurMode(), (Object)CurMode.SET);
        Assert.assertEquals((int)u.getLgConfigK(), (int)12);
        Assert.assertFalse((boolean)u.isOutOfOrder());
        double err = 23.0 * UnionCaseTest.errorFactor(u.getLgConfigK(), u.isOutOfOrder(), 3.0);
        UnionCaseTest.println("ErrToll: " + err);
        Assert.assertEquals((double)u.getEstimate(), (double)23.0, (double)err);
    }

    @Test
    public void checkSrcSetList() {
        int n1 = 6;
        int n2 = 10;
        int n3 = 6;
        int sum = 22;
        HllUnion u = this.buildHeapUnion(12, 6);
        HllSketch h2 = this.buildHeapSketch(11, TgtHllType.HLL_6, 10);
        HllSketch h3 = this.buildHeapSketch(10, TgtHllType.HLL_8, 6);
        u.update(h2);
        UnionCaseTest.println(u.toString());
        Assert.assertEquals((Object)u.getCurMode(), (Object)CurMode.SET);
        u.update(h3);
        UnionCaseTest.println(u.toString());
        Assert.assertEquals((Object)u.getCurMode(), (Object)CurMode.SET);
        Assert.assertEquals((int)u.getLgConfigK(), (int)12);
        Assert.assertFalse((boolean)u.isOutOfOrder());
        double err = 22.0 * UnionCaseTest.errorFactor(u.getLgConfigK(), u.isOutOfOrder(), 3.0);
        UnionCaseTest.println("ErrToll: " + err);
        Assert.assertEquals((double)u.getEstimate(), (double)22.0, (double)err);
    }

    @Test
    public void checkSrcSetSet() {
        int n1 = 6;
        int n2 = 10;
        int n3 = 16;
        int sum = 32;
        HllUnion u = this.buildHeapUnion(12, 6);
        HllSketch h2 = this.buildHeapSketch(11, TgtHllType.HLL_6, 10);
        HllSketch h3 = this.buildHeapSketch(10, TgtHllType.HLL_8, 16);
        u.update(h2);
        UnionCaseTest.println(u.toString());
        Assert.assertEquals((Object)u.getCurMode(), (Object)CurMode.SET);
        u.update(h3);
        UnionCaseTest.println(u.toString());
        Assert.assertEquals((Object)u.getCurMode(), (Object)CurMode.SET);
        Assert.assertEquals((int)u.getLgConfigK(), (int)12);
        Assert.assertFalse((boolean)u.isOutOfOrder());
        double err = 32.0 * UnionCaseTest.errorFactor(u.getLgConfigK(), u.isOutOfOrder(), 3.0);
        UnionCaseTest.println("ErrToll: " + err);
        Assert.assertEquals((double)u.getEstimate(), (double)32.0, (double)err);
    }

    @Test
    public void checkSrcEmptyList() {
        boolean n1 = false;
        boolean n2 = false;
        int n3 = 7;
        int sum = 7;
        HllUnion u = this.buildHeapUnion(12, 0);
        HllSketch h2 = this.buildHeapSketch(11, TgtHllType.HLL_6, 0);
        HllSketch h3 = this.buildHeapSketch(10, TgtHllType.HLL_8, 7);
        u.update(h2);
        UnionCaseTest.println(u.toString());
        Assert.assertEquals((Object)u.getCurMode(), (Object)CurMode.LIST);
        u.update(h3);
        UnionCaseTest.println(u.toString());
        Assert.assertEquals((Object)u.getCurMode(), (Object)CurMode.LIST);
        Assert.assertEquals((int)u.getLgConfigK(), (int)12);
        Assert.assertFalse((boolean)u.isOutOfOrder());
        double err = 7.0 * UnionCaseTest.errorFactor(u.getLgConfigK(), u.isOutOfOrder(), 3.0);
        UnionCaseTest.println("ErrToll: " + err);
        Assert.assertEquals((double)u.getEstimate(), (double)7.0, (double)err);
    }

    @Test
    public void checkSrcEmptySet() {
        boolean n1 = false;
        boolean n2 = false;
        int n3 = 16;
        int sum = 16;
        HllUnion u = this.buildHeapUnion(12, 0);
        HllSketch h2 = this.buildHeapSketch(11, TgtHllType.HLL_6, 0);
        HllSketch h3 = this.buildHeapSketch(10, TgtHllType.HLL_8, 16);
        u.update(h2);
        UnionCaseTest.println(u.toString());
        Assert.assertEquals((Object)u.getCurMode(), (Object)CurMode.LIST);
        u.update(h3);
        UnionCaseTest.println(u.toString());
        Assert.assertEquals((Object)u.getCurMode(), (Object)CurMode.SET);
        Assert.assertEquals((int)u.getLgConfigK(), (int)12);
        Assert.assertFalse((boolean)u.isOutOfOrder());
        double err = 16.0 * UnionCaseTest.errorFactor(u.getLgConfigK(), u.isOutOfOrder(), 3.0);
        UnionCaseTest.println("ErrToll: " + err);
        Assert.assertEquals((double)u.getEstimate(), (double)16.0, (double)err);
    }

    @Test
    public void checkSpecialMergeCase4() {
        HllUnion u = this.buildHeapUnion(12, 512);
        HllSketch sk = this.buildHeapSketch(12, TgtHllType.HLL_8, 512);
        u.update(sk);
        Assert.assertTrue((boolean)u.isRebuildCurMinNumKxQFlag());
        u.getCompositeEstimate();
        Assert.assertFalse((boolean)u.isRebuildCurMinNumKxQFlag());
        u.update(sk);
        Assert.assertTrue((boolean)u.isRebuildCurMinNumKxQFlag());
        u.getLowerBound(2);
        Assert.assertFalse((boolean)u.isRebuildCurMinNumKxQFlag());
        u.update(sk);
        Assert.assertTrue((boolean)u.isRebuildCurMinNumKxQFlag());
        u.getUpperBound(2);
        Assert.assertFalse((boolean)u.isRebuildCurMinNumKxQFlag());
        u.update(sk);
        Assert.assertTrue((boolean)u.isRebuildCurMinNumKxQFlag());
        u.getResult();
        Assert.assertFalse((boolean)u.isRebuildCurMinNumKxQFlag());
        u.update(sk);
        Assert.assertTrue((boolean)u.isRebuildCurMinNumKxQFlag());
        byte[] ba = u.toCompactByteArray();
        Assert.assertFalse((boolean)u.isRebuildCurMinNumKxQFlag());
        u.update(sk);
        Assert.assertTrue((boolean)u.isRebuildCurMinNumKxQFlag());
        ba = u.toUpdatableByteArray();
        Assert.assertFalse((boolean)u.isRebuildCurMinNumKxQFlag());
        u.putRebuildCurMinNumKxQFlag(true);
        Assert.assertTrue((boolean)u.isRebuildCurMinNumKxQFlag());
        u.putRebuildCurMinNumKxQFlag(false);
        Assert.assertFalse((boolean)u.isRebuildCurMinNumKxQFlag());
    }

    @Test
    public void checkRebuildCurMinNumKxQFlag1() {
        HllSketch sk = this.buildHeapSketch(4, TgtHllType.HLL_8, 16);
        HllArray hllArr = (HllArray)sk.hllSketchImpl;
        hllArr.putRebuildCurMinNumKxQFlag(true);
        HllUnion union = this.buildHeapUnion(4, 0);
        union.update(sk);
    }

    @Test
    public void checkRebuildCurMinNumKxQFlag2() {
        HllSketch sk = this.buildMemorySegmentSketch(4, TgtHllType.HLL_8, 16);
        DirectHllArray hllArr = (DirectHllArray)sk.hllSketchImpl;
        hllArr.putRebuildCurMinNumKxQFlag(true);
        MemorySegment wseg = sk.getMemorySegment();
        HllUnion.writableWrap((MemorySegment)wseg);
    }

    @Test(expectedExceptions={SketchesStateException.class})
    public void checkHllMergeToException() {
        HllSketch src = this.buildHeapSketch(4, TgtHllType.HLL_8, 16);
        HllSketch tgt = this.buildHeapSketch(4, TgtHllType.HLL_8, 16);
        AbstractHllArray absHllArr = (AbstractHllArray)src.hllSketchImpl;
        absHllArr.mergeTo(tgt);
    }

    private static double errorFactor(int lgK, boolean oooFlag, double numStdDev) {
        double f = oooFlag ? 1.04 * numStdDev / Math.sqrt(1 << lgK) : 0.9 * numStdDev / Math.sqrt(1 << lgK);
        return f;
    }

    private HllUnion buildHeapUnion(int lgMaxK, int n) {
        HllUnion u = new HllUnion(lgMaxK);
        for (int i = 0; i < n; ++i) {
            u.update((long)i + this.v);
        }
        this.v += (long)n;
        return u;
    }

    private HllUnion buildMemorSegmentUnion(int lgMaxK, int n) {
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)lgMaxK, (TgtHllType)TgtHllType.HLL_8);
        MemorySegment wseg = MemorySegment.ofArray(new byte[bytes]);
        HllUnion u = new HllUnion(lgMaxK, wseg);
        for (int i = 0; i < n; ++i) {
            u.update((long)i + this.v);
        }
        this.v += (long)n;
        return u;
    }

    private HllSketch buildHeapSketch(int lgK, TgtHllType tgtHllType, int n) {
        HllSketch sk = new HllSketch(lgK, tgtHllType);
        for (int i = 0; i < n; ++i) {
            sk.update((long)i + this.v);
        }
        this.v += (long)n;
        return sk;
    }

    private HllSketch buildMemorySegmentSketch(int lgK, TgtHllType tgtHllType, int n) {
        int bytes = HllSketch.getMaxUpdatableSerializationBytes((int)lgK, (TgtHllType)tgtHllType);
        MemorySegment wseg = MemorySegment.ofArray(new byte[bytes]);
        HllSketch sk = new HllSketch(lgK, tgtHllType, wseg);
        for (int i = 0; i < n; ++i) {
            sk.update((long)i + this.v);
        }
        this.v += (long)n;
        return sk;
    }

    @Test
    public void printlnTest() {
        UnionCaseTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(Object o) {
        UnionCaseTest.print(o.toString() + "\n");
    }

    static void print(Object o) {
    }

    static void printf(String fmt, Object ... args) {
    }
}

