/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Arrays;
import org.apache.datasketches.quantiles.DoublesSketchAccessor;
import org.apache.datasketches.quantiles.QuantilesDoublesSketch;

final class DirectDoublesSketchAccessor
extends DoublesSketchAccessor {
    DirectDoublesSketchAccessor(QuantilesDoublesSketch ds, boolean forceSize, int level) {
        super(ds, forceSize, level);
        assert (ds.hasMemorySegment());
    }

    @Override
    DoublesSketchAccessor copyAndSetLevel(int level) {
        return new DirectDoublesSketchAccessor(this.ds_, this.forceSize_, level);
    }

    @Override
    double get(int index) {
        assert (index >= 0 && index < this.numItems_);
        assert (this.n_ == this.ds_.getN());
        int byteOffset = this.offset_ + (index << 3);
        return this.ds_.getMemorySegment().get(ValueLayout.JAVA_DOUBLE_UNALIGNED, (long)byteOffset);
    }

    @Override
    double set(int index, double quantile) {
        assert (index >= 0 && index < this.numItems_);
        assert (this.n_ == this.ds_.getN());
        assert (!this.ds_.isCompact());
        int byteOffset = this.offset_ + (index << 3);
        MemorySegment seg = this.ds_.getMemorySegment();
        double oldVal = seg.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, (long)byteOffset);
        seg.set(ValueLayout.JAVA_DOUBLE_UNALIGNED, (long)byteOffset, quantile);
        return oldVal;
    }

    @Override
    double[] getArray(int fromIdx, int numItems) {
        int byteOffset = this.offset_ + (fromIdx << 3);
        MemorySegment seg = this.ds_.getMemorySegment();
        return seg.asSlice((long)byteOffset, numItems << 3).toArray(ValueLayout.JAVA_DOUBLE_UNALIGNED);
    }

    @Override
    void putArray(double[] srcArray, int srcIndex, int dstIndex, int numItems) {
        assert (!this.ds_.isCompact());
        int byteOffset = this.offset_ + (dstIndex << 3);
        MemorySegment.copy(srcArray, srcIndex, this.ds_.getMemorySegment(), ValueLayout.JAVA_DOUBLE_UNALIGNED, (long)byteOffset, numItems);
    }

    @Override
    void sort() {
        assert (this.currLvl_ == -1);
        double[] tmpBuffer = new double[this.numItems_];
        MemorySegment seg = this.ds_.getMemorySegment();
        MemorySegment.copy(seg, ValueLayout.JAVA_DOUBLE_UNALIGNED, this.offset_, tmpBuffer, 0, this.numItems_);
        Arrays.sort(tmpBuffer, 0, this.numItems_);
        MemorySegment.copy(tmpBuffer, 0, seg, ValueLayout.JAVA_DOUBLE_UNALIGNED, (long)this.offset_, this.numItems_);
    }
}

