/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1IngressLoadBalancerIngress;
import io.kubernetes.client.openapi.models.V1IngressLoadBalancerIngressFluent;
import io.kubernetes.client.openapi.models.V1IngressPortStatus;
import io.kubernetes.client.openapi.models.V1IngressPortStatusBuilder;
import io.kubernetes.client.openapi.models.V1IngressPortStatusFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1IngressLoadBalancerIngressFluentImpl<A extends V1IngressLoadBalancerIngressFluent<A>>
extends BaseFluent<A>
implements V1IngressLoadBalancerIngressFluent<A> {
    private String hostname;
    private String ip;
    private ArrayList<V1IngressPortStatusBuilder> ports;

    public V1IngressLoadBalancerIngressFluentImpl() {
    }

    public V1IngressLoadBalancerIngressFluentImpl(V1IngressLoadBalancerIngress instance) {
        if (instance != null) {
            this.withHostname(instance.getHostname());
            this.withIp(instance.getIp());
            this.withPorts(instance.getPorts());
        }
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)this;
    }

    @Override
    public Boolean hasHostname() {
        return this.hostname != null;
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public A withIp(String ip) {
        this.ip = ip;
        return (A)this;
    }

    @Override
    public Boolean hasIp() {
        return this.ip != null;
    }

    @Override
    public A addToPorts(int index, V1IngressPortStatus item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        V1IngressPortStatusBuilder builder = new V1IngressPortStatusBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get("ports").add(index, builder);
            this.ports.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToPorts(int index, V1IngressPortStatus item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        V1IngressPortStatusBuilder builder = new V1IngressPortStatusBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get("ports").set(index, builder);
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(V1IngressPortStatus ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (V1IngressPortStatus item : items) {
            V1IngressPortStatusBuilder builder = new V1IngressPortStatusBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPorts(Collection<V1IngressPortStatus> items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (V1IngressPortStatus item : items) {
            V1IngressPortStatusBuilder builder = new V1IngressPortStatusBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(V1IngressPortStatus ... items) {
        for (V1IngressPortStatus item : items) {
            V1IngressPortStatusBuilder builder = new V1IngressPortStatusBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPorts(Collection<V1IngressPortStatus> items) {
        for (V1IngressPortStatus item : items) {
            V1IngressPortStatusBuilder builder = new V1IngressPortStatusBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPorts(Predicate<V1IngressPortStatusBuilder> predicate) {
        if (this.ports == null) {
            return (A)this;
        }
        Iterator<V1IngressPortStatusBuilder> each = this.ports.iterator();
        Object visitables = this._visitables.get("ports");
        while (each.hasNext()) {
            V1IngressPortStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1IngressPortStatus> getPorts() {
        return this.ports != null ? V1IngressLoadBalancerIngressFluentImpl.build(this.ports) : null;
    }

    @Override
    public List<V1IngressPortStatus> buildPorts() {
        return this.ports != null ? V1IngressLoadBalancerIngressFluentImpl.build(this.ports) : null;
    }

    @Override
    public V1IngressPortStatus buildPort(int index) {
        return this.ports.get(index).build();
    }

    @Override
    public V1IngressPortStatus buildFirstPort() {
        return this.ports.get(0).build();
    }

    @Override
    public V1IngressPortStatus buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    @Override
    public V1IngressPortStatus buildMatchingPort(Predicate<V1IngressPortStatusBuilder> predicate) {
        for (V1IngressPortStatusBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPort(Predicate<V1IngressPortStatusBuilder> predicate) {
        for (V1IngressPortStatusBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPorts(List<V1IngressPortStatus> ports) {
        if (this.ports != null) {
            this._visitables.get("ports").clear();
        }
        if (ports != null) {
            this.ports = new ArrayList();
            for (V1IngressPortStatus item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    @Override
    public A withPorts(V1IngressPortStatus ... ports) {
        if (this.ports != null) {
            this.ports.clear();
            this._visitables.remove("ports");
        }
        if (ports != null) {
            for (V1IngressPortStatus item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    @Override
    public V1IngressLoadBalancerIngressFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public V1IngressLoadBalancerIngressFluent.PortsNested<A> addNewPortLike(V1IngressPortStatus item) {
        return new PortsNestedImpl(-1, item);
    }

    @Override
    public V1IngressLoadBalancerIngressFluent.PortsNested<A> setNewPortLike(int index, V1IngressPortStatus item) {
        return new PortsNestedImpl(index, item);
    }

    @Override
    public V1IngressLoadBalancerIngressFluent.PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public V1IngressLoadBalancerIngressFluent.PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    @Override
    public V1IngressLoadBalancerIngressFluent.PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public V1IngressLoadBalancerIngressFluent.PortsNested<A> editMatchingPort(Predicate<V1IngressPortStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1IngressLoadBalancerIngressFluentImpl that = (V1IngressLoadBalancerIngressFluentImpl)o;
        if (!Objects.equals(this.hostname, that.hostname)) {
            return false;
        }
        if (!Objects.equals(this.ip, that.ip)) {
            return false;
        }
        return Objects.equals(this.ports, that.ports);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.hostname, this.ip, this.ports, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hostname != null) {
            sb.append("hostname:");
            sb.append(this.hostname + ",");
        }
        if (this.ip != null) {
            sb.append("ip:");
            sb.append(this.ip + ",");
        }
        if (this.ports != null) {
            sb.append("ports:");
            sb.append(this.ports);
        }
        sb.append("}");
        return sb.toString();
    }

    class PortsNestedImpl<N>
    extends V1IngressPortStatusFluentImpl<V1IngressLoadBalancerIngressFluent.PortsNested<N>>
    implements V1IngressLoadBalancerIngressFluent.PortsNested<N>,
    Nested<N> {
        V1IngressPortStatusBuilder builder;
        int index;

        PortsNestedImpl(int index, V1IngressPortStatus item) {
            this.index = index;
            this.builder = new V1IngressPortStatusBuilder(this, item);
        }

        PortsNestedImpl() {
            this.index = -1;
            this.builder = new V1IngressPortStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1IngressLoadBalancerIngressFluentImpl.this.setToPorts(this.index, this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }
}

