/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.transform.AssignPrivateNatGatewayAddressRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AssignPrivateNatGatewayAddressRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<AssignPrivateNatGatewayAddressRequest> {
    private String natGatewayId;
    private SdkInternalList<String> privateIpAddresses;
    private Integer privateIpAddressCount;

    public void setNatGatewayId(String natGatewayId) {
        this.natGatewayId = natGatewayId;
    }

    public String getNatGatewayId() {
        return this.natGatewayId;
    }

    public AssignPrivateNatGatewayAddressRequest withNatGatewayId(String natGatewayId) {
        this.setNatGatewayId(natGatewayId);
        return this;
    }

    public List<String> getPrivateIpAddresses() {
        if (this.privateIpAddresses == null) {
            this.privateIpAddresses = new SdkInternalList();
        }
        return this.privateIpAddresses;
    }

    public void setPrivateIpAddresses(Collection<String> privateIpAddresses) {
        if (privateIpAddresses == null) {
            this.privateIpAddresses = null;
            return;
        }
        this.privateIpAddresses = new SdkInternalList(privateIpAddresses);
    }

    public AssignPrivateNatGatewayAddressRequest withPrivateIpAddresses(String ... privateIpAddresses) {
        if (this.privateIpAddresses == null) {
            this.setPrivateIpAddresses((Collection<String>)new SdkInternalList(privateIpAddresses.length));
        }
        for (String ele : privateIpAddresses) {
            this.privateIpAddresses.add((Object)ele);
        }
        return this;
    }

    public AssignPrivateNatGatewayAddressRequest withPrivateIpAddresses(Collection<String> privateIpAddresses) {
        this.setPrivateIpAddresses(privateIpAddresses);
        return this;
    }

    public void setPrivateIpAddressCount(Integer privateIpAddressCount) {
        this.privateIpAddressCount = privateIpAddressCount;
    }

    public Integer getPrivateIpAddressCount() {
        return this.privateIpAddressCount;
    }

    public AssignPrivateNatGatewayAddressRequest withPrivateIpAddressCount(Integer privateIpAddressCount) {
        this.setPrivateIpAddressCount(privateIpAddressCount);
        return this;
    }

    @Override
    public Request<AssignPrivateNatGatewayAddressRequest> getDryRunRequest() {
        Request<AssignPrivateNatGatewayAddressRequest> request = new AssignPrivateNatGatewayAddressRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNatGatewayId() != null) {
            sb.append("NatGatewayId: ").append(this.getNatGatewayId()).append(",");
        }
        if (this.getPrivateIpAddresses() != null) {
            sb.append("PrivateIpAddresses: ").append(this.getPrivateIpAddresses()).append(",");
        }
        if (this.getPrivateIpAddressCount() != null) {
            sb.append("PrivateIpAddressCount: ").append(this.getPrivateIpAddressCount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignPrivateNatGatewayAddressRequest)) {
            return false;
        }
        AssignPrivateNatGatewayAddressRequest other = (AssignPrivateNatGatewayAddressRequest)obj;
        if (other.getNatGatewayId() == null ^ this.getNatGatewayId() == null) {
            return false;
        }
        if (other.getNatGatewayId() != null && !other.getNatGatewayId().equals(this.getNatGatewayId())) {
            return false;
        }
        if (other.getPrivateIpAddresses() == null ^ this.getPrivateIpAddresses() == null) {
            return false;
        }
        if (other.getPrivateIpAddresses() != null && !other.getPrivateIpAddresses().equals(this.getPrivateIpAddresses())) {
            return false;
        }
        if (other.getPrivateIpAddressCount() == null ^ this.getPrivateIpAddressCount() == null) {
            return false;
        }
        return other.getPrivateIpAddressCount() == null || other.getPrivateIpAddressCount().equals(this.getPrivateIpAddressCount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNatGatewayId() == null ? 0 : this.getNatGatewayId().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddresses() == null ? 0 : this.getPrivateIpAddresses().hashCode());
        hashCode = 31 * hashCode + (this.getPrivateIpAddressCount() == null ? 0 : this.getPrivateIpAddressCount().hashCode());
        return hashCode;
    }

    public AssignPrivateNatGatewayAddressRequest clone() {
        return (AssignPrivateNatGatewayAddressRequest)super.clone();
    }
}

