/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.restrictions.factories;

import com.github.rvesse.airline.annotations.restrictions.Directory;
import com.github.rvesse.airline.annotations.restrictions.File;
import com.github.rvesse.airline.annotations.restrictions.Path;
import com.github.rvesse.airline.annotations.restrictions.PathKind;
import com.github.rvesse.airline.restrictions.ArgumentsRestriction;
import com.github.rvesse.airline.restrictions.OptionRestriction;
import com.github.rvesse.airline.restrictions.common.PathRestriction;
import com.github.rvesse.airline.restrictions.factories.ArgumentsRestrictionFactory;
import com.github.rvesse.airline.restrictions.factories.OptionRestrictionFactory;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

public class PathRestrictionFactory
implements OptionRestrictionFactory,
ArgumentsRestrictionFactory {
    protected final PathRestriction createCommon(Annotation annotation) {
        if (annotation instanceof Path) {
            Path path = (Path)annotation;
            return new PathRestriction(path.mustExist(), path.readable(), path.writable(), path.executable(), path.kind());
        }
        if (annotation instanceof File) {
            File path = (File)annotation;
            return new PathRestriction(path.mustExist(), path.readable(), path.writable(), path.executable(), PathKind.FILE);
        }
        if (annotation instanceof Directory) {
            Directory path = (Directory)annotation;
            return new PathRestriction(path.mustExist(), path.readable(), path.writable(), path.executable(), PathKind.DIRECTORY);
        }
        return null;
    }

    @Override
    public ArgumentsRestriction createArgumentsRestriction(Annotation annotation) {
        return this.createCommon(annotation);
    }

    @Override
    public OptionRestriction createOptionRestriction(Annotation annotation) {
        return this.createCommon(annotation);
    }

    protected List<Class<? extends Annotation>> supportedAnnotations() {
        ArrayList<Class<? extends Annotation>> supported = new ArrayList<Class<? extends Annotation>>();
        supported.add(Path.class);
        supported.add(File.class);
        supported.add(Directory.class);
        return supported;
    }

    @Override
    public List<Class<? extends Annotation>> supportedArgumentsAnnotations() {
        return this.supportedAnnotations();
    }

    @Override
    public List<Class<? extends Annotation>> supportedOptionAnnotations() {
        return this.supportedAnnotations();
    }
}

