/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InternalServerError;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.indexing.overlord.DataSourceMetadata;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.SegmentCreateRequest;
import org.apache.druid.indexing.overlord.SegmentPublishResult;
import org.apache.druid.indexing.overlord.Segments;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.PendingSegmentRecord;
import org.apache.druid.metadata.ReplaceTaskLock;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SortOrder;
import org.apache.druid.metadata.SqlSegmentsMetadataQuery;
import org.apache.druid.metadata.segment.DatasourceSegmentMetadataWriter;
import org.apache.druid.metadata.segment.SegmentMetadataReadTransaction;
import org.apache.druid.metadata.segment.SegmentMetadataTransaction;
import org.apache.druid.metadata.segment.SegmentMetadataTransactionFactory;
import org.apache.druid.segment.SegmentMetadata;
import org.apache.druid.segment.SegmentSchemaMapping;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.metadata.SegmentSchemaManager;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.server.http.DataSegmentPlus;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.Partitions;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.SegmentTimeline;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.PartialShardSpec;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;
import org.joda.time.chrono.ISOChronology;
import org.skife.jdbi.v2.PreparedBatch;
import org.skife.jdbi.v2.PreparedBatchPart;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.ResultIterator;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.exceptions.CallbackFailedException;

public class IndexerSQLMetadataStorageCoordinator
implements IndexerMetadataStorageCoordinator {
    private static final Logger log = new Logger(IndexerSQLMetadataStorageCoordinator.class);
    private static final int MAX_NUM_SEGMENTS_TO_ANNOUNCE_AT_ONCE = 100;
    private static final String UPGRADED_PENDING_SEGMENT_PREFIX = "upgraded_to_version__";
    private final ObjectMapper jsonMapper;
    private final MetadataStorageTablesConfig dbTables;
    private final SQLMetadataConnector connector;
    private final SegmentSchemaManager segmentSchemaManager;
    private final CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig;
    private final boolean schemaPersistEnabled;
    private final SegmentMetadataTransactionFactory transactionFactory;

    @Inject
    public IndexerSQLMetadataStorageCoordinator(SegmentMetadataTransactionFactory transactionFactory, ObjectMapper jsonMapper, MetadataStorageTablesConfig dbTables, SQLMetadataConnector connector, SegmentSchemaManager segmentSchemaManager, CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig) {
        this.transactionFactory = transactionFactory;
        this.jsonMapper = jsonMapper;
        this.dbTables = dbTables;
        this.connector = connector;
        this.segmentSchemaManager = segmentSchemaManager;
        this.centralizedDatasourceSchemaConfig = centralizedDatasourceSchemaConfig;
        this.schemaPersistEnabled = centralizedDatasourceSchemaConfig.isEnabled() && !centralizedDatasourceSchemaConfig.isTaskSchemaPublishDisabled();
    }

    @LifecycleStart
    public void start() {
        this.connector.createDataSourceTable();
        this.connector.createPendingSegmentsTable();
        if (this.centralizedDatasourceSchemaConfig.isEnabled()) {
            this.connector.createSegmentSchemasTable();
        }
        this.connector.createSegmentTable();
        this.connector.createUpgradeSegmentsTable();
    }

    @Override
    public Set<String> retrieveAllDatasourceNames() {
        String sql = StringUtils.format((String)"SELECT DISTINCT(dataSource) FROM %s", (Object[])new Object[]{this.dbTables.getSegmentsTable()});
        return Set.copyOf((Collection)this.connector.inReadOnlyTransaction((handle, status) -> handle.createQuery(sql).mapTo(String.class).list()));
    }

    @Override
    public List<Interval> retrieveUnusedSegmentIntervals(String dataSource, int limit) {
        return this.inReadOnlyTransaction(sql -> sql.retrieveUnusedSegmentIntervals(dataSource, limit));
    }

    @Override
    public Set<DataSegment> retrieveUsedSegmentsForIntervals(String dataSource, List<Interval> intervals, Segments visibility) {
        if (intervals == null || intervals.isEmpty()) {
            throw new IAE("null/empty intervals", new Object[0]);
        }
        return this.doRetrieveUsedSegments(dataSource, intervals, visibility);
    }

    @Override
    public Set<DataSegment> retrieveAllUsedSegments(String dataSource, Segments visibility) {
        return this.doRetrieveUsedSegments(dataSource, Collections.emptyList(), visibility);
    }

    private Set<DataSegment> doRetrieveUsedSegments(String dataSource, List<Interval> intervals, Segments visibility) {
        return this.inReadOnlyDatasourceTransaction(dataSource, transaction -> {
            if (visibility == Segments.ONLY_VISIBLE) {
                SegmentTimeline timeline = this.getTimelineForIntervals(transaction, intervals);
                return timeline.findNonOvershadowedObjectsInInterval(Intervals.ETERNITY, Partitions.ONLY_COMPLETE);
            }
            return transaction.findUsedSegmentsOverlappingAnyOf(intervals);
        });
    }

    public List<Pair<DataSegment, String>> retrieveUsedSegmentsAndCreatedDates(String dataSource, List<Interval> intervals) {
        return this.inReadOnlyDatasourceTransaction(dataSource, transaction -> transaction.findUsedSegmentsPlusOverlappingAnyOf(intervals).stream().map(s -> Pair.of((Object)s.getDataSegment(), s.getCreatedDate() == null ? null : s.getCreatedDate().toString())).collect(Collectors.toList()));
    }

    @Override
    public List<DataSegment> retrieveUnusedSegmentsForInterval(String dataSource, Interval interval, @Nullable List<String> versions, @Nullable Integer limit, @Nullable DateTime maxUsedStatusLastUpdatedTime) {
        List matchingSegments = this.inReadOnlyDatasourceTransaction(dataSource, transaction -> transaction.noCacheSql().findUnusedSegments(dataSource, interval, versions, limit, maxUsedStatusLastUpdatedTime));
        log.debug("Found [%,d] unused segments for datasource[%s] in interval[%s] and versions[%s] with maxUsedStatusLastUpdatedTime[%s].", new Object[]{matchingSegments.size(), dataSource, interval, versions, maxUsedStatusLastUpdatedTime});
        return matchingSegments;
    }

    @Override
    public List<DataSegment> retrieveUnusedSegmentsWithExactInterval(String dataSource, Interval interval, DateTime maxUpdatedTime, int limit) {
        return this.inReadOnlyTransaction(sql -> sql.retrieveUnusedSegmentsWithExactInterval(dataSource, interval, maxUpdatedTime, limit));
    }

    @Override
    public Set<DataSegment> retrieveSegmentsById(String dataSource, Set<String> segmentIds) {
        return this.inReadOnlyDatasourceTransaction(dataSource, transaction -> this.retrieveSegmentsById(dataSource, transaction, segmentIds).stream().map(DataSegmentPlus::getDataSegment).collect(Collectors.toSet()));
    }

    @Override
    public int markSegmentsWithinIntervalAsUnused(String dataSource, Interval interval, @Nullable List<String> versions) {
        return this.inReadWriteDatasourceTransaction(dataSource, transaction -> transaction.markSegmentsWithinIntervalAsUnused(interval, versions, DateTimes.nowUtc()));
    }

    @Override
    public boolean markSegmentAsUnused(SegmentId segmentId) {
        return this.inReadWriteDatasourceTransaction(segmentId.getDataSource(), transaction -> transaction.markSegmentAsUnused(segmentId, DateTimes.nowUtc()));
    }

    @Override
    public int markSegmentsAsUnused(String dataSource, Set<SegmentId> segmentIds) {
        return this.inReadWriteDatasourceTransaction(dataSource, transaction -> transaction.markSegmentsAsUnused(segmentIds, DateTimes.nowUtc()));
    }

    @Override
    public int markAllSegmentsAsUnused(String dataSource) {
        return this.inReadWriteDatasourceTransaction(dataSource, transaction -> transaction.markAllSegmentsAsUnused(DateTimes.nowUtc()));
    }

    @Override
    public boolean markSegmentAsUsed(SegmentId segmentId) {
        return this.inWriteTransaction(sql -> sql.markSegmentAsUsed(segmentId, DateTimes.nowUtc()));
    }

    @Override
    public int markNonOvershadowedSegmentsAsUsed(String dataSource, Set<SegmentId> segmentIds) {
        return this.inWriteTransaction(sql -> sql.markNonOvershadowedSegmentsAsUsed(dataSource, segmentIds, DateTimes.nowUtc()));
    }

    @Override
    public int markNonOvershadowedSegmentsAsUsed(String dataSource, Interval interval, @Nullable List<String> versions) {
        return this.inWriteTransaction(sql -> sql.markNonOvershadowedSegmentsAsUsed(dataSource, interval, versions, DateTimes.nowUtc()));
    }

    @Override
    public int markAllNonOvershadowedSegmentsAsUsed(String dataSource) {
        return this.inWriteTransaction(sql -> sql.markAllNonOvershadowedSegmentsAsUsed(dataSource, DateTimes.nowUtc()));
    }

    @Override
    public List<DataSegmentPlus> iterateAllUnusedSegmentsForDatasource(String datasource, @Nullable Interval interval, @Nullable Integer limit, @Nullable String lastSegmentId, @Nullable SortOrder sortOrder) {
        return this.inReadOnlyTransaction(sql -> sql.iterateAllUnusedSegmentsForDatasource(datasource, interval, limit, lastSegmentId, sortOrder));
    }

    @Override
    public List<Interval> getUnusedSegmentIntervals(String dataSource, @Nullable DateTime minStartTime, DateTime maxEndTime, int limit, DateTime maxUsedStatusLastUpdatedTime) {
        return this.inReadOnlyTransaction(sql -> sql.retrieveUnusedSegmentIntervals(dataSource, minStartTime, maxEndTime, limit, maxUsedStatusLastUpdatedTime));
    }

    private SegmentTimeline getTimelineForIntervals(SegmentMetadataReadTransaction transaction, List<Interval> intervals) {
        return SegmentTimeline.forSegments(transaction.findUsedSegmentsOverlappingAnyOf(intervals));
    }

    @Override
    public Set<DataSegment> commitSegments(Set<DataSegment> segments, @Nullable SegmentSchemaMapping segmentSchemaMapping) {
        SegmentPublishResult result = this.commitSegmentsAndMetadata(segments, null, null, null, segmentSchemaMapping);
        if (!result.isSuccess()) {
            throw new ISE("announceHistoricalSegments failed with null metadata, should not happen.", new Object[0]);
        }
        return result.getSegments();
    }

    @Override
    public SegmentPublishResult commitSegmentsAndMetadata(Set<DataSegment> segments, @Nullable String supervisorId, @Nullable DataSourceMetadata startMetadata, @Nullable DataSourceMetadata endMetadata, @Nullable SegmentSchemaMapping segmentSchemaMapping) {
        this.verifySegmentsToCommit(segments);
        IndexerMetadataStorageCoordinator.validateDataSourceMetadata(supervisorId, startMetadata, endMetadata);
        String dataSource = segments.iterator().next().getDataSource();
        return this.inReadWriteDatasourceTransaction(dataSource, transaction -> {
            SegmentPublishResult result;
            if (startMetadata != null && !(result = this.updateDataSourceMetadataInTransaction(transaction, supervisorId, dataSource, startMetadata, endMetadata)).isSuccess()) {
                return result;
            }
            return SegmentPublishResult.ok(Set.copyOf(this.insertSegments(transaction, segments, segmentSchemaMapping)));
        });
    }

    @Override
    public SegmentPublishResult commitReplaceSegments(Set<DataSegment> replaceSegments, Set<ReplaceTaskLock> locksHeldByReplaceTask, @Nullable SegmentSchemaMapping segmentSchemaMapping) {
        String dataSource = this.verifySegmentsToCommit(replaceSegments);
        try {
            return this.inReadWriteDatasourceTransaction(dataSource, transaction -> {
                HashSet<DataSegment> segmentsToInsert = new HashSet<DataSegment>(replaceSegments);
                Set<DataSegmentPlus> upgradedSegments = this.createNewIdsOfAppendSegmentsAfterReplace(dataSource, transaction, replaceSegments, locksHeldByReplaceTask);
                HashMap<SegmentId, SegmentMetadata> upgradeSegmentMetadata = new HashMap<SegmentId, SegmentMetadata>();
                HashMap<String, String> upgradedFromSegmentIdMap = new HashMap<String, String>();
                for (DataSegmentPlus dataSegmentPlus : upgradedSegments) {
                    segmentsToInsert.add(dataSegmentPlus.getDataSegment());
                    if (dataSegmentPlus.getSchemaFingerprint() != null && dataSegmentPlus.getNumRows() != null) {
                        upgradeSegmentMetadata.put(dataSegmentPlus.getDataSegment().getId(), new SegmentMetadata(dataSegmentPlus.getNumRows(), dataSegmentPlus.getSchemaFingerprint()));
                    }
                    if (dataSegmentPlus.getUpgradedFromSegmentId() == null) continue;
                    upgradedFromSegmentIdMap.put(dataSegmentPlus.getDataSegment().getId().toString(), dataSegmentPlus.getUpgradedFromSegmentId());
                }
                return SegmentPublishResult.ok(this.insertSegments(transaction, segmentsToInsert, segmentSchemaMapping, upgradeSegmentMetadata, Collections.emptyMap(), upgradedFromSegmentIdMap), this.upgradePendingSegmentsOverlappingWith(transaction, segmentsToInsert));
            });
        }
        catch (CallbackFailedException e) {
            return SegmentPublishResult.fail(e.getMessage(), new Object[0]);
        }
    }

    @Override
    public SegmentPublishResult commitAppendSegments(Set<DataSegment> appendSegments, Map<DataSegment, ReplaceTaskLock> appendSegmentToReplaceLock, String taskAllocatorId, @Nullable SegmentSchemaMapping segmentSchemaMapping) {
        return this.commitAppendSegmentsAndMetadataInTransaction(appendSegments, appendSegmentToReplaceLock, null, null, null, taskAllocatorId, segmentSchemaMapping);
    }

    @Override
    public SegmentPublishResult commitAppendSegmentsAndMetadata(Set<DataSegment> appendSegments, Map<DataSegment, ReplaceTaskLock> appendSegmentToReplaceLock, String supervisorId, DataSourceMetadata startMetadata, DataSourceMetadata endMetadata, String taskAllocatorId, @Nullable SegmentSchemaMapping segmentSchemaMapping) {
        return this.commitAppendSegmentsAndMetadataInTransaction(appendSegments, appendSegmentToReplaceLock, supervisorId, startMetadata, endMetadata, taskAllocatorId, segmentSchemaMapping);
    }

    @Override
    public SegmentPublishResult commitMetadataOnly(String supervisorId, String dataSource, DataSourceMetadata startMetadata, DataSourceMetadata endMetadata) {
        if (supervisorId == null) {
            throw new IllegalArgumentException("supervisorId cannot be null");
        }
        if (dataSource == null) {
            throw new IllegalArgumentException("datasource name cannot be null");
        }
        if (startMetadata == null) {
            throw new IllegalArgumentException("start metadata cannot be null");
        }
        if (endMetadata == null) {
            throw new IllegalArgumentException("end metadata cannot be null");
        }
        return this.inReadWriteDatasourceTransaction(dataSource, transaction -> this.updateDataSourceMetadataInTransaction(transaction, supervisorId, dataSource, startMetadata, endMetadata));
    }

    @Override
    public Map<SegmentCreateRequest, SegmentIdWithShardSpec> allocatePendingSegments(String dataSource, Interval allocateInterval, boolean skipSegmentLineageCheck, List<SegmentCreateRequest> requests, boolean reduceMetadataIO) {
        Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        Preconditions.checkNotNull((Object)allocateInterval, (Object)"interval");
        Interval interval = allocateInterval.withChronology((Chronology)ISOChronology.getInstanceUTC());
        return this.inReadWriteDatasourceTransaction(dataSource, transaction -> this.allocatePendingSegments(transaction, dataSource, interval, skipSegmentLineageCheck, requests, reduceMetadataIO));
    }

    @Override
    @Nullable
    public SegmentIdWithShardSpec allocatePendingSegment(String dataSource, Interval interval, boolean skipSegmentLineageCheck, SegmentCreateRequest createRequest) {
        Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        Preconditions.checkNotNull((Object)interval, (Object)"interval");
        Interval allocateInterval = interval.withChronology((Chronology)ISOChronology.getInstanceUTC());
        return this.inReadWriteDatasourceTransaction(dataSource, transaction -> {
            List existingChunks = this.getTimelineForIntervals(transaction, (List<Interval>)ImmutableList.of((Object)interval)).lookup(interval);
            if (existingChunks.size() > 1) {
                log.warn("Cannot allocate new segment for dataSource[%s], interval[%s] as it already has [%,d] versions.", new Object[]{dataSource, interval, existingChunks.size()});
                return null;
            }
            if (skipSegmentLineageCheck) {
                return this.allocatePendingSegment(transaction, dataSource, allocateInterval, createRequest, existingChunks);
            }
            return this.allocatePendingSegmentWithSegmentLineageCheck(transaction, dataSource, allocateInterval, createRequest, existingChunks);
        });
    }

    private List<PendingSegmentRecord> upgradePendingSegmentsOverlappingWith(SegmentMetadataTransaction transaction, Set<DataSegment> replaceSegments) {
        if (replaceSegments.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<Interval, DataSegment> replaceIntervalToMaxId = new HashMap<Interval, DataSegment>();
        for (DataSegment segment : replaceSegments) {
            DataSegment committedMaxId = (DataSegment)replaceIntervalToMaxId.get(segment.getInterval());
            if (committedMaxId != null && committedMaxId.getShardSpec().getPartitionNum() >= segment.getShardSpec().getPartitionNum()) continue;
            replaceIntervalToMaxId.put(segment.getInterval(), segment);
        }
        String datasource = replaceSegments.iterator().next().getDataSource();
        return this.upgradePendingSegments(transaction, datasource, replaceIntervalToMaxId);
    }

    private List<PendingSegmentRecord> upgradePendingSegments(SegmentMetadataTransaction transaction, String datasource, Map<Interval, DataSegment> replaceIntervalToMaxId) {
        ArrayList<PendingSegmentRecord> upgradedPendingSegments = new ArrayList<PendingSegmentRecord>();
        for (Map.Entry<Interval, DataSegment> entry : replaceIntervalToMaxId.entrySet()) {
            Interval replaceInterval = entry.getKey();
            DataSegment maxSegmentId = entry.getValue();
            String replaceVersion = maxSegmentId.getVersion();
            int numCorePartitions = maxSegmentId.getShardSpec().getNumCorePartitions();
            int currentPartitionNumber = maxSegmentId.getShardSpec().getPartitionNum();
            List<PendingSegmentRecord> overlappingPendingSegments = transaction.findPendingSegmentsOverlapping(replaceInterval);
            for (PendingSegmentRecord overlappingPendingSegment : overlappingPendingSegments) {
                SegmentIdWithShardSpec pendingSegmentId = overlappingPendingSegment.getId();
                if (!this.shouldUpgradePendingSegment(overlappingPendingSegment, replaceInterval, replaceVersion)) continue;
                SegmentIdWithShardSpec newId = new SegmentIdWithShardSpec(datasource, replaceInterval, replaceVersion, (ShardSpec)new NumberedShardSpec(++currentPartitionNumber, numCorePartitions));
                upgradedPendingSegments.add(PendingSegmentRecord.create(newId, UPGRADED_PENDING_SEGMENT_PREFIX + replaceVersion, pendingSegmentId.toString(), pendingSegmentId.toString(), overlappingPendingSegment.getTaskAllocatorId()));
            }
        }
        int numInsertedPendingSegments = transaction.insertPendingSegments(upgradedPendingSegments, false);
        log.info("Inserted total [%d] new versions for [%d] pending segments.", new Object[]{numInsertedPendingSegments, upgradedPendingSegments.size()});
        return upgradedPendingSegments;
    }

    private boolean shouldUpgradePendingSegment(PendingSegmentRecord pendingSegment, Interval replaceInterval, String replaceVersion) {
        if (pendingSegment.getTaskAllocatorId() == null) {
            return false;
        }
        if (pendingSegment.getId().getVersion().compareTo(replaceVersion) >= 0) {
            return false;
        }
        if (!replaceInterval.contains((ReadableInterval)pendingSegment.getId().getInterval())) {
            SegmentId pendingSegmentId = pendingSegment.getId().asSegmentId();
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.UNSUPPORTED).build("Replacing with a finer segment granularity than a concurrent append is unsupported. Cannot upgrade pendingSegment[%s] to version[%s] as the replace interval[%s] does not fully contain the pendingSegment interval[%s].", new Object[]{pendingSegmentId, replaceVersion, replaceInterval, pendingSegmentId.getInterval()});
        }
        return pendingSegment.getSequenceName() == null || !pendingSegment.getSequenceName().startsWith(UPGRADED_PENDING_SEGMENT_PREFIX);
    }

    @Nullable
    private SegmentIdWithShardSpec allocatePendingSegmentWithSegmentLineageCheck(SegmentMetadataTransaction transaction, String dataSource, Interval interval, SegmentCreateRequest createRequest, List<TimelineObjectHolder<String, DataSegment>> existingChunks) {
        List<SegmentIdWithShardSpec> existingPendingSegmentIds = transaction.findPendingSegmentIds(createRequest.getSequenceName(), createRequest.getPreviousSegmentId());
        String usedSegmentVersion = existingChunks.isEmpty() ? null : (String)existingChunks.get(0).getVersion();
        CheckExistingSegmentIdResult result = this.findPendingSegmentMatchingIntervalAndVersion(existingPendingSegmentIds, interval, createRequest.getSequenceName(), createRequest.getPreviousSegmentId(), usedSegmentVersion);
        if (result.found) {
            return result.segmentIdentifier;
        }
        SegmentIdWithShardSpec newIdentifier = this.createNewPendingSegment(transaction, dataSource, interval, createRequest.getPartialShardSpec(), createRequest.getVersion(), existingChunks);
        if (newIdentifier == null) {
            return null;
        }
        PendingSegmentRecord record = PendingSegmentRecord.create(newIdentifier, createRequest.getSequenceName(), createRequest.getPreviousSegmentId(), null, createRequest.getTaskAllocatorId());
        transaction.insertPendingSegment(record, false);
        return newIdentifier;
    }

    @Override
    public SegmentTimeline getSegmentTimelineForAllocation(String dataSource, Interval interval, boolean reduceMetadataIO) {
        return this.inReadOnlyDatasourceTransaction(dataSource, transaction -> {
            if (reduceMetadataIO) {
                return SegmentTimeline.forSegments(this.retrieveUsedSegmentsForAllocation(transaction, dataSource, interval));
            }
            return this.getTimelineForIntervals(transaction, Collections.singletonList(interval));
        });
    }

    private Map<SegmentCreateRequest, SegmentIdWithShardSpec> allocatePendingSegments(SegmentMetadataTransaction transaction, String dataSource, Interval interval, boolean skipSegmentLineageCheck, List<SegmentCreateRequest> requests, boolean reduceMetadataIO) {
        List existingChunks = this.getSegmentTimelineForAllocation(dataSource, interval, reduceMetadataIO).lookup(interval);
        if (existingChunks.size() > 1) {
            log.warn("Cannot allocate new segments for dataSource[%s], interval[%s] as interval already has [%,d] chunks.", new Object[]{dataSource, interval, existingChunks.size()});
            return Collections.emptyMap();
        }
        String existingVersion = existingChunks.isEmpty() ? null : (String)((TimelineObjectHolder)existingChunks.get(0)).getVersion();
        Map<SegmentCreateRequest, CheckExistingSegmentIdResult> existingSegmentIds = skipSegmentLineageCheck ? this.getExistingSegmentIdsSkipLineageCheck(transaction, interval, existingVersion, requests) : this.getExistingSegmentIdsWithLineageCheck(transaction, interval, existingVersion, requests);
        HashMap<SegmentCreateRequest, SegmentIdWithShardSpec> allocatedSegmentIds = new HashMap<SegmentCreateRequest, SegmentIdWithShardSpec>();
        ArrayList<SegmentCreateRequest> requestsForNewSegments = new ArrayList<SegmentCreateRequest>();
        for (SegmentCreateRequest request : requests) {
            CheckExistingSegmentIdResult existingSegmentId = existingSegmentIds.get(request);
            if (existingSegmentId == null || !existingSegmentId.found) {
                requestsForNewSegments.add(request);
                continue;
            }
            if (existingSegmentId.segmentIdentifier != null) {
                log.info("Found valid existing segment [%s] for request.", new Object[]{existingSegmentId.segmentIdentifier});
                allocatedSegmentIds.put(request, existingSegmentId.segmentIdentifier);
                continue;
            }
            log.info("Found clashing existing segment [%s] for request.", new Object[]{existingSegmentId});
        }
        Map<SegmentCreateRequest, PendingSegmentRecord> createdSegments = this.createNewSegments(transaction, dataSource, interval, skipSegmentLineageCheck, existingChunks, requestsForNewSegments);
        transaction.insertPendingSegments((List<PendingSegmentRecord>)ImmutableList.copyOf(createdSegments.values()), skipSegmentLineageCheck);
        for (Map.Entry<SegmentCreateRequest, PendingSegmentRecord> entry : createdSegments.entrySet()) {
            allocatedSegmentIds.put(entry.getKey(), entry.getValue().getId());
        }
        return allocatedSegmentIds;
    }

    @Nullable
    private SegmentIdWithShardSpec allocatePendingSegment(SegmentMetadataTransaction transaction, String dataSource, Interval interval, SegmentCreateRequest createRequest, List<TimelineObjectHolder<String, DataSegment>> existingChunks) {
        List<SegmentIdWithShardSpec> existingPendingSegmentIds = transaction.findPendingSegmentIdsWithExactInterval(createRequest.getSequenceName(), interval);
        CheckExistingSegmentIdResult result = this.findPendingSegmentMatchingIntervalAndVersion(existingPendingSegmentIds, interval, createRequest.getSequenceName(), null, existingChunks.isEmpty() ? null : (String)existingChunks.get(0).getVersion());
        if (result.found) {
            return result.segmentIdentifier;
        }
        SegmentIdWithShardSpec newIdentifier = this.createNewPendingSegment(transaction, dataSource, interval, createRequest.getPartialShardSpec(), createRequest.getVersion(), existingChunks);
        if (newIdentifier == null) {
            return null;
        }
        PendingSegmentRecord record = PendingSegmentRecord.create(newIdentifier, createRequest.getSequenceName(), "", null, createRequest.getTaskAllocatorId());
        transaction.insertPendingSegment(record, true);
        log.info("Created new pending segment[%s] for datasource[%s], interval[%s].", new Object[]{newIdentifier, dataSource, interval});
        return newIdentifier;
    }

    private Map<SegmentCreateRequest, CheckExistingSegmentIdResult> getExistingSegmentIdsSkipLineageCheck(SegmentMetadataTransaction transaction, Interval interval, String usedSegmentVersion, List<SegmentCreateRequest> requests) {
        List<PendingSegmentRecord> existingPendingSegments = transaction.findPendingSegmentsWithExactInterval(interval);
        HashMap<String, SegmentIdWithShardSpec> sequenceToSegmentId = new HashMap<String, SegmentIdWithShardSpec>();
        for (PendingSegmentRecord record : existingPendingSegments) {
            SegmentIdWithShardSpec segmentId = record.getId();
            if (usedSegmentVersion != null && !segmentId.getVersion().equals(usedSegmentVersion)) continue;
            sequenceToSegmentId.put(record.getSequenceName(), segmentId);
        }
        HashMap<SegmentCreateRequest, CheckExistingSegmentIdResult> requestToResult = new HashMap<SegmentCreateRequest, CheckExistingSegmentIdResult>();
        Iterator<SegmentCreateRequest> iterator = requests.iterator();
        while (iterator.hasNext()) {
            SegmentCreateRequest request;
            SegmentIdWithShardSpec segmentId = (SegmentIdWithShardSpec)sequenceToSegmentId.get((request = iterator.next()).getSequenceName());
            requestToResult.put(request, new CheckExistingSegmentIdResult(segmentId != null, segmentId));
        }
        return requestToResult;
    }

    private Map<SegmentCreateRequest, CheckExistingSegmentIdResult> getExistingSegmentIdsWithLineageCheck(SegmentMetadataTransaction transaction, Interval interval, String usedSegmentVersion, List<SegmentCreateRequest> requests) {
        HashMap<SegmentCreateRequest, CheckExistingSegmentIdResult> requestToResult = new HashMap<SegmentCreateRequest, CheckExistingSegmentIdResult>();
        for (SegmentCreateRequest request : requests) {
            List<SegmentIdWithShardSpec> existingPendingSegmentIds = transaction.findPendingSegmentIds(request.getSequenceName(), request.getPreviousSegmentId());
            CheckExistingSegmentIdResult result = this.findPendingSegmentMatchingIntervalAndVersion(existingPendingSegmentIds, interval, request.getSequenceName(), request.getPreviousSegmentId(), usedSegmentVersion);
            requestToResult.put(request, result);
        }
        return requestToResult;
    }

    private CheckExistingSegmentIdResult findPendingSegmentMatchingIntervalAndVersion(List<SegmentIdWithShardSpec> pendingSegments, Interval interval, String sequenceName, @Nullable String previousSegmentId, @Nullable String usedSegmentVersion) {
        if (pendingSegments.isEmpty()) {
            return new CheckExistingSegmentIdResult(false, null);
        }
        for (SegmentIdWithShardSpec pendingSegment : pendingSegments) {
            if (usedSegmentVersion != null && !pendingSegment.getVersion().equals(usedSegmentVersion)) continue;
            if (pendingSegment.getInterval().isEqual((ReadableInterval)interval)) {
                log.info("Found existing pending segment[%s] for sequence[%s], previous segment[%s], version[%s] in DB", new Object[]{pendingSegment, sequenceName, previousSegmentId, usedSegmentVersion});
                return new CheckExistingSegmentIdResult(true, pendingSegment);
            }
            log.warn("Cannot use existing pending segment [%s] for sequence[%s], previous segment[%s] in DB as it does not match requested interval[%s], version[%s].", new Object[]{pendingSegment, sequenceName, previousSegmentId, interval, usedSegmentVersion});
            return new CheckExistingSegmentIdResult(true, null);
        }
        return new CheckExistingSegmentIdResult(false, null);
    }

    private SegmentPublishResult commitAppendSegmentsAndMetadataInTransaction(Set<DataSegment> appendSegments, Map<DataSegment, ReplaceTaskLock> appendSegmentToReplaceLock, @Nullable String supervisorId, @Nullable DataSourceMetadata startMetadata, @Nullable DataSourceMetadata endMetadata, String taskAllocatorId, @Nullable SegmentSchemaMapping segmentSchemaMapping) {
        String dataSource = this.verifySegmentsToCommit(appendSegments);
        IndexerMetadataStorageCoordinator.validateDataSourceMetadata(supervisorId, startMetadata, endMetadata);
        List segmentIdsForNewVersions = this.inReadOnlyDatasourceTransaction(dataSource, transaction -> transaction.findPendingSegments(taskAllocatorId));
        HashSet<DataSegment> allSegmentsToInsert = new HashSet<DataSegment>(appendSegments);
        HashMap newVersionSegmentToParent = new HashMap();
        HashMap segmentIdMap = new HashMap();
        HashMap upgradedFromSegmentIdMap = new HashMap();
        appendSegments.forEach(segment -> segmentIdMap.put(segment.getId().toString(), segment));
        segmentIdsForNewVersions.forEach(pendingSegment -> {
            if (segmentIdMap.containsKey(pendingSegment.getUpgradedFromSegmentId())) {
                DataSegment oldSegment = (DataSegment)segmentIdMap.get(pendingSegment.getUpgradedFromSegmentId());
                SegmentId newVersionSegmentId = pendingSegment.getId().asSegmentId();
                newVersionSegmentToParent.put(newVersionSegmentId, oldSegment.getId());
                upgradedFromSegmentIdMap.put(newVersionSegmentId.toString(), oldSegment.getId().toString());
                allSegmentsToInsert.add(DataSegment.builder((DataSegment)oldSegment).interval(newVersionSegmentId.getInterval()).version(newVersionSegmentId.getVersion()).shardSpec(pendingSegment.getId().getShardSpec()).build());
            }
        });
        return this.inReadWriteDatasourceTransaction(dataSource, transaction -> {
            SegmentPublishResult metadataUpdateResult;
            if (startMetadata != null && !(metadataUpdateResult = this.updateDataSourceMetadataInTransaction(transaction, supervisorId, dataSource, startMetadata, endMetadata)).isSuccess()) {
                return metadataUpdateResult;
            }
            this.insertIntoUpgradeSegmentsTable(transaction, appendSegmentToReplaceLock);
            int numDeletedPendingSegments = transaction.deletePendingSegments(allSegmentsToInsert.stream().map(pendingSegment -> pendingSegment.getId().toString()).collect(Collectors.toSet()));
            log.info("Deleted [%d] entries from pending segments table upon commit.", new Object[]{numDeletedPendingSegments});
            return SegmentPublishResult.ok(this.insertSegments(transaction, allSegmentsToInsert, segmentSchemaMapping, Collections.emptyMap(), newVersionSegmentToParent, upgradedFromSegmentIdMap));
        });
    }

    private Map<SegmentCreateRequest, PendingSegmentRecord> createNewSegments(SegmentMetadataTransaction transaction, String dataSource, Interval interval, boolean skipSegmentLineageCheck, List<TimelineObjectHolder<String, DataSegment>> existingChunks, List<SegmentCreateRequest> requests) {
        String versionOfExistingChunk;
        if (requests.isEmpty()) {
            return Collections.emptyMap();
        }
        PartialShardSpec partialShardSpec = requests.get(0).getPartialShardSpec();
        SegmentIdWithShardSpec committedMaxId = null;
        if (existingChunks.isEmpty()) {
            versionOfExistingChunk = null;
        } else {
            TimelineObjectHolder existingHolder = (TimelineObjectHolder)Iterables.getOnlyElement(existingChunks);
            versionOfExistingChunk = (String)existingHolder.getVersion();
            for (DataSegment segment2 : FluentIterable.from((Iterable)existingHolder.getObject()).transform(PartitionChunk::getObject).filter(segment -> segment.getShardSpec().sharePartitionSpace(partialShardSpec))) {
                if (committedMaxId != null && committedMaxId.getShardSpec().getPartitionNum() >= segment2.getShardSpec().getPartitionNum()) continue;
                committedMaxId = SegmentIdWithShardSpec.fromDataSegment(segment2);
            }
        }
        Set<SegmentIdWithShardSpec> pendingSegments = transaction.findPendingSegmentsOverlapping(interval).stream().map(PendingSegmentRecord::getId).collect(Collectors.toSet());
        HashMap<SegmentCreateRequest, PendingSegmentRecord> createdSegments = new HashMap<SegmentCreateRequest, PendingSegmentRecord>();
        HashMap<UniqueAllocateRequest, PendingSegmentRecord> uniqueRequestToSegment = new HashMap<UniqueAllocateRequest, PendingSegmentRecord>();
        for (SegmentCreateRequest request : requests) {
            PendingSegmentRecord createdSegment;
            UniqueAllocateRequest uniqueRequest = new UniqueAllocateRequest(interval, request, skipSegmentLineageCheck);
            if (uniqueRequestToSegment.containsKey(uniqueRequest)) {
                createdSegment = (PendingSegmentRecord)uniqueRequestToSegment.get(uniqueRequest);
            } else {
                createdSegment = this.createNewPendingSegment(transaction, request, dataSource, interval, versionOfExistingChunk, committedMaxId, pendingSegments);
                if (createdSegment != null) {
                    pendingSegments.add(createdSegment.getId());
                    uniqueRequestToSegment.put(uniqueRequest, createdSegment);
                    log.debug("Created new segment[%s]", new Object[]{createdSegment.getId()});
                }
            }
            if (createdSegment == null) continue;
            createdSegments.put(request, createdSegment);
        }
        return createdSegments;
    }

    @Nullable
    private PendingSegmentRecord createNewPendingSegment(SegmentMetadataTransaction transaction, SegmentCreateRequest request, String dataSource, Interval interval, String versionOfExistingChunk, SegmentIdWithShardSpec committedMaxId, Set<SegmentIdWithShardSpec> pendingSegments) {
        PartialShardSpec partialShardSpec = request.getPartialShardSpec();
        String existingVersion = request.getVersion();
        HashSet<SegmentIdWithShardSpec> mutablePendingSegments = new HashSet<SegmentIdWithShardSpec>(pendingSegments);
        if (committedMaxId != null) {
            mutablePendingSegments.add(committedMaxId);
        }
        SegmentIdWithShardSpec overallMaxId = mutablePendingSegments.stream().filter(id -> id.getShardSpec().sharePartitionSpace(partialShardSpec)).filter(id -> versionOfExistingChunk == null || id.getVersion().equals(versionOfExistingChunk)).max(Comparator.comparing(SegmentIdWithShardSpec::getVersion).thenComparing(id -> id.getShardSpec().getPartitionNum())).orElse(null);
        String newSegmentVersion = versionOfExistingChunk != null ? versionOfExistingChunk : (overallMaxId != null ? overallMaxId.getVersion() : null);
        if (overallMaxId == null) {
            int newPartitionId = partialShardSpec.useNonRootGenerationPartitionSpace() ? 32768 : 0;
            String version = newSegmentVersion == null ? existingVersion : newSegmentVersion;
            SegmentIdWithShardSpec pendingSegmentId = new SegmentIdWithShardSpec(dataSource, interval, version, partialShardSpec.complete(this.jsonMapper, newPartitionId, 0));
            pendingSegmentId = this.getUniqueIdForPrimaryAllocation(transaction, pendingSegmentId);
            return PendingSegmentRecord.create(pendingSegmentId, request.getSequenceName(), request.getPreviousSegmentId(), null, request.getTaskAllocatorId());
        }
        if (!overallMaxId.getInterval().equals((Object)interval)) {
            log.warn("Cannot allocate new segment for dataSource[%s], interval[%s], existingVersion[%s]: conflicting segment[%s].", new Object[]{dataSource, interval, existingVersion, overallMaxId});
            return null;
        }
        if (committedMaxId != null && committedMaxId.getShardSpec().getNumCorePartitions() == -1) {
            log.warn("Cannot allocate new segment because of unknown core partition size of segment[%s], shardSpec[%s]", new Object[]{committedMaxId, committedMaxId.getShardSpec()});
            return null;
        }
        SegmentIdWithShardSpec pendingSegmentId = new SegmentIdWithShardSpec(dataSource, interval, (String)Preconditions.checkNotNull((Object)newSegmentVersion, (Object)"newSegmentVersion"), partialShardSpec.complete(this.jsonMapper, overallMaxId.getShardSpec().getPartitionNum() + 1, committedMaxId == null ? 0 : committedMaxId.getShardSpec().getNumCorePartitions()));
        return PendingSegmentRecord.create(this.getUniqueIdForSecondaryAllocation(transaction, pendingSegmentId), request.getSequenceName(), request.getPreviousSegmentId(), null, request.getTaskAllocatorId());
    }

    @Nullable
    private SegmentIdWithShardSpec createNewPendingSegment(SegmentMetadataTransaction transaction, String dataSource, Interval interval, PartialShardSpec partialShardSpec, String existingVersion, List<TimelineObjectHolder<String, DataSegment>> existingChunks) {
        String versionOfExistingChunk;
        SegmentIdWithShardSpec committedMaxId = null;
        if (existingChunks.isEmpty()) {
            versionOfExistingChunk = null;
        } else {
            TimelineObjectHolder existingHolder = (TimelineObjectHolder)Iterables.getOnlyElement(existingChunks);
            versionOfExistingChunk = (String)existingHolder.getVersion();
            for (DataSegment segment2 : FluentIterable.from((Iterable)existingHolder.getObject()).transform(PartitionChunk::getObject).filter(segment -> segment.getShardSpec().sharePartitionSpace(partialShardSpec))) {
                if (committedMaxId != null && committedMaxId.getShardSpec().getPartitionNum() >= segment2.getShardSpec().getPartitionNum()) continue;
                committedMaxId = SegmentIdWithShardSpec.fromDataSegment(segment2);
            }
        }
        Set pendings = transaction.findPendingSegmentsOverlapping(interval).stream().map(PendingSegmentRecord::getId).collect(Collectors.toSet());
        if (committedMaxId != null) {
            pendings.add(committedMaxId);
        }
        SegmentIdWithShardSpec overallMaxId = pendings.stream().filter(id -> id.getShardSpec().sharePartitionSpace(partialShardSpec)).filter(id -> versionOfExistingChunk == null || id.getVersion().equals(versionOfExistingChunk)).max(Comparator.comparing(SegmentIdWithShardSpec::getVersion).thenComparing(id -> id.getShardSpec().getPartitionNum())).orElse(null);
        String newSegmentVersion = versionOfExistingChunk != null ? versionOfExistingChunk : (overallMaxId != null ? overallMaxId.getVersion() : null);
        if (overallMaxId == null) {
            int newPartitionId = partialShardSpec.useNonRootGenerationPartitionSpace() ? 32768 : 0;
            String version = newSegmentVersion == null ? existingVersion : newSegmentVersion;
            SegmentIdWithShardSpec allocatedId = new SegmentIdWithShardSpec(dataSource, interval, version, partialShardSpec.complete(this.jsonMapper, newPartitionId, 0));
            return this.getUniqueIdForPrimaryAllocation(transaction, allocatedId);
        }
        if (!overallMaxId.getInterval().equals((Object)interval)) {
            log.warn("Cannot allocate new segment for dataSource[%s], interval[%s], existingVersion[%s]: conflicting segment[%s].", new Object[]{dataSource, interval, existingVersion, overallMaxId});
            return null;
        }
        if (committedMaxId != null && committedMaxId.getShardSpec().getNumCorePartitions() == -1) {
            log.warn("Cannot allocate new segment because of unknown core partition size of segment[%s], shardSpec[%s]", new Object[]{committedMaxId, committedMaxId.getShardSpec()});
            return null;
        }
        SegmentIdWithShardSpec allocatedId = new SegmentIdWithShardSpec(dataSource, interval, (String)Preconditions.checkNotNull((Object)newSegmentVersion, (Object)"newSegmentVersion"), partialShardSpec.complete(this.jsonMapper, overallMaxId.getShardSpec().getPartitionNum() + 1, committedMaxId == null ? 0 : committedMaxId.getShardSpec().getNumCorePartitions()));
        return this.getUniqueIdForSecondaryAllocation(transaction, allocatedId);
    }

    private SegmentIdWithShardSpec getUniqueIdForPrimaryAllocation(SegmentMetadataTransaction transaction, SegmentIdWithShardSpec allocatedId) {
        String allocatedVersion;
        Set<String> unusedSegmentVersions = transaction.noCacheSql().retrieveUnusedSegmentVersionsWithInterval(allocatedId.getDataSource(), allocatedId.getInterval());
        if (!unusedSegmentVersions.contains(allocatedVersion = allocatedId.getVersion())) {
            return allocatedId;
        }
        if (!PendingSegmentRecord.DEFAULT_VERSION_FOR_CONCURRENT_APPEND.equals(allocatedVersion)) {
            throw DruidException.defensive((String)"Cannot allocate segment[%s] as there are already some unused segments for version[%s] in this interval.", (Object[])new Object[]{allocatedId, allocatedVersion});
        }
        boolean foundFreshVersion = false;
        StringBuilder candidateVersion = new StringBuilder(allocatedId.getVersion());
        for (int i = 0; i < 10; ++i) {
            if (!unusedSegmentVersions.contains(candidateVersion.toString())) {
                foundFreshVersion = true;
                break;
            }
            candidateVersion.append("S");
        }
        if (foundFreshVersion) {
            SegmentIdWithShardSpec uniqueId = new SegmentIdWithShardSpec(allocatedId.getDataSource(), allocatedId.getInterval(), candidateVersion.toString(), allocatedId.getShardSpec());
            log.info("Created new unique pending segment ID[%s] with version[%s] for originally allocated ID[%s].", new Object[]{uniqueId, candidateVersion.toString(), allocatedId});
            return uniqueId;
        }
        throw InternalServerError.exception((String)"Could not allocate segment[%s] as there are too many clashing unused versions(upto [%s]) in the interval. Kill the old unused versions to proceed.", (Object[])new Object[]{allocatedId, candidateVersion.toString()});
    }

    private SegmentIdWithShardSpec getUniqueIdForSecondaryAllocation(SegmentMetadataTransaction transaction, SegmentIdWithShardSpec allocatedId) {
        if (transaction.findExistingSegmentIds(Set.of(allocatedId.asSegmentId())).isEmpty()) {
            return allocatedId;
        }
        SegmentId unusedMaxId = transaction.noCacheSql().retrieveHighestUnusedSegmentId(allocatedId.getDataSource(), allocatedId.getInterval(), allocatedId.getVersion());
        log.info("Allocated SegmentId[%s] is already in use. Using next ID after max[%s].", new Object[]{allocatedId.asSegmentId(), unusedMaxId});
        if (unusedMaxId == null) {
            return allocatedId;
        }
        int maxPartitionNum = Math.max(allocatedId.getShardSpec().getPartitionNum(), unusedMaxId.getPartitionNum() + 1);
        SegmentIdWithShardSpec uniqueId = new SegmentIdWithShardSpec(allocatedId.getDataSource(), allocatedId.getInterval(), allocatedId.getVersion(), (ShardSpec)new NumberedShardSpec(maxPartitionNum, allocatedId.getShardSpec().getNumCorePartitions()));
        log.info("Created new unique pending segment ID[%s] with partition number[%s] for originally allocated ID[%s].", new Object[]{uniqueId, maxPartitionNum, allocatedId});
        return uniqueId;
    }

    @Override
    public int deletePendingSegmentsCreatedInInterval(String dataSource, Interval deleteInterval) {
        return this.inReadWriteDatasourceTransaction(dataSource, transaction -> transaction.deletePendingSegmentsCreatedIn(deleteInterval));
    }

    @Override
    public int deletePendingSegments(String dataSource) {
        return this.inReadWriteDatasourceTransaction(dataSource, DatasourceSegmentMetadataWriter::deleteAllPendingSegments);
    }

    private boolean shouldPersistSchema(SegmentSchemaMapping segmentSchemaMapping) {
        return this.schemaPersistEnabled && segmentSchemaMapping != null && segmentSchemaMapping.isNonEmpty();
    }

    private void persistSchema(SegmentMetadataTransaction transaction, Set<DataSegment> segments, SegmentSchemaMapping segmentSchemaMapping, DateTime updateTime) throws JsonProcessingException {
        if (segmentSchemaMapping.getSchemaVersion() != 1) {
            log.error("Schema version [%d] doesn't match the current version [%d]. Not persisting this schema [%s]. Schema for this segment will be populated by the schema backfill job in Coordinator.", new Object[]{segmentSchemaMapping.getSchemaVersion(), 1, segmentSchemaMapping});
            return;
        }
        String dataSource = ((DataSegment)segments.stream().iterator().next()).getDataSource();
        this.segmentSchemaManager.persistSegmentSchema(transaction.getHandle(), dataSource, segmentSchemaMapping.getSchemaVersion(), segmentSchemaMapping.getSchemaFingerprintToPayloadMap(), updateTime);
    }

    protected Set<DataSegment> insertSegments(SegmentMetadataTransaction transaction, Set<DataSegment> segments, @Nullable SegmentSchemaMapping segmentSchemaMapping) throws Exception {
        HashSet<DataSegment> toInsertSegments = new HashSet<DataSegment>();
        try {
            DateTime createdTime = DateTimes.nowUtc();
            boolean shouldPersistSchema = this.shouldPersistSchema(segmentSchemaMapping);
            if (shouldPersistSchema) {
                this.persistSchema(transaction, segments, segmentSchemaMapping, createdTime);
            }
            Set<SegmentId> segmentIds = segments.stream().map(DataSegment::getId).collect(Collectors.toSet());
            Set<String> existedSegments = transaction.findExistingSegmentIds(segmentIds);
            log.info("Found these segments already exist in DB: %s", new Object[]{existedSegments});
            for (DataSegment segment2 : segments) {
                if (existedSegments.contains(segment2.getId().toString())) continue;
                toInsertSegments.add(segment2);
            }
            Set<DataSegment> usedSegments = IndexerSQLMetadataStorageCoordinator.findNonOvershadowedSegments(segments);
            Set<DataSegmentPlus> segmentPlusToInsert = toInsertSegments.stream().map(segment -> {
                SegmentMetadata segmentMetadata = shouldPersistSchema ? (SegmentMetadata)segmentSchemaMapping.getSegmentIdToMetadataMap().get(segment.getId().toString()) : null;
                return new DataSegmentPlus((DataSegment)segment, createdTime, createdTime, usedSegments.contains(segment), segmentMetadata == null ? null : segmentMetadata.getSchemaFingerprint(), segmentMetadata == null ? null : Long.valueOf(segmentMetadata.getNumRows()), null);
            }).collect(Collectors.toSet());
            if (this.schemaPersistEnabled) {
                transaction.insertSegmentsWithMetadata(segmentPlusToInsert);
            } else {
                transaction.insertSegments(segmentPlusToInsert);
            }
        }
        catch (Exception e) {
            log.errorSegments((Throwable)e, segments, "Exception inserting segments");
            throw e;
        }
        return toInsertSegments;
    }

    private Set<DataSegmentPlus> createNewIdsOfAppendSegmentsAfterReplace(String dataSource, SegmentMetadataTransaction transaction, Set<DataSegment> replaceSegments, Set<ReplaceTaskLock> locksHeldByReplaceTask) {
        if (replaceSegments.isEmpty() || locksHeldByReplaceTask.isEmpty()) {
            return Collections.emptySet();
        }
        HashMap<Interval, Integer> intervalToNumCorePartitions = new HashMap<Interval, Integer>();
        HashMap<Interval, Integer> intervalToCurrentPartitionNum = new HashMap<Interval, Integer>();
        for (DataSegment segment : replaceSegments) {
            intervalToNumCorePartitions.put(segment.getInterval(), segment.getShardSpec().getNumCorePartitions());
            int partitionNum = segment.getShardSpec().getPartitionNum();
            intervalToCurrentPartitionNum.compute(segment.getInterval(), (i, value) -> value == null ? partitionNum : Math.max(value, partitionNum));
        }
        String taskId = locksHeldByReplaceTask.stream().map(ReplaceTaskLock::getSupervisorTaskId).findFirst().orElse(null);
        Map<String, String> upgradeSegmentToLockVersion = this.getAppendSegmentsCommittedDuringTask(transaction, taskId);
        List<DataSegmentPlus> segmentsToUpgrade = this.retrieveSegmentsById(dataSource, transaction, upgradeSegmentToLockVersion.keySet());
        if (segmentsToUpgrade.isEmpty()) {
            return Collections.emptySet();
        }
        Set replaceIntervals = intervalToNumCorePartitions.keySet();
        HashSet<DataSegmentPlus> upgradedSegments = new HashSet<DataSegmentPlus>();
        for (DataSegmentPlus oldSegmentMetadata : segmentsToUpgrade) {
            DataSegment oldSegment = oldSegmentMetadata.getDataSegment();
            Interval oldInterval = oldSegment.getInterval();
            Interval newInterval = null;
            for (Interval replaceInterval : replaceIntervals) {
                if (replaceInterval.contains((ReadableInterval)oldInterval)) {
                    newInterval = replaceInterval;
                    break;
                }
                if (!replaceInterval.overlaps((ReadableInterval)oldInterval)) continue;
                String conflictingSegmentId = oldSegment.getId().toString();
                String upgradeVersion = upgradeSegmentToLockVersion.get(conflictingSegmentId);
                throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.UNSUPPORTED).build("Replacing with a finer segment granularity than a concurrent append is unsupported. Cannot upgrade segment[%s] to version[%s] as the replace interval[%s] does not fully contain the pending segment interval[%s].", new Object[]{conflictingSegmentId, upgradeVersion, replaceInterval, oldInterval});
            }
            if (newInterval == null) {
                newInterval = oldInterval;
            }
            int partitionNum = intervalToCurrentPartitionNum.compute(newInterval, (i, value) -> value == null ? 0 : value + 1);
            int numCorePartitions = (Integer)intervalToNumCorePartitions.get(newInterval);
            NumberedShardSpec shardSpec = new NumberedShardSpec(partitionNum, numCorePartitions);
            String lockVersion = upgradeSegmentToLockVersion.get(oldSegment.getId().toString());
            DataSegment dataSegment = DataSegment.builder((DataSegment)oldSegment).interval(newInterval).version(lockVersion).shardSpec((ShardSpec)shardSpec).build();
            String upgradedFromSegmentId = oldSegmentMetadata.getUpgradedFromSegmentId() == null ? oldSegmentMetadata.getDataSegment().getId().toString() : oldSegmentMetadata.getUpgradedFromSegmentId();
            upgradedSegments.add(new DataSegmentPlus(dataSegment, null, null, null, oldSegmentMetadata.getSchemaFingerprint(), oldSegmentMetadata.getNumRows(), upgradedFromSegmentId));
        }
        return upgradedSegments;
    }

    private String verifySegmentsToCommit(Collection<DataSegment> segments) {
        if (segments.isEmpty()) {
            throw InvalidInput.exception((String)"No segment to commit", (Object[])new Object[0]);
        }
        String dataSource = segments.iterator().next().getDataSource();
        for (DataSegment segment : segments) {
            if (dataSource.equals(segment.getDataSource())) continue;
            throw InvalidInput.exception((String)"Segments to commit must all belong to the same datasource", (Object[])new Object[0]);
        }
        return dataSource;
    }

    private static Set<DataSegment> findNonOvershadowedSegments(Set<DataSegment> segments) {
        HashSet<DataSegment> nonOvershadowedSegments = new HashSet<DataSegment>();
        List segmentHolders = SegmentTimeline.forSegments(segments).lookupWithIncompletePartitions(Intervals.ETERNITY);
        for (TimelineObjectHolder holder : segmentHolders) {
            for (PartitionChunk chunk : holder.getObject()) {
                nonOvershadowedSegments.add((DataSegment)chunk.getObject());
            }
        }
        return nonOvershadowedSegments;
    }

    private Set<DataSegment> insertSegments(SegmentMetadataTransaction transaction, Set<DataSegment> segments, @Nullable SegmentSchemaMapping segmentSchemaMapping, Map<SegmentId, SegmentMetadata> upgradeSegmentMetadata, Map<SegmentId, SegmentId> newVersionForAppendToParent, Map<String, String> upgradedFromSegmentIdMap) throws Exception {
        DateTime createdTime = DateTimes.nowUtc();
        if (this.shouldPersistSchema(segmentSchemaMapping)) {
            this.persistSchema(transaction, segments, segmentSchemaMapping, createdTime);
        }
        Set<SegmentId> segmentIds = segments.stream().map(DataSegment::getId).collect(Collectors.toSet());
        Set<String> existingSegmentIds = transaction.findExistingSegmentIds(segmentIds);
        Set<DataSegment> segmentsToInsert = segments.stream().filter(s -> !existingSegmentIds.contains(s.getId().toString())).collect(Collectors.toSet());
        Set<DataSegmentPlus> segmentPlusToInsert = segmentsToInsert.stream().map(segment -> {
            SegmentMetadata segmentMetadata = this.getSegmentMetadataFromSchemaMappingOrUpgradeMetadata(segment.getId(), segmentSchemaMapping, newVersionForAppendToParent, upgradeSegmentMetadata);
            return new DataSegmentPlus((DataSegment)segment, createdTime, createdTime, true, segmentMetadata == null ? null : segmentMetadata.getSchemaFingerprint(), segmentMetadata == null ? null : Long.valueOf(segmentMetadata.getNumRows()), (String)upgradedFromSegmentIdMap.get(segment.getId().toString()));
        }).collect(Collectors.toSet());
        if (this.schemaPersistEnabled) {
            transaction.insertSegmentsWithMetadata(segmentPlusToInsert);
        } else {
            transaction.insertSegments(segmentPlusToInsert);
        }
        return segmentsToInsert;
    }

    @Nullable
    private SegmentMetadata getSegmentMetadataFromSchemaMappingOrUpgradeMetadata(SegmentId segmentId, SegmentSchemaMapping segmentSchemaMapping, Map<SegmentId, SegmentId> newVersionForAppendToParent, Map<SegmentId, SegmentMetadata> upgradeSegmentMetadata) {
        boolean upgradedAppendSegment;
        if (!this.shouldPersistSchema(segmentSchemaMapping)) {
            return null;
        }
        SegmentMetadata segmentMetadata = null;
        boolean presentInSchemaMetadata = segmentSchemaMapping.getSegmentIdToMetadataMap().containsKey(segmentId.toString());
        boolean bl = upgradedAppendSegment = newVersionForAppendToParent.containsKey(segmentId) && segmentSchemaMapping.getSegmentIdToMetadataMap().containsKey(newVersionForAppendToParent.get(segmentId).toString());
        if (presentInSchemaMetadata || upgradedAppendSegment) {
            String segmentIdToUse = presentInSchemaMetadata ? segmentId.toString() : newVersionForAppendToParent.get(segmentId).toString();
            segmentMetadata = (SegmentMetadata)segmentSchemaMapping.getSegmentIdToMetadataMap().get(segmentIdToUse);
        } else if (upgradeSegmentMetadata.containsKey(segmentId)) {
            segmentMetadata = upgradeSegmentMetadata.get(segmentId);
        }
        return segmentMetadata;
    }

    private void insertIntoUpgradeSegmentsTable(SegmentMetadataTransaction transaction, Map<DataSegment, ReplaceTaskLock> segmentToReplaceLock) {
        if (segmentToReplaceLock.isEmpty()) {
            return;
        }
        PreparedBatch batch = transaction.getHandle().prepareBatch(StringUtils.format((String)"INSERT INTO %1$s (task_id, segment_id, lock_version) VALUES (:task_id, :segment_id, :lock_version)", (Object[])new Object[]{this.dbTables.getUpgradeSegmentsTable()}));
        List partitions = Lists.partition(new ArrayList<Map.Entry<DataSegment, ReplaceTaskLock>>(segmentToReplaceLock.entrySet()), (int)100);
        for (List partition : partitions) {
            for (Map.Entry entry : partition) {
                DataSegment segment = (DataSegment)entry.getKey();
                ReplaceTaskLock lock = (ReplaceTaskLock)entry.getValue();
                ((PreparedBatchPart)((PreparedBatchPart)batch.add().bind("task_id", lock.getSupervisorTaskId())).bind("segment_id", segment.getId().toString())).bind("lock_version", lock.getVersion());
            }
            int[] affectedAppendRows = batch.execute();
            ArrayList<DataSegment> failedInserts = new ArrayList<DataSegment>();
            for (int i = 0; i < partition.size(); ++i) {
                if (affectedAppendRows[i] == 1) continue;
                failedInserts.add((DataSegment)((Map.Entry)partition.get(i)).getKey());
            }
            if (failedInserts.isEmpty()) continue;
            throw new ISE("Failed to insert upgrade segments in DB: %s", new Object[]{SegmentUtils.commaSeparatedIdentifiers(failedInserts)});
        }
    }

    private List<DataSegmentPlus> retrieveSegmentsById(String dataSource, SegmentMetadataReadTransaction transaction, Set<String> segmentIds) {
        if (segmentIds.isEmpty()) {
            return Collections.emptyList();
        }
        Set validSegmentIds = IdUtils.getValidSegmentIds((String)dataSource, segmentIds);
        if (this.schemaPersistEnabled) {
            return transaction.findSegmentsWithSchema(validSegmentIds);
        }
        return transaction.findSegments(validSegmentIds);
    }

    private Map<String, String> getAppendSegmentsCommittedDuringTask(SegmentMetadataTransaction transaction, String taskId) {
        String sql = StringUtils.format((String)"SELECT segment_id, lock_version FROM %1$s WHERE task_id = :task_id", (Object[])new Object[]{this.dbTables.getUpgradeSegmentsTable()});
        ResultIterator resultIterator = ((Query)transaction.getHandle().createQuery(sql).bind("task_id", taskId)).map((index, r, ctx) -> Pair.of((Object)r.getString("segment_id"), (Object)r.getString("lock_version"))).iterator();
        HashMap<String, String> segmentIdToLockVersion = new HashMap<String, String>();
        while (resultIterator.hasNext()) {
            Pair result = (Pair)resultIterator.next();
            segmentIdToLockVersion.put((String)result.lhs, (String)result.rhs);
        }
        return segmentIdToLockVersion;
    }

    @Override
    @Nullable
    public DataSourceMetadata retrieveDataSourceMetadata(String supervisorId) {
        byte[] bytes = this.connector.lookup(this.dbTables.getDataSourceTable(), "dataSource", "commit_metadata_payload", supervisorId);
        if (bytes == null) {
            return null;
        }
        return (DataSourceMetadata)JacksonUtils.readValue((ObjectMapper)this.jsonMapper, (byte[])bytes, DataSourceMetadata.class);
    }

    @Nullable
    private byte[] retrieveDataSourceMetadataAsBytes(SegmentMetadataTransaction transaction, String supervisorId) {
        return this.connector.lookupWithHandle(transaction.getHandle(), this.dbTables.getDataSourceTable(), "dataSource", "commit_metadata_payload", supervisorId);
    }

    protected SegmentPublishResult updateDataSourceMetadataInTransaction(SegmentMetadataTransaction transaction, String supervisorId, String dataSource, DataSourceMetadata startMetadata, DataSourceMetadata endMetadata) throws IOException {
        SegmentPublishResult publishResult;
        boolean startMetadataMatchesExisting;
        DataSourceMetadata oldCommitMetadataFromDb;
        String oldCommitMetadataSha1FromDb;
        Preconditions.checkNotNull((Object)supervisorId, (Object)"supervisorId");
        Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        Preconditions.checkNotNull((Object)startMetadata, (Object)"startMetadata");
        Preconditions.checkNotNull((Object)endMetadata, (Object)"endMetadata");
        byte[] oldCommitMetadataBytesFromDb = this.retrieveDataSourceMetadataAsBytes(transaction, supervisorId);
        if (oldCommitMetadataBytesFromDb == null) {
            oldCommitMetadataSha1FromDb = null;
            oldCommitMetadataFromDb = null;
        } else {
            oldCommitMetadataSha1FromDb = BaseEncoding.base16().encode(Hashing.sha1().hashBytes(oldCommitMetadataBytesFromDb).asBytes());
            oldCommitMetadataFromDb = (DataSourceMetadata)this.jsonMapper.readValue(oldCommitMetadataBytesFromDb, DataSourceMetadata.class);
        }
        boolean startMetadataGreaterThanExisting = false;
        if (oldCommitMetadataFromDb == null) {
            startMetadataMatchesExisting = startMetadata.isValidStart();
            startMetadataGreaterThanExisting = true;
        } else {
            if (startMetadata instanceof Comparable) {
                startMetadataGreaterThanExisting = ((Comparable)((Object)startMetadata.asStartMetadata())).compareTo(oldCommitMetadataFromDb.asStartMetadata()) > 0;
            }
            startMetadataMatchesExisting = startMetadata.asStartMetadata().matches(oldCommitMetadataFromDb.asStartMetadata());
        }
        if (startMetadataGreaterThanExisting && !startMetadataMatchesExisting) {
            return SegmentPublishResult.retryableFailure("The new start metadata state[%s] is ahead of the last committed end state[%s]. Try resetting the supervisor.", startMetadata, oldCommitMetadataFromDb);
        }
        if (!startMetadataMatchesExisting) {
            return SegmentPublishResult.fail("Inconsistency between stored metadata state[%s] and target state[%s]. Try resetting the supervisor.", oldCommitMetadataFromDb, startMetadata);
        }
        DataSourceMetadata newCommitMetadata = oldCommitMetadataFromDb == null ? endMetadata : oldCommitMetadataFromDb.plus(endMetadata);
        byte[] newCommitMetadataBytes = this.jsonMapper.writeValueAsBytes((Object)newCommitMetadata);
        String newCommitMetadataSha1 = BaseEncoding.base16().encode(Hashing.sha1().hashBytes(newCommitMetadataBytes).asBytes());
        if (oldCommitMetadataBytesFromDb == null) {
            String insertSql = StringUtils.format((String)"INSERT INTO %s (dataSource, created_date, commit_metadata_payload, commit_metadata_sha1) VALUES (:dataSource, :created_date, :commit_metadata_payload, :commit_metadata_sha1)", (Object[])new Object[]{this.dbTables.getDataSourceTable()});
            int numRows = ((Update)((Update)((Update)((Update)transaction.getHandle().createStatement(insertSql).bind("dataSource", supervisorId)).bind("created_date", DateTimes.nowUtc().toString())).bind("commit_metadata_payload", newCommitMetadataBytes)).bind("commit_metadata_sha1", newCommitMetadataSha1)).execute();
            publishResult = numRows == 1 ? SegmentPublishResult.ok(Set.of()) : SegmentPublishResult.retryableFailure("Insert failed", new Object[0]);
        } else {
            String updateSql = StringUtils.format((String)"UPDATE %s SET commit_metadata_payload = :new_commit_metadata_payload, commit_metadata_sha1 = :new_commit_metadata_sha1 WHERE dataSource = :dataSource AND commit_metadata_sha1 = :old_commit_metadata_sha1", (Object[])new Object[]{this.dbTables.getDataSourceTable()});
            int numRows = ((Update)((Update)((Update)((Update)transaction.getHandle().createStatement(updateSql).bind("dataSource", supervisorId)).bind("old_commit_metadata_sha1", oldCommitMetadataSha1FromDb)).bind("new_commit_metadata_payload", newCommitMetadataBytes)).bind("new_commit_metadata_sha1", newCommitMetadataSha1)).execute();
            SegmentPublishResult segmentPublishResult = publishResult = numRows == 1 ? SegmentPublishResult.ok(Set.of()) : SegmentPublishResult.retryableFailure("Compare-and-swap update failed", new Object[0]);
        }
        if (publishResult.isSuccess()) {
            log.info("Updated metadata for supervisor[%s], datasource[%s] from[%s] to[%s].", new Object[]{supervisorId, dataSource, oldCommitMetadataFromDb, newCommitMetadata});
        } else {
            log.info("Failed to update metadata for supervisor[%s], datasource[%s] due to reason[%s].", new Object[]{supervisorId, dataSource, publishResult.getErrorMsg()});
        }
        return publishResult;
    }

    @Override
    public boolean deleteDataSourceMetadata(String supervisorId) {
        return (Boolean)this.connector.retryWithHandle(handle -> {
            int rows = ((Update)handle.createStatement(StringUtils.format((String)"DELETE from %s WHERE dataSource = :dataSource", (Object[])new Object[]{this.dbTables.getDataSourceTable()})).bind("dataSource", supervisorId)).execute();
            return rows > 0;
        });
    }

    @Override
    public boolean resetDataSourceMetadata(String supervisorId, DataSourceMetadata dataSourceMetadata) throws IOException {
        byte[] newCommitMetadataBytes = this.jsonMapper.writeValueAsBytes((Object)dataSourceMetadata);
        String newCommitMetadataSha1 = BaseEncoding.base16().encode(Hashing.sha1().hashBytes(newCommitMetadataBytes).asBytes());
        String sql = "UPDATE %s SET commit_metadata_payload = :new_commit_metadata_payload, commit_metadata_sha1 = :new_commit_metadata_sha1 WHERE dataSource = :dataSource";
        return (Boolean)this.connector.retryWithHandle(handle -> {
            int numRows = ((Update)((Update)((Update)handle.createStatement(StringUtils.format((String)"UPDATE %s SET commit_metadata_payload = :new_commit_metadata_payload, commit_metadata_sha1 = :new_commit_metadata_sha1 WHERE dataSource = :dataSource", (Object[])new Object[]{this.dbTables.getDataSourceTable()})).bind("dataSource", supervisorId)).bind("new_commit_metadata_payload", newCommitMetadataBytes)).bind("new_commit_metadata_sha1", newCommitMetadataSha1)).execute();
            return numRows == 1;
        });
    }

    @Override
    public void updateSegmentMetadata(Set<DataSegment> segments) {
        String dataSource = this.verifySegmentsToCommit(segments);
        this.inReadWriteDatasourceTransaction(dataSource, transaction -> {
            for (DataSegment segment : segments) {
                transaction.updateSegmentPayload(segment);
            }
            return 0;
        });
    }

    @Override
    public int deleteSegments(Set<DataSegment> segments) {
        if (segments.isEmpty()) {
            log.info("No segments to delete.", new Object[0]);
            return 0;
        }
        String dataSource = this.verifySegmentsToCommit(segments);
        Set idsToDelete = segments.stream().map(DataSegment::getId).collect(Collectors.toSet());
        int numDeletedSegments = this.inReadWriteDatasourceTransaction(dataSource, transaction -> transaction.deleteSegments(idsToDelete));
        log.debugSegments(segments, "Delete the metadata of segments");
        return numDeletedSegments;
    }

    @Override
    public boolean insertDataSourceMetadata(String supervisorId, DataSourceMetadata metadata) {
        return 1 == (Integer)this.connector.getDBI().inTransaction((handle, status) -> ((Update)((Update)((Update)((Update)handle.createStatement(StringUtils.format((String)"INSERT INTO %s (dataSource, created_date, commit_metadata_payload, commit_metadata_sha1) VALUES (:dataSource, :created_date, :commit_metadata_payload, :commit_metadata_sha1)", (Object[])new Object[]{this.dbTables.getDataSourceTable()})).bind("dataSource", supervisorId)).bind("created_date", DateTimes.nowUtc().toString())).bind("commit_metadata_payload", this.jsonMapper.writeValueAsBytes((Object)metadata))).bind("commit_metadata_sha1", BaseEncoding.base16().encode(Hashing.sha1().hashBytes(this.jsonMapper.writeValueAsBytes((Object)metadata)).asBytes()))).execute());
    }

    @Override
    public int removeDataSourceMetadataOlderThan(long timestamp, @NotNull Set<String> excludeSupervisorIds) {
        DateTime dateTime = DateTimes.utc((long)timestamp);
        List supervisorsToDelete = (List)this.connector.getDBI().withHandle(handle -> handle.createQuery(StringUtils.format((String)"SELECT dataSource FROM %1$s WHERE created_date < '%2$s'", (Object[])new Object[]{this.dbTables.getDataSourceTable(), dateTime.toString()})).mapTo(String.class).list());
        supervisorsToDelete.removeAll(excludeSupervisorIds);
        return (Integer)this.connector.getDBI().withHandle(handle -> {
            PreparedBatch batch = handle.prepareBatch(StringUtils.format((String)"DELETE FROM %1$s WHERE dataSource = :dataSource AND created_date < '%2$s'", (Object[])new Object[]{this.dbTables.getDataSourceTable(), dateTime.toString()}));
            for (String supervisorId : supervisorsToDelete) {
                ((PreparedBatch)batch.bind("dataSource", supervisorId)).add();
            }
            int[] result = batch.execute();
            return IntStream.of(result).sum();
        });
    }

    @VisibleForTesting
    Set<DataSegment> retrieveUsedSegmentsForAllocation(SegmentMetadataReadTransaction transaction, String dataSource, Interval interval) {
        Set<SegmentId> overlappingSegmentIds = transaction.findUsedSegmentIdsOverlapping(interval);
        HashMap<String, Map> versionIntervalToSmallestSegmentId = new HashMap<String, Map>();
        for (SegmentId segmentId : overlappingSegmentIds) {
            Map map = versionIntervalToSmallestSegmentId.computeIfAbsent(segmentId.getVersion(), v -> new HashMap());
            SegmentId value = (SegmentId)map.get(segmentId.getInterval());
            if (value != null && value.getPartitionNum() <= segmentId.getPartitionNum()) continue;
            map.put(segmentId.getInterval(), segmentId);
        }
        HashSet<SegmentId> segmentIdsToRetrieve = new HashSet<SegmentId>();
        for (Map itvlMap : versionIntervalToSmallestSegmentId.values()) {
            segmentIdsToRetrieve.addAll(itvlMap.values());
        }
        List<DataSegmentPlus> list = transaction.findUsedSegments(segmentIdsToRetrieve);
        HashSet<SegmentId> retrievedIds = new HashSet<SegmentId>();
        HashMap<String, Map> versionIntervalToNumCorePartitions = new HashMap<String, Map>();
        for (DataSegmentPlus segmentPlus : list) {
            DataSegment segment = segmentPlus.getDataSegment();
            versionIntervalToNumCorePartitions.computeIfAbsent(segment.getVersion(), v -> new HashMap()).put(segment.getInterval(), segment.getShardSpec().getNumCorePartitions());
            retrievedIds.add(segment.getId());
        }
        if (!retrievedIds.equals(segmentIdsToRetrieve)) {
            throw DruidException.defensive((String)"Used segment IDs for dataSource[%s] and interval[%s] have changed in the metadata store.", (Object[])new Object[]{dataSource, interval});
        }
        HashSet<DataSegment> segmentsWithAllocationInfo = new HashSet<DataSegment>();
        for (SegmentId id : overlappingSegmentIds) {
            int corePartitions = (Integer)((Map)versionIntervalToNumCorePartitions.get(id.getVersion())).get(id.getInterval());
            segmentsWithAllocationInfo.add(DataSegment.builder((SegmentId)id).shardSpec((ShardSpec)new NumberedShardSpec(id.getPartitionNum(), corePartitions)).size(1L).build());
        }
        return segmentsWithAllocationInfo;
    }

    @Override
    public DataSegment retrieveSegmentForId(SegmentId segmentId) {
        return this.inReadOnlyDatasourceTransaction(segmentId.getDataSource(), transaction -> transaction.findSegment(segmentId));
    }

    @Override
    public DataSegment retrieveUsedSegmentForId(SegmentId segmentId) {
        return this.inReadOnlyDatasourceTransaction(segmentId.getDataSource(), transaction -> transaction.findUsedSegment(segmentId));
    }

    @Override
    public int deletePendingSegmentsForTaskAllocatorId(String datasource, String taskAllocatorId) {
        return this.inReadWriteDatasourceTransaction(datasource, transaction -> transaction.deletePendingSegments(taskAllocatorId));
    }

    @Override
    public List<PendingSegmentRecord> getPendingSegments(String datasource, Interval interval) {
        return this.inReadOnlyDatasourceTransaction(datasource, transaction -> transaction.findPendingSegmentsOverlapping(interval));
    }

    @Override
    public int deleteUpgradeSegmentsForTask(String taskId) {
        return (Integer)this.connector.getDBI().inTransaction((handle, status) -> ((Update)handle.createStatement(StringUtils.format((String)"DELETE FROM %s WHERE task_id = :task_id", (Object[])new Object[]{this.dbTables.getUpgradeSegmentsTable()})).bind("task_id", taskId)).execute());
    }

    @Override
    public Map<String, String> retrieveUpgradedFromSegmentIds(String dataSource, Set<String> segmentIds) {
        if (segmentIds.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> upgradedFromSegmentIds = new HashMap<String, String>();
        List partitions = Lists.partition((List)ImmutableList.copyOf(segmentIds), (int)100);
        for (List partition : partitions) {
            String sql = StringUtils.format((String)"SELECT id, upgraded_from_segment_id FROM %s WHERE dataSource = :dataSource %s", (Object[])new Object[]{this.dbTables.getSegmentsTable(), SqlSegmentsMetadataQuery.getParameterizedInConditionForColumn("id", partition)});
            this.connector.retryWithHandle(handle -> {
                Query query = (Query)handle.createQuery(sql).bind("dataSource", dataSource);
                SqlSegmentsMetadataQuery.bindColumnValuesToQueryWithInCondition("id", partition, query);
                return query.map((index, r, ctx) -> {
                    String id = r.getString(1);
                    String upgradedFromSegmentId = r.getString(2);
                    if (upgradedFromSegmentId != null) {
                        upgradedFromSegmentIds.put(id, upgradedFromSegmentId);
                    }
                    return null;
                }).list();
            });
        }
        return upgradedFromSegmentIds;
    }

    @Override
    public Map<String, Set<String>> retrieveUpgradedToSegmentIds(String dataSource, Set<String> segmentIds) {
        if (segmentIds.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<String>> upgradedToSegmentIds = new HashMap<String, Set<String>>();
        this.retrieveSegmentsById(dataSource, segmentIds).stream().map(DataSegment::getId).map(SegmentId::toString).forEach(id -> upgradedToSegmentIds.computeIfAbsent((String)id, k -> new HashSet()).add(id));
        List partitions = Lists.partition((List)ImmutableList.copyOf(segmentIds), (int)100);
        for (List partition : partitions) {
            String sql = StringUtils.format((String)"SELECT id, upgraded_from_segment_id FROM %s WHERE dataSource = :dataSource %s", (Object[])new Object[]{this.dbTables.getSegmentsTable(), SqlSegmentsMetadataQuery.getParameterizedInConditionForColumn("upgraded_from_segment_id", partition)});
            this.connector.retryWithHandle(handle -> {
                Query query = (Query)handle.createQuery(sql).bind("dataSource", dataSource);
                SqlSegmentsMetadataQuery.bindColumnValuesToQueryWithInCondition("upgraded_from_segment_id", partition, query);
                return query.map((index, r, ctx) -> {
                    String upgradedToId = r.getString(1);
                    String id = r.getString(2);
                    upgradedToSegmentIds.computeIfAbsent(id, k -> new HashSet()).add(upgradedToId);
                    return null;
                }).list();
            });
        }
        return upgradedToSegmentIds;
    }

    private <T> T inReadWriteDatasourceTransaction(String dataSource, SegmentMetadataTransaction.Callback<T> callback) {
        return this.transactionFactory.inReadWriteDatasourceTransaction(dataSource, callback);
    }

    private <T> T inReadOnlyDatasourceTransaction(String dataSource, SegmentMetadataReadTransaction.Callback<T> callback) {
        return this.transactionFactory.inReadOnlyDatasourceTransaction(dataSource, callback);
    }

    private <T> T inReadOnlyTransaction(Function<SqlSegmentsMetadataQuery, T> sqlQuery) {
        try {
            return this.connector.retryReadOnlyTransaction((handle, status) -> sqlQuery.apply(SqlSegmentsMetadataQuery.forHandle(handle, this.connector, this.dbTables, this.jsonMapper)), 2, 3);
        }
        catch (Throwable t) {
            Throwable rootCause = Throwables.getRootCause((Throwable)t);
            if (rootCause instanceof DruidException) {
                throw (DruidException)rootCause;
            }
            throw t;
        }
    }

    private <T> T inWriteTransaction(Function<SqlSegmentsMetadataQuery, T> sqlUpdate) {
        try {
            return this.connector.retryTransaction((handle, status) -> sqlUpdate.apply(SqlSegmentsMetadataQuery.forHandle(handle, this.connector, this.dbTables, this.jsonMapper)), 2, 3);
        }
        catch (Throwable t) {
            Throwable rootCause = Throwables.getRootCause((Throwable)t);
            if (rootCause instanceof DruidException) {
                throw (DruidException)rootCause;
            }
            throw t;
        }
    }

    private static class CheckExistingSegmentIdResult {
        private final boolean found;
        private final SegmentIdWithShardSpec segmentIdentifier;

        CheckExistingSegmentIdResult(boolean found, @Nullable SegmentIdWithShardSpec segmentIdentifier) {
            this.found = found;
            this.segmentIdentifier = segmentIdentifier;
        }
    }

    private static class UniqueAllocateRequest {
        private final Interval interval;
        private final String previousSegmentId;
        private final String sequenceName;
        private final boolean skipSegmentLineageCheck;
        private final int hashCode;

        public UniqueAllocateRequest(Interval interval, SegmentCreateRequest request, boolean skipSegmentLineageCheck) {
            this.interval = interval;
            this.sequenceName = request.getSequenceName();
            this.previousSegmentId = skipSegmentLineageCheck ? null : request.getPreviousSegmentId();
            this.skipSegmentLineageCheck = skipSegmentLineageCheck;
            this.hashCode = Objects.hash(interval, this.sequenceName, this.previousSegmentId, skipSegmentLineageCheck);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UniqueAllocateRequest that = (UniqueAllocateRequest)o;
            return this.skipSegmentLineageCheck == that.skipSegmentLineageCheck && Objects.equals(this.interval, that.interval) && Objects.equals(this.sequenceName, that.sequenceName) && Objects.equals(this.previousSegmentId, that.previousSegmentId);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

