/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.cglib.transform.impl;

import java.lang.reflect.Method;
import org.skife.jdbi.asm.Type;
import org.skife.jdbi.cglib.core.CodeEmitter;
import org.skife.jdbi.cglib.core.Constants;
import org.skife.jdbi.cglib.core.EmitUtils;
import org.skife.jdbi.cglib.core.MethodInfo;
import org.skife.jdbi.cglib.core.ReflectUtils;
import org.skife.jdbi.cglib.core.TypeUtils;
import org.skife.jdbi.cglib.transform.ClassEmitterTransformer;

public class AddStaticInitTransformer
extends ClassEmitterTransformer {
    private MethodInfo info;

    public AddStaticInitTransformer(Method classInit) {
        this.info = ReflectUtils.getMethodInfo(classInit);
        if (!TypeUtils.isStatic(this.info.getModifiers())) {
            throw new IllegalArgumentException(classInit + " is not static");
        }
        Type[] types = this.info.getSignature().getArgumentTypes();
        if (types.length != 1 || !types[0].equals(Constants.TYPE_CLASS) || !this.info.getSignature().getReturnType().equals(Type.VOID_TYPE)) {
            throw new IllegalArgumentException(classInit + " illegal signature");
        }
    }

    protected void init() {
        if (!TypeUtils.isInterface(this.getAccess())) {
            CodeEmitter e = this.getStaticHook();
            EmitUtils.load_class_this(e);
            e.invoke(this.info);
        }
    }
}

