/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.skife.jdbi.v2.BaseStatement;
import org.skife.jdbi.v2.Binding;
import org.skife.jdbi.v2.Cleanables;
import org.skife.jdbi.v2.ConcreteStatementContext;
import org.skife.jdbi.v2.Foreman;
import org.skife.jdbi.v2.TimingCollector;
import org.skife.jdbi.v2.exceptions.UnableToCreateStatementException;
import org.skife.jdbi.v2.exceptions.UnableToExecuteStatementException;
import org.skife.jdbi.v2.tweak.SQLLog;
import org.skife.jdbi.v2.tweak.StatementRewriter;

public class Batch
extends BaseStatement {
    private List<String> parts = new ArrayList<String>();
    private final StatementRewriter rewriter;
    private final Connection connection;
    private final SQLLog log;
    private final TimingCollector timingCollector;

    Batch(StatementRewriter rewriter, Connection connection, Map<String, Object> globalStatementAttributes, SQLLog log, TimingCollector timingCollector, Foreman foreman) {
        super(new ConcreteStatementContext(globalStatementAttributes), foreman);
        this.rewriter = rewriter;
        this.connection = connection;
        this.log = log;
        this.timingCollector = timingCollector;
    }

    public Batch add(String sql) {
        this.parts.add(sql);
        return this;
    }

    public Batch define(String key, Object value) {
        this.getContext().setAttribute(key, value);
        return this;
    }

    public int[] execute() {
        if (this.parts.size() == 0) {
            return new int[0];
        }
        Binding empty = new Binding();
        Statement stmt = null;
        try {
            try {
                stmt = this.connection.createStatement();
                this.addCleanable(Cleanables.forStatement(stmt));
            }
            catch (SQLException e) {
                throw new UnableToCreateStatementException(e, this.getContext());
            }
            SQLLog.BatchLogger logger = this.log.logBatch();
            try {
                for (String part : this.parts) {
                    String sql = this.rewriter.rewrite(part, empty, this.getContext()).getSql();
                    logger.add(sql);
                    stmt.addBatch(sql);
                }
            }
            catch (SQLException e) {
                throw new UnableToExecuteStatementException("Unable to configure JDBC statement", e, this.getContext());
            }
            try {
                long start = System.nanoTime();
                int[] rs = stmt.executeBatch();
                long elapsedTime = System.nanoTime() - start;
                logger.log(elapsedTime / 1000000L);
                this.timingCollector.collect(elapsedTime, this.getContext());
                int[] nArray = rs;
                return nArray;
            }
            catch (SQLException e) {
                throw new UnableToExecuteStatementException(e, this.getContext());
            }
        }
        finally {
            this.cleanup();
        }
    }
}

