/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.external;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.util.NlsString;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.calcite.external.DruidTableMacro;
import org.apache.druid.sql.calcite.external.DruidUserDefinedTableMacro;
import org.apache.druid.sql.calcite.external.Externals;

public class DruidExternTableMacro
extends DruidUserDefinedTableMacro {
    public DruidExternTableMacro(DruidTableMacro macro) {
        super(macro);
    }

    @Override
    public Set<ResourceAction> computeResources(SqlCall call, boolean inputSourceTypeSecurityEnabled) {
        if (!inputSourceTypeSecurityEnabled) {
            return Collections.singleton(Externals.EXTERNAL_RESOURCE_ACTION);
        }
        String inputSourceStr = this.getInputSourceArgument(call);
        try {
            InputSource inputSource = (InputSource)((DruidTableMacro)this.macro).getJsonMapper().readValue(inputSourceStr, InputSource.class);
            return inputSource.getTypes().stream().map(AuthorizationUtils::createExternalResourceReadAction).collect(Collectors.toSet());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private String getInputSourceArgument(SqlCall call) {
        if (!call.getOperandList().isEmpty() && call.getOperandList().get(0) instanceof SqlCharStringLiteral) {
            return ((SqlCharStringLiteral)call.getOperandList().get(0)).toValue();
        }
        for (SqlNode sqlNode : call.getOperandList()) {
            String argumentName;
            if (!(sqlNode instanceof SqlCall) || !"inputSource".equals(argumentName = ((SqlCall)sqlNode).getOperandList().size() > 1 ? ((SqlNode)((SqlCall)sqlNode).getOperandList().get(1)).toString() : null)) continue;
            return ((NlsString)((SqlCharStringLiteral)((SqlCall)call.getOperandList().get(0)).getOperandList().get(0)).getValue()).getValue();
        }
        throw new RuntimeException("inputSource parameter not found in extern function");
    }
}

