/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.FilteredAggregatorFactory;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.NativelySupportsDistinct;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.InputAccessor;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class GroupByRules {
    private GroupByRules() {
    }

    @Nullable
    public static Aggregation translateAggregateCall(PlannerContext plannerContext, RowSignature rowSignature, @Nullable VirtualColumnRegistry virtualColumnRegistry, RexBuilder rexBuilder, InputAccessor inputAccessor, List<Aggregation> existingAggregations, String name, AggregateCall call, boolean finalizeAggregations) {
        DimFilter filter;
        if (!call.getCollation().getFieldCollations().isEmpty()) {
            return null;
        }
        if (call.isDistinct() && call.getAggregation().getKind() != SqlKind.COUNT && !call.getAggregation().getClass().isAnnotationPresent(NativelySupportsDistinct.class)) {
            plannerContext.setPlanningError("Aggregation [%s] with DISTINCT is not supported when useApproximateCountDistinct is enabled. Run with disabling it.", call.getAggregation().getName());
            return null;
        }
        if (call.filterArg >= 0) {
            RexNode expression = inputAccessor.getField(call.filterArg);
            DimFilter nonOptimizedFilter = Expressions.toFilter(plannerContext, rowSignature, virtualColumnRegistry, expression);
            if (nonOptimizedFilter == null) {
                return null;
            }
            filter = Filtration.create(nonOptimizedFilter).optimizeFilterOnly(virtualColumnRegistry.getFullRowSignature()).getDimFilter();
        } else {
            filter = null;
        }
        SqlAggregator sqlAggregator = plannerContext.getPlannerToolbox().operatorTable().lookupAggregator(call.getAggregation());
        if (sqlAggregator == null) {
            return null;
        }
        ArrayList<Aggregation> existingAggregationsWithSameFilter = new ArrayList<Aggregation>();
        for (Aggregation existingAggregation : existingAggregations) {
            boolean doesMatch;
            if (filter == null) {
                doesMatch = existingAggregation.getAggregatorFactories().stream().noneMatch(factory -> factory instanceof FilteredAggregatorFactory);
                if (!doesMatch) continue;
                existingAggregationsWithSameFilter.add(existingAggregation);
                continue;
            }
            doesMatch = existingAggregation.getAggregatorFactories().stream().allMatch(factory -> factory instanceof FilteredAggregatorFactory && ((FilteredAggregatorFactory)factory).getFilter().equals((Object)filter));
            if (!doesMatch) continue;
            existingAggregationsWithSameFilter.add(Aggregation.create(existingAggregation.getAggregatorFactories().stream().map(factory -> ((FilteredAggregatorFactory)factory).getAggregator()).collect(Collectors.toList()), existingAggregation.getPostAggregator()));
        }
        Aggregation retVal = sqlAggregator.toDruidAggregation(plannerContext, virtualColumnRegistry, name, call, inputAccessor, existingAggregationsWithSameFilter, finalizeAggregations);
        if (retVal == null) {
            return null;
        }
        if (GroupByRules.isUsingExistingAggregation(retVal, existingAggregationsWithSameFilter)) {
            return retVal;
        }
        return retVal.filter(rowSignature, virtualColumnRegistry, filter);
    }

    private static boolean isUsingExistingAggregation(Aggregation aggregation, List<Aggregation> existingAggregations) {
        if (!aggregation.getAggregatorFactories().isEmpty()) {
            return false;
        }
        Set existingAggregationNames = existingAggregations.stream().flatMap(xs -> xs.getAggregatorFactories().stream()).map(AggregatorFactory::getName).collect(Collectors.toSet());
        return existingAggregationNames.containsAll(aggregation.getPostAggregator().getDependentFields());
    }
}

