/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexer;

import com.google.common.base.Preconditions;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.task.Task;
import org.joda.time.DateTime;

public class TaskInfo {
    private final DateTime createdTime;
    private final TaskStatus status;
    private final Task task;

    public TaskInfo(DateTime createdTime, TaskStatus status, Task task) {
        this.createdTime = (DateTime)Preconditions.checkNotNull((Object)createdTime, (Object)"createdTime");
        this.status = (TaskStatus)Preconditions.checkNotNull((Object)status, (Object)"status");
        this.task = (Task)Preconditions.checkNotNull((Object)task, (Object)"Task cannot be null");
    }

    public String getId() {
        return this.task.getId();
    }

    public DateTime getCreatedTime() {
        return this.createdTime;
    }

    public TaskStatus getStatus() {
        return this.status;
    }

    public String getDataSource() {
        return this.task.getDataSource();
    }

    public Task getTask() {
        return this.task;
    }

    public TaskInfo withStatus(TaskStatus status) {
        return new TaskInfo(this.createdTime, status, this.task);
    }
}

