/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.task.IndexTaskUtils;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;

public class LocalTaskActionClient
implements TaskActionClient {
    private static final EmittingLogger log = new EmittingLogger(LocalTaskActionClient.class);
    private final Task task;
    private final TaskActionToolbox toolbox;

    public LocalTaskActionClient(Task task, TaskActionToolbox toolbox) {
        this.task = task;
        this.toolbox = toolbox;
    }

    @Override
    public <RetType> RetType submit(TaskAction<RetType> taskAction) {
        log.debug("Performing action for task[%s]: %s", new Object[]{this.task.getId(), taskAction});
        long performStartTime = System.currentTimeMillis();
        RetType result = this.performAction(taskAction);
        this.emitTimerMetric("task/action/run/time", taskAction, System.currentTimeMillis() - performStartTime);
        return result;
    }

    private <R> R performAction(TaskAction<R> taskAction) {
        try {
            R result = taskAction.canPerformAsync(this.task, this.toolbox) ? taskAction.performAsync(this.task, this.toolbox).get(5L, TimeUnit.MINUTES) : taskAction.perform(this.task, this.toolbox);
            return result;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private void emitTimerMetric(String metric, TaskAction<?> action, long time) {
        ServiceMetricEvent.Builder metricBuilder = ServiceMetricEvent.builder();
        IndexTaskUtils.setTaskDimensions(metricBuilder, this.task);
        String actionType = LocalTaskActionClient.getActionType(this.toolbox.getJsonMapper(), action);
        if (actionType != null) {
            metricBuilder.setDimension("taskActionType", (Object)actionType);
        }
        this.toolbox.getEmitter().emit((ServiceEventBuilder)metricBuilder.setMetric(metric, (Number)Math.max(0L, time)));
    }

    @Nullable
    static String getActionType(ObjectMapper jsonMapper, TaskAction<?> action) {
        try {
            Map m = (Map)jsonMapper.convertValue(action, JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
            Object typeObject = m.get("type");
            if (typeObject instanceof String) {
                return (String)typeObject;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

