/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.indexing.common.actions.SegmentAllocationQueue;
import org.apache.druid.indexing.overlord.GlobalTaskLockbox;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.indexing.overlord.TaskRunnerFactory;
import org.apache.druid.indexing.overlord.TaskStorage;
import org.apache.druid.indexing.overlord.supervisor.SupervisorManager;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;

public class TaskActionToolbox {
    private final GlobalTaskLockbox taskLockbox;
    private final TaskStorage taskStorage;
    private final SegmentAllocationQueue segmentAllocationQueue;
    private final IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator;
    private final ServiceEmitter emitter;
    private final SupervisorManager supervisorManager;
    private final ObjectMapper jsonMapper;
    private Optional<TaskRunnerFactory> factory = Optional.absent();

    @Inject
    public TaskActionToolbox(GlobalTaskLockbox taskLockbox, TaskStorage taskStorage, IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator, SegmentAllocationQueue segmentAllocationQueue, ServiceEmitter emitter, SupervisorManager supervisorManager, @Json ObjectMapper jsonMapper) {
        this.taskLockbox = taskLockbox;
        this.taskStorage = taskStorage;
        this.indexerMetadataStorageCoordinator = indexerMetadataStorageCoordinator;
        this.emitter = emitter;
        this.supervisorManager = supervisorManager;
        this.jsonMapper = jsonMapper;
        this.segmentAllocationQueue = segmentAllocationQueue;
    }

    public TaskActionToolbox(GlobalTaskLockbox taskLockbox, TaskStorage taskStorage, IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator, ServiceEmitter emitter, SupervisorManager supervisorManager, @Json ObjectMapper jsonMapper) {
        this(taskLockbox, taskStorage, indexerMetadataStorageCoordinator, null, emitter, supervisorManager, jsonMapper);
    }

    public GlobalTaskLockbox getTaskLockbox() {
        return this.taskLockbox;
    }

    public TaskStorage getTaskStorage() {
        return this.taskStorage;
    }

    public IndexerMetadataStorageCoordinator getIndexerMetadataStorageCoordinator() {
        return this.indexerMetadataStorageCoordinator;
    }

    public ServiceEmitter getEmitter() {
        return this.emitter;
    }

    public SupervisorManager getSupervisorManager() {
        return this.supervisorManager;
    }

    public ObjectMapper getJsonMapper() {
        return this.jsonMapper;
    }

    @Inject(optional=true)
    public void setTaskRunnerFactory(TaskRunnerFactory factory) {
        this.factory = Optional.of((Object)factory);
    }

    public Optional<TaskRunner> getTaskRunner() {
        if (this.factory.isPresent()) {
            return Optional.of(((TaskRunnerFactory)this.factory.get()).get());
        }
        return Optional.absent();
    }

    public SegmentAllocationQueue getSegmentAllocationQueue() {
        return this.segmentAllocationQueue;
    }

    public boolean canBatchSegmentAllocation() {
        return this.segmentAllocationQueue != null && this.segmentAllocationQueue.isEnabled();
    }
}

