/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Consumer;
import org.apache.druid.indexing.common.config.TaskConfig;

public class TaskResourceCleaner {
    private final Deque<Consumer<TaskConfig>> stack = new ArrayDeque<Consumer<TaskConfig>>(4);

    public void register(Consumer<TaskConfig> cleaner) {
        this.stack.addFirst(cleaner);
    }

    public void clean(TaskConfig config) {
        Throwable throwable = null;
        while (!this.stack.isEmpty()) {
            Consumer<TaskConfig> cleaner = this.stack.removeFirst();
            try {
                cleaner.accept(config);
            }
            catch (Throwable t) {
                if (throwable == null) {
                    throwable = t;
                    continue;
                }
                this.suppress(throwable, t);
            }
        }
        if (throwable != null) {
            throw new RuntimeException(throwable);
        }
    }

    private void suppress(Throwable thrown, Throwable suppressed) {
        if (thrown != suppressed) {
            thrown.addSuppressed(suppressed);
        }
    }
}

