/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.rowsandcols;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessor;
import org.apache.druid.query.rowsandcols.column.ColumnAccessorBasedColumn;
import org.apache.druid.segment.column.ColumnType;

public class RearrangedRowsAndColumns
implements RowsAndColumns {
    private final Map<String, Column> columnCache = new LinkedHashMap<String, Column>();
    private final int[] pointers;
    private final RowsAndColumns rac;
    private final int start;
    private final int end;

    public RearrangedRowsAndColumns(int[] pointers, RowsAndColumns rac) {
        this(pointers, 0, pointers.length, rac);
    }

    public RearrangedRowsAndColumns(int[] pointers, int start, int end, RowsAndColumns rac) {
        if (end - start < 0 || end > pointers.length) {
            throw new IAE("end[%,d] - start[%,d] was invalid!? pointers.length[%,d]", end, start, pointers.length);
        }
        this.pointers = pointers;
        this.start = start;
        this.end = end;
        this.rac = rac;
    }

    @Override
    public Collection<String> getColumnNames() {
        return this.rac.getColumnNames();
    }

    @Override
    public int numRows() {
        return this.end - this.start;
    }

    @Override
    @Nullable
    public Column findColumn(String name) {
        if (this.columnCache.containsKey(name)) {
            return this.columnCache.get(name);
        }
        Column column = this.rac.findColumn(name);
        if (column == null) {
            this.columnCache.put(name, null);
            return null;
        }
        final ColumnAccessor accessor = column.toAccessor();
        return new ColumnAccessorBasedColumn(new ColumnAccessor(){

            @Override
            public ColumnType getType() {
                return accessor.getType();
            }

            @Override
            public int numRows() {
                return RearrangedRowsAndColumns.this.end - RearrangedRowsAndColumns.this.start;
            }

            @Override
            public boolean isNull(int rowNum) {
                return accessor.isNull(RearrangedRowsAndColumns.this.pointers[RearrangedRowsAndColumns.this.start + rowNum]);
            }

            @Override
            @Nullable
            public Object getObject(int rowNum) {
                return accessor.getObject(RearrangedRowsAndColumns.this.pointers[RearrangedRowsAndColumns.this.start + rowNum]);
            }

            @Override
            public double getDouble(int rowNum) {
                return accessor.getDouble(RearrangedRowsAndColumns.this.pointers[RearrangedRowsAndColumns.this.start + rowNum]);
            }

            @Override
            public float getFloat(int rowNum) {
                return accessor.getFloat(RearrangedRowsAndColumns.this.pointers[RearrangedRowsAndColumns.this.start + rowNum]);
            }

            @Override
            public long getLong(int rowNum) {
                return accessor.getLong(RearrangedRowsAndColumns.this.pointers[RearrangedRowsAndColumns.this.start + rowNum]);
            }

            @Override
            public int getInt(int rowNum) {
                return accessor.getInt(RearrangedRowsAndColumns.this.pointers[RearrangedRowsAndColumns.this.start + rowNum]);
            }

            @Override
            public int compareRows(int lhsRowNum, int rhsRowNum) {
                return accessor.compareRows(RearrangedRowsAndColumns.this.pointers[lhsRowNum], RearrangedRowsAndColumns.this.pointers[RearrangedRowsAndColumns.this.start + rhsRowNum]);
            }
        });
    }
}

