/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.RowIdSupplier;
import org.apache.druid.segment.column.ColumnCapabilities;

public class RemapColumnSelectorFactory
implements ColumnSelectorFactory {
    private final ColumnSelectorFactory delegate;
    private final Map<String, String> remap;

    public RemapColumnSelectorFactory(ColumnSelectorFactory delegate, Map<String, String> remap) {
        this.delegate = delegate;
        this.remap = remap;
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
        DimensionSpec remapDimensionSpec = dimensionSpec.withDimension(this.remap.getOrDefault(dimensionSpec.getDimension(), dimensionSpec.getDimension()));
        return this.delegate.makeDimensionSelector(remapDimensionSpec);
    }

    @Override
    public ColumnValueSelector makeColumnValueSelector(String columnName) {
        return this.delegate.makeColumnValueSelector(this.remap.getOrDefault(columnName, columnName));
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String column) {
        return this.delegate.getColumnCapabilities(this.remap.getOrDefault(column, column));
    }

    @Override
    @Nullable
    public RowIdSupplier getRowIdSupplier() {
        return this.delegate.getRowIdSupplier();
    }

    @Override
    @Nullable
    public ExpressionType getType(String name) {
        return this.delegate.getType(this.remap.getOrDefault(name, name));
    }
}

