/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.auth.delegation;

import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.model.SSECustomerKey;
import java.util.Optional;
import org.apache.hadoop.fs.s3a.S3AEncryptionMethods;
import org.apache.hadoop.fs.s3a.auth.delegation.EncryptionSecrets;

public final class EncryptionSecretOperations {
    private EncryptionSecretOperations() {
    }

    public static Optional<SSECustomerKey> createSSECustomerKey(EncryptionSecrets secrets) {
        if (secrets.hasEncryptionKey() && secrets.getEncryptionMethod() == S3AEncryptionMethods.SSE_C) {
            return Optional.of(new SSECustomerKey(secrets.getEncryptionKey()));
        }
        return Optional.empty();
    }

    public static Optional<SSEAwsKeyManagementParams> createSSEAwsKeyManagementParams(EncryptionSecrets secrets) {
        if (secrets.getEncryptionMethod() == S3AEncryptionMethods.SSE_KMS) {
            if (secrets.hasEncryptionKey()) {
                return Optional.of(new SSEAwsKeyManagementParams(secrets.getEncryptionKey()));
            }
            return Optional.of(new SSEAwsKeyManagementParams());
        }
        return Optional.empty();
    }
}

