/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.alts.internal;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.CompositeByteBuf;
import java.nio.ByteBuffer;

final class BufUnwrapper
implements AutoCloseable {
    private final ByteBuffer[] singleReadBuffer = new ByteBuffer[1];
    private final ByteBuffer[] singleWriteBuffer = new ByteBuffer[1];

    BufUnwrapper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteBuffer[] writableNioBuffers(ByteBuf buf) {
        int readerIndex = buf.readerIndex();
        int writerIndex = buf.writerIndex();
        buf.readerIndex(writerIndex);
        buf.writerIndex(buf.capacity());
        try {
            ByteBuffer[] byteBufferArray = BufUnwrapper.nioBuffers(buf, this.singleWriteBuffer);
            return byteBufferArray;
        }
        finally {
            buf.readerIndex(readerIndex);
            buf.writerIndex(writerIndex);
        }
    }

    ByteBuffer[] readableNioBuffers(ByteBuf buf) {
        return BufUnwrapper.nioBuffers(buf, this.singleReadBuffer);
    }

    @Override
    public void close() {
        this.singleReadBuffer[0] = null;
        this.singleWriteBuffer[0] = null;
    }

    private static ByteBuffer[] nioBuffers(ByteBuf buf, ByteBuffer[] singleBuffer) {
        if (!(buf instanceof CompositeByteBuf) && buf.nioBufferCount() == 1) {
            singleBuffer[0] = buf.internalNioBuffer(buf.readerIndex(), buf.readableBytes());
            return singleBuffer;
        }
        return buf.nioBuffers();
    }
}

