/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.Statement;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecCursorTableReference;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.sql.CursorInfo;
import org.apache.derby.impl.sql.GenericActivationHolder;
import org.apache.derby.impl.sql.compile.StatementNode;

public class GenericPreparedStatement
implements ExecPreparedStatement {
    public Statement statement;
    protected GeneratedClass activationClass;
    protected ResultDescription resultDesc;
    protected DataTypeDescriptor[] paramTypeDescriptors;
    private String spsName;
    private SQLWarning warnings;
    private boolean referencesSessionSchema;
    protected ExecCursorTableReference targetTable;
    protected List<String> updateColumns;
    protected int updateMode;
    protected ConstantAction executionConstants;
    protected Object[] savedObjects;
    protected List<StatementPermission> requiredPermissionsList;
    protected String UUIDString;
    protected UUID UUIDValue;
    private boolean needsSavepoint;
    private String execStmtName;
    private String execSchemaName;
    protected boolean isAtomic;
    protected String sourceTxt;
    private int inUseCount;
    private boolean compilingStatement;
    boolean invalidatedWhileCompiling;
    protected long parseTime;
    protected long bindTime;
    protected long optimizeTime;
    protected long generateTime;
    protected long compileTime;
    protected Timestamp beginCompileTimestamp;
    protected Timestamp endCompileTimestamp;
    protected boolean isValid;
    protected boolean spsAction;
    private Cacheable cacheHolder;
    private long versionCounter;
    private RowCountStatistics rowCountStats = new RowCountStatistics();

    GenericPreparedStatement() {
        UUIDFactory uUIDFactory = GenericPreparedStatement.getMonitor().getUUIDFactory();
        this.UUIDValue = uUIDFactory.createUUID();
        this.UUIDString = this.UUIDValue.toString();
        this.spsAction = false;
    }

    public GenericPreparedStatement(Statement statement) {
        this();
        this.statement = statement;
    }

    @Override
    public synchronized boolean upToDate() throws StandardException {
        return this.isUpToDate();
    }

    @Override
    public synchronized boolean upToDate(GeneratedClass generatedClass) {
        return this.activationClass == generatedClass && this.isUpToDate();
    }

    private boolean isUpToDate() {
        return this.isValid && this.activationClass != null && !this.compilingStatement;
    }

    final synchronized boolean isCompiling() {
        return this.compilingStatement;
    }

    final synchronized void beginCompiling() {
        this.compilingStatement = true;
        this.setActivationClass(null);
    }

    final synchronized void endCompiling() {
        this.compilingStatement = false;
        this.notifyAll();
    }

    @Override
    public void rePrepare(LanguageConnectionContext languageConnectionContext) throws StandardException {
        this.rePrepare(languageConnectionContext, false);
    }

    public void rePrepare(LanguageConnectionContext languageConnectionContext, boolean bl) throws StandardException {
        if (!this.upToDate()) {
            PreparedStatement preparedStatement = this.statement.prepare(languageConnectionContext, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Activation getActivation(LanguageConnectionContext languageConnectionContext, boolean bl) throws StandardException {
        GenericActivationHolder genericActivationHolder;
        Object object;
        Dependent dependent = this;
        synchronized (dependent) {
            object = this.getActivationClass();
            if (object == null) {
                this.rePrepare(languageConnectionContext);
                object = this.getActivationClass();
            }
            genericActivationHolder = new GenericActivationHolder(languageConnectionContext, (GeneratedClass)object, this, bl);
            ++this.inUseCount;
        }
        languageConnectionContext.closeUnusedActivations();
        dependent = null;
        object = languageConnectionContext.getStatementContext();
        if (object != null) {
            dependent = object.getActivation();
        }
        genericActivationHolder.setParentActivation((Activation)dependent);
        return genericActivationHolder;
    }

    @Override
    public ResultSet executeSubStatement(LanguageConnectionContext languageConnectionContext, boolean bl, long l) throws StandardException {
        Activation activation = languageConnectionContext.getLastActivation();
        Activation activation2 = this.getActivation(languageConnectionContext, false);
        activation2.setSingleExecution();
        languageConnectionContext.setupSubStatementSessionContext(activation);
        return this.executeStmt(activation2, bl, false, l);
    }

    @Override
    public ResultSet executeSubStatement(Activation activation, Activation activation2, boolean bl, long l) throws StandardException {
        activation.getLanguageConnectionContext().setupSubStatementSessionContext(activation);
        return this.executeStmt(activation2, bl, false, l);
    }

    @Override
    public ResultSet execute(Activation activation, boolean bl, long l) throws StandardException {
        return this.executeStmt(activation, false, bl, l);
    }

    private ResultSet executeStmt(Activation activation, boolean bl, boolean bl2, long l) throws StandardException {
        Object object;
        Object object2;
        LanguageConnectionContext languageConnectionContext;
        boolean bl3 = false;
        if (activation == null || activation.getPreparedStatement() != this) {
            throw StandardException.newException("XCL09.S", "execute");
        }
        while (true) {
            Object object3;
            if ((languageConnectionContext = activation.getLanguageConnectionContext()).getLogStatementText()) {
                object3 = Monitor.getStream();
                object2 = languageConnectionContext.getTransactionExecute().getActiveStateTxIdString();
                object = "";
                ParameterValueSet parameterValueSet = activation.getParameterValueSet();
                if (parameterValueSet != null && parameterValueSet.getParameterCount() > 0) {
                    object = " with " + parameterValueSet.getParameterCount() + " parameters " + parameterValueSet.toString();
                }
                object3.printlnWithHeader("(XID = " + (String)object2 + "), " + "(SESSIONID = " + languageConnectionContext.getInstanceNumber() + "), " + "(DATABASE = " + languageConnectionContext.getDbname() + "), " + "(DRDAID = " + languageConnectionContext.getDrdaID() + "), Executing prepared statement: " + this.getSource() + " :End prepared statement" + (String)object);
            }
            object3 = activation.getParameterValueSet();
            if (!this.spsAction) {
                this.rePrepare(languageConnectionContext, bl2);
            }
            object2 = languageConnectionContext.pushStatementContext(this.isAtomic, this.updateMode == 1, this.getSource(), (ParameterValueSet)object3, bl, l);
            object2.setActivation(activation);
            if (this.needsSavepoint()) {
                object2.setSavePoint();
                bl3 = true;
            }
            if (this.executionConstants != null) {
                languageConnectionContext.validateStmtExecution(this.executionConstants);
            }
            try {
                object = activation.execute();
                object.open();
            }
            catch (StandardException standardException) {
                if (!standardException.getMessageId().equals("XCL32.S") || this.spsAction) {
                    throw standardException;
                }
                object2.cleanupOnError(standardException);
                continue;
            }
            break;
        }
        if (bl3) {
            object2.clearSavePoint();
        }
        languageConnectionContext.popStatementContext((StatementContext)object2, null);
        if (activation.getSQLSessionContextForChildren() != null) {
            languageConnectionContext.popNestedSessionContext(activation);
        }
        if (activation.isSingleExecution() && object.isClosed()) {
            activation.close();
        }
        return object;
    }

    @Override
    public ResultDescription getResultDescription() {
        return this.resultDesc;
    }

    @Override
    public DataTypeDescriptor[] getParameterTypes() {
        return ArrayUtil.copy(this.paramTypeDescriptors);
    }

    @Override
    public DataTypeDescriptor getParameterType(int n) throws StandardException {
        if (this.paramTypeDescriptors == null) {
            throw StandardException.newException("07009", new Object[0]);
        }
        if (n < 0 || n >= this.paramTypeDescriptors.length) {
            throw StandardException.newException("XCL13.S", n + 1, this.paramTypeDescriptors.length);
        }
        return this.paramTypeDescriptors[n];
    }

    @Override
    public String getSource() {
        return this.sourceTxt != null ? this.sourceTxt : (this.statement == null ? "null" : this.statement.getSource());
    }

    @Override
    public void setSource(String string) {
        this.sourceTxt = string;
    }

    public final void setSPSName(String string) {
        this.spsName = string;
    }

    @Override
    public String getSPSName() {
        return this.spsName;
    }

    @Override
    public long getCompileTimeInMillis() {
        return this.compileTime;
    }

    @Override
    public long getParseTimeInMillis() {
        return this.parseTime;
    }

    @Override
    public long getBindTimeInMillis() {
        return this.bindTime;
    }

    @Override
    public long getOptimizeTimeInMillis() {
        return this.optimizeTime;
    }

    @Override
    public long getGenerateTimeInMillis() {
        return this.generateTime;
    }

    @Override
    public Timestamp getBeginCompileTimestamp() {
        return DataTypeUtilities.clone(this.beginCompileTimestamp);
    }

    @Override
    public Timestamp getEndCompileTimestamp() {
        return DataTypeUtilities.clone(this.endCompileTimestamp);
    }

    void setCompileTimeWarnings(SQLWarning sQLWarning) {
        this.warnings = sQLWarning;
    }

    @Override
    public final SQLWarning getCompileTimeWarnings() {
        return this.warnings;
    }

    protected void setCompileTimeMillis(long l, long l2, long l3, long l4, long l5, Timestamp timestamp, Timestamp timestamp2) {
        this.parseTime = l;
        this.bindTime = l2;
        this.optimizeTime = l3;
        this.generateTime = l4;
        this.compileTime = l5;
        this.beginCompileTimestamp = timestamp;
        this.endCompileTimestamp = timestamp2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish(LanguageConnectionContext languageConnectionContext) {
        GenericPreparedStatement genericPreparedStatement = this;
        synchronized (genericPreparedStatement) {
            --this.inUseCount;
            if (this.cacheHolder != null) {
                return;
            }
            if (this.inUseCount != 0) {
                return;
            }
        }
        try {
            this.makeInvalid(11, languageConnectionContext);
        }
        catch (StandardException standardException) {
            // empty catch block
        }
    }

    final void setConstantAction(ConstantAction constantAction) {
        this.executionConstants = constantAction;
    }

    @Override
    public final ConstantAction getConstantAction() {
        return this.executionConstants;
    }

    final void setSavedObjects(Object[] objectArray) {
        this.savedObjects = objectArray;
    }

    @Override
    public final Object getSavedObject(int n) {
        return this.savedObjects[n];
    }

    @Override
    public final List<Object> getSavedObjects() {
        return ArrayUtil.asReadOnlyList(this.savedObjects);
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public void setValid() {
        this.isValid = true;
    }

    @Override
    public void setSPSAction() {
        this.spsAction = true;
    }

    @Override
    public void prepareToInvalidate(Provider provider, int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        switch (n) {
            case 3: 
            case 5: 
            case 48: {
                return;
            }
        }
        languageConnectionContext.verifyNoOpenResultSets(this, provider, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void makeInvalid(int n, LanguageConnectionContext languageConnectionContext) throws StandardException {
        switch (n) {
            case 48: {
                return;
            }
        }
        Object object = this;
        synchronized (object) {
            if (this.compilingStatement) {
                this.invalidatedWhileCompiling = true;
                return;
            }
            boolean bl = !this.isValid;
            this.isValid = false;
            this.beginCompiling();
        }
        try {
            object = languageConnectionContext.getDataDictionary().getDependencyManager();
            object.clearDependencies(languageConnectionContext, this);
            if (this.execStmtName == null) return;
            switch (n) {
                case 5: 
                case 23: {
                    DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
                    SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(this.execSchemaName, languageConnectionContext.getTransactionCompile(), true);
                    SPSDescriptor sPSDescriptor = dataDictionary.getSPSDescriptor(this.execStmtName, schemaDescriptor);
                    sPSDescriptor.makeInvalid(n, languageConnectionContext);
                    return;
                }
            }
            return;
        }
        finally {
            this.endCompiling();
        }
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public DependableFinder getDependableFinder() {
        return null;
    }

    @Override
    public String getObjectName() {
        return this.UUIDString;
    }

    @Override
    public UUID getObjectID() {
        return this.UUIDValue;
    }

    @Override
    public String getClassType() {
        return "PreparedStatement";
    }

    @Override
    public boolean referencesSessionSchema() {
        return this.referencesSessionSchema;
    }

    public boolean referencesSessionSchema(StatementNode statementNode) throws StandardException {
        this.referencesSessionSchema = statementNode.referencesSessionSchema();
        return this.referencesSessionSchema;
    }

    void completeCompile(StatementNode statementNode) throws StandardException {
        this.paramTypeDescriptors = statementNode.getParameterTypes();
        if (this.targetTable != null) {
            this.targetTable = null;
            this.updateMode = 0;
            this.updateColumns = null;
        }
        this.resultDesc = statementNode.makeResultDescription();
        if (this.resultDesc != null) {
            this.setCursorInfo((CursorInfo)statementNode.getCursorInfo());
        }
        this.isValid = true;
        this.rowCountStats.reset();
    }

    @Override
    public GeneratedClass getActivationClass() throws StandardException {
        return this.activationClass;
    }

    void setActivationClass(GeneratedClass generatedClass) {
        this.activationClass = generatedClass;
    }

    @Override
    public int getUpdateMode() {
        return this.updateMode;
    }

    @Override
    public ExecCursorTableReference getTargetTable() {
        return this.targetTable;
    }

    @Override
    public boolean hasUpdateColumns() {
        return this.updateColumns != null && !this.updateColumns.isEmpty();
    }

    @Override
    public boolean isUpdateColumn(String string) {
        return this.updateColumns != null && this.updateColumns.contains(string);
    }

    @Override
    public Object getCursorInfo() {
        return new CursorInfo(this.updateMode, this.targetTable, this.updateColumns);
    }

    void setCursorInfo(CursorInfo cursorInfo) {
        if (cursorInfo != null) {
            this.updateMode = cursorInfo.updateMode;
            this.targetTable = cursorInfo.targetTable;
            this.updateColumns = cursorInfo.updateColumns;
        }
    }

    ByteArray getByteCodeSaver() {
        return null;
    }

    @Override
    public boolean needsSavepoint() {
        return this.needsSavepoint;
    }

    void setNeedsSavepoint(boolean bl) {
        this.needsSavepoint = bl;
    }

    void setIsAtomic(boolean bl) {
        this.isAtomic = bl;
    }

    @Override
    public boolean isAtomic() {
        return this.isAtomic;
    }

    void setExecuteStatementNameAndSchema(String string, String string2) {
        this.execStmtName = string;
        this.execSchemaName = string2;
    }

    @Override
    public ExecPreparedStatement getClone() throws StandardException {
        GenericPreparedStatement genericPreparedStatement = new GenericPreparedStatement(this.statement);
        genericPreparedStatement.activationClass = this.getActivationClass();
        genericPreparedStatement.resultDesc = this.resultDesc;
        genericPreparedStatement.paramTypeDescriptors = this.paramTypeDescriptors;
        genericPreparedStatement.executionConstants = this.executionConstants;
        genericPreparedStatement.UUIDString = this.UUIDString;
        genericPreparedStatement.UUIDValue = this.UUIDValue;
        genericPreparedStatement.savedObjects = this.savedObjects;
        genericPreparedStatement.execStmtName = this.execStmtName;
        genericPreparedStatement.execSchemaName = this.execSchemaName;
        genericPreparedStatement.isAtomic = this.isAtomic;
        genericPreparedStatement.sourceTxt = this.sourceTxt;
        genericPreparedStatement.targetTable = this.targetTable;
        genericPreparedStatement.updateColumns = this.updateColumns;
        genericPreparedStatement.updateMode = this.updateMode;
        genericPreparedStatement.needsSavepoint = this.needsSavepoint;
        genericPreparedStatement.rowCountStats = this.rowCountStats;
        return genericPreparedStatement;
    }

    public void setCacheHolder(Cacheable cacheable) {
        this.cacheHolder = cacheable;
        if (cacheable == null) {
            if (!this.isValid || this.inUseCount != 0) {
                return;
            }
            ContextManager contextManager = GenericPreparedStatement.getContextService().getCurrentContextManager();
            LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)contextManager.getContext("LanguageConnectionContext");
            try {
                this.makeInvalid(11, languageConnectionContext);
            }
            catch (StandardException standardException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return this.getObjectName();
    }

    public boolean isStorable() {
        return false;
    }

    public void setRequiredPermissionsList(List<StatementPermission> list) {
        this.requiredPermissionsList = list;
    }

    @Override
    public List<StatementPermission> getRequiredPermissionsList() {
        return this.requiredPermissionsList;
    }

    @Override
    public final long getVersionCounter() {
        return this.versionCounter;
    }

    public final void incrementVersionCounter() {
        ++this.versionCounter;
    }

    @Override
    public int incrementExecutionCount() {
        return this.rowCountStats.incrementExecutionCount();
    }

    @Override
    public void setStalePlanCheckInterval(int n) {
        this.rowCountStats.setStalePlanCheckInterval(n);
    }

    @Override
    public int getStalePlanCheckInterval() {
        return this.rowCountStats.getStalePlanCheckInterval();
    }

    @Override
    public long getInitialRowCount(int n, long l) {
        return this.rowCountStats.getInitialRowCount(n, l);
    }

    private static ContextService getContextService() {
        return AccessController.doPrivileged(new PrivilegedAction<ContextService>(){

            @Override
            public ContextService run() {
                return ContextService.getFactory();
            }
        });
    }

    private static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }

    private static class RowCountStatistics {
        private int stalePlanCheckInterval;
        private int executionCount;
        private ArrayList<Long> rowCounts;

        private RowCountStatistics() {
        }

        int incrementExecutionCount() {
            return ++this.executionCount;
        }

        synchronized long getInitialRowCount(int n, long l) {
            Long l2;
            if (this.rowCounts == null) {
                this.rowCounts = new ArrayList();
            }
            if (n >= this.rowCounts.size()) {
                int n2 = n + 1;
                this.rowCounts.addAll(Collections.nCopies(n2 - this.rowCounts.size(), null));
            }
            if ((l2 = this.rowCounts.get(n)) == null) {
                this.rowCounts.set(n, l);
                return l;
            }
            return l2;
        }

        void setStalePlanCheckInterval(int n) {
            this.stalePlanCheckInterval = n;
        }

        int getStalePlanCheckInterval() {
            return this.stalePlanCheckInterval;
        }

        synchronized void reset() {
            this.stalePlanCheckInterval = 0;
            this.executionCount = 0;
            this.rowCounts = null;
        }
    }
}

