/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.runtime.actionstate;

import java.util.Map;
import org.apache.flink.util.MathUtils;
import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.common.Cluster;

public class ActionStateKeyPartitioner
implements Partitioner {
    @Override
    public int partition(String topic, Object key, byte[] keyBytes, Object value, byte[] valueBytes, Cluster cluster) {
        int numPartitions = cluster.partitionsForTopic(topic).size();
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        if (!(key instanceof String)) {
            throw new IllegalArgumentException("Key must be a String");
        }
        String[] keyParts = ((String)key).split("_");
        if (keyParts.length < 4) {
            throw new IllegalArgumentException("Key format is invalid");
        }
        if ("".equalsIgnoreCase(keyParts[0])) {
            throw new IllegalArgumentException("First part of the key cannot be empty");
        }
        return MathUtils.murmurHash((int)keyParts[0].hashCode()) % numPartitions;
    }

    @Override
    public void close() {
    }

    @Override
    public void configure(Map<String, ?> configs) {
    }
}

