/*
 * Decompiled with CFR 0.152.
 */
package io.github.ollama4j.models.response;

import io.github.ollama4j.exceptions.OllamaBaseException;
import io.github.ollama4j.models.generate.OllamaGenerateRequest;
import io.github.ollama4j.models.generate.OllamaGenerateResponseModel;
import io.github.ollama4j.models.response.OllamaErrorResponse;
import io.github.ollama4j.models.response.OllamaResultStream;
import io.github.ollama4j.utils.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import lombok.Generated;

public class OllamaAsyncResultStreamer
extends Thread {
    private final HttpRequest.Builder requestBuilder;
    private final OllamaGenerateRequest ollamaRequestModel;
    private final OllamaResultStream thinkingResponseStream = new OllamaResultStream();
    private final OllamaResultStream responseStream = new OllamaResultStream();
    private String completeResponse;
    private String completeThinkingResponse;
    private boolean succeeded;
    private long requestTimeoutSeconds;
    private int httpStatusCode;
    private long responseTime = 0L;

    public OllamaAsyncResultStreamer(HttpRequest.Builder requestBuilder, OllamaGenerateRequest ollamaRequestModel, long requestTimeoutSeconds) {
        this.requestBuilder = requestBuilder;
        this.ollamaRequestModel = ollamaRequestModel;
        this.completeResponse = "";
        this.responseStream.add("");
        this.requestTimeoutSeconds = requestTimeoutSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.ollamaRequestModel.setStream(true);
        HttpClient httpClient = HttpClient.newHttpClient();
        long startTime = System.currentTimeMillis();
        try {
            int statusCode;
            HttpRequest request = this.requestBuilder.POST(HttpRequest.BodyPublishers.ofString(Utils.getObjectMapper().writeValueAsString(this.ollamaRequestModel))).header("Content-Type", "application/json").timeout(Duration.ofSeconds(this.requestTimeoutSeconds)).build();
            HttpResponse<InputStream> response = httpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
            this.httpStatusCode = statusCode = response.statusCode();
            InputStream responseBodyStream = response.body();
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader(responseBodyStream, StandardCharsets.UTF_8));
                StringBuilder thinkingBuffer = new StringBuilder();
                StringBuilder responseBuffer = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    Object ollamaResponseModel;
                    if (statusCode == 404) {
                        ollamaResponseModel = Utils.getObjectMapper().readValue(line, OllamaErrorResponse.class);
                        this.responseStream.add(((OllamaErrorResponse)ollamaResponseModel).getError());
                        responseBuffer.append(((OllamaErrorResponse)ollamaResponseModel).getError());
                        continue;
                    }
                    ollamaResponseModel = Utils.getObjectMapper().readValue(line, OllamaGenerateResponseModel.class);
                    String thinkingTokens = ((OllamaGenerateResponseModel)ollamaResponseModel).getThinking();
                    String responseTokens = ((OllamaGenerateResponseModel)ollamaResponseModel).getResponse();
                    if (thinkingTokens == null) {
                        thinkingTokens = "";
                    }
                    if (responseTokens == null) {
                        responseTokens = "";
                    }
                    this.thinkingResponseStream.add(thinkingTokens);
                    this.responseStream.add(responseTokens);
                    if (((OllamaGenerateResponseModel)ollamaResponseModel).isDone()) continue;
                    responseBuffer.append(responseTokens);
                    thinkingBuffer.append(thinkingTokens);
                }
                this.succeeded = true;
                this.completeThinkingResponse = thinkingBuffer.toString();
                this.completeResponse = responseBuffer.toString();
                long endTime = System.currentTimeMillis();
                this.responseTime = endTime - startTime;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (responseBodyStream != null) {
                    try {
                        responseBodyStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (statusCode != 200) {
                throw new OllamaBaseException(this.completeResponse);
            }
        }
        catch (OllamaBaseException | IOException | InterruptedException e) {
            this.succeeded = false;
            this.completeResponse = "[FAILED] " + e.getMessage();
        }
    }

    @Generated
    public HttpRequest.Builder getRequestBuilder() {
        return this.requestBuilder;
    }

    @Generated
    public OllamaGenerateRequest getOllamaRequestModel() {
        return this.ollamaRequestModel;
    }

    @Generated
    public OllamaResultStream getThinkingResponseStream() {
        return this.thinkingResponseStream;
    }

    @Generated
    public OllamaResultStream getResponseStream() {
        return this.responseStream;
    }

    @Generated
    public String getCompleteResponse() {
        return this.completeResponse;
    }

    @Generated
    public String getCompleteThinkingResponse() {
        return this.completeThinkingResponse;
    }

    @Generated
    public long getRequestTimeoutSeconds() {
        return this.requestTimeoutSeconds;
    }

    @Generated
    public void setCompleteResponse(String completeResponse) {
        this.completeResponse = completeResponse;
    }

    @Generated
    public void setCompleteThinkingResponse(String completeThinkingResponse) {
        this.completeThinkingResponse = completeThinkingResponse;
    }

    @Generated
    public void setSucceeded(boolean succeeded) {
        this.succeeded = succeeded;
    }

    @Generated
    public void setHttpStatusCode(int httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    @Generated
    public void setResponseTime(long responseTime) {
        this.responseTime = responseTime;
    }

    @Override
    @Generated
    public String toString() {
        return "OllamaAsyncResultStreamer(requestBuilder=" + String.valueOf(this.getRequestBuilder()) + ", ollamaRequestModel=" + String.valueOf(this.getOllamaRequestModel()) + ", thinkingResponseStream=" + String.valueOf(this.getThinkingResponseStream()) + ", responseStream=" + String.valueOf(this.getResponseStream()) + ", completeResponse=" + this.getCompleteResponse() + ", completeThinkingResponse=" + this.getCompleteThinkingResponse() + ", succeeded=" + this.isSucceeded() + ", requestTimeoutSeconds=" + this.getRequestTimeoutSeconds() + ", httpStatusCode=" + this.getHttpStatusCode() + ", responseTime=" + this.getResponseTime() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OllamaAsyncResultStreamer)) {
            return false;
        }
        OllamaAsyncResultStreamer other = (OllamaAsyncResultStreamer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isSucceeded() != other.isSucceeded()) {
            return false;
        }
        if (this.getRequestTimeoutSeconds() != other.getRequestTimeoutSeconds()) {
            return false;
        }
        if (this.getHttpStatusCode() != other.getHttpStatusCode()) {
            return false;
        }
        if (this.getResponseTime() != other.getResponseTime()) {
            return false;
        }
        HttpRequest.Builder this$requestBuilder = this.getRequestBuilder();
        HttpRequest.Builder other$requestBuilder = other.getRequestBuilder();
        if (this$requestBuilder == null ? other$requestBuilder != null : !this$requestBuilder.equals(other$requestBuilder)) {
            return false;
        }
        OllamaGenerateRequest this$ollamaRequestModel = this.getOllamaRequestModel();
        OllamaGenerateRequest other$ollamaRequestModel = other.getOllamaRequestModel();
        if (this$ollamaRequestModel == null ? other$ollamaRequestModel != null : !((Object)this$ollamaRequestModel).equals(other$ollamaRequestModel)) {
            return false;
        }
        OllamaResultStream this$thinkingResponseStream = this.getThinkingResponseStream();
        OllamaResultStream other$thinkingResponseStream = other.getThinkingResponseStream();
        if (this$thinkingResponseStream == null ? other$thinkingResponseStream != null : !((Object)this$thinkingResponseStream).equals(other$thinkingResponseStream)) {
            return false;
        }
        OllamaResultStream this$responseStream = this.getResponseStream();
        OllamaResultStream other$responseStream = other.getResponseStream();
        if (this$responseStream == null ? other$responseStream != null : !((Object)this$responseStream).equals(other$responseStream)) {
            return false;
        }
        String this$completeResponse = this.getCompleteResponse();
        String other$completeResponse = other.getCompleteResponse();
        if (this$completeResponse == null ? other$completeResponse != null : !this$completeResponse.equals(other$completeResponse)) {
            return false;
        }
        String this$completeThinkingResponse = this.getCompleteThinkingResponse();
        String other$completeThinkingResponse = other.getCompleteThinkingResponse();
        return !(this$completeThinkingResponse == null ? other$completeThinkingResponse != null : !this$completeThinkingResponse.equals(other$completeThinkingResponse));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OllamaAsyncResultStreamer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isSucceeded() ? 79 : 97);
        long $requestTimeoutSeconds = this.getRequestTimeoutSeconds();
        result = result * 59 + (int)($requestTimeoutSeconds >>> 32 ^ $requestTimeoutSeconds);
        result = result * 59 + this.getHttpStatusCode();
        long $responseTime = this.getResponseTime();
        result = result * 59 + (int)($responseTime >>> 32 ^ $responseTime);
        HttpRequest.Builder $requestBuilder = this.getRequestBuilder();
        result = result * 59 + ($requestBuilder == null ? 43 : $requestBuilder.hashCode());
        OllamaGenerateRequest $ollamaRequestModel = this.getOllamaRequestModel();
        result = result * 59 + ($ollamaRequestModel == null ? 43 : ((Object)$ollamaRequestModel).hashCode());
        OllamaResultStream $thinkingResponseStream = this.getThinkingResponseStream();
        result = result * 59 + ($thinkingResponseStream == null ? 43 : ((Object)$thinkingResponseStream).hashCode());
        OllamaResultStream $responseStream = this.getResponseStream();
        result = result * 59 + ($responseStream == null ? 43 : ((Object)$responseStream).hashCode());
        String $completeResponse = this.getCompleteResponse();
        result = result * 59 + ($completeResponse == null ? 43 : $completeResponse.hashCode());
        String $completeThinkingResponse = this.getCompleteThinkingResponse();
        result = result * 59 + ($completeThinkingResponse == null ? 43 : $completeThinkingResponse.hashCode());
        return result;
    }

    @Generated
    public boolean isSucceeded() {
        return this.succeeded;
    }

    @Generated
    public void setRequestTimeoutSeconds(long requestTimeoutSeconds) {
        this.requestTimeoutSeconds = requestTimeoutSeconds;
    }

    @Generated
    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    @Generated
    public long getResponseTime() {
        return this.responseTime;
    }
}

