/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.result;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.management.cli.Result;
import org.apache.geode.management.internal.cli.GfshParser;
import org.apache.geode.management.internal.cli.result.Row;
import org.apache.geode.management.internal.cli.result.RowGroup;
import org.apache.geode.management.internal.cli.result.Table;
import org.apache.geode.management.internal.cli.result.TableBuilder;
import org.apache.geode.management.internal.cli.result.model.AbstractResultModel;
import org.apache.geode.management.internal.cli.result.model.DataResultModel;
import org.apache.geode.management.internal.cli.result.model.InfoResultModel;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.result.model.TabularResultModel;

public class CommandResult
implements Result {
    private final ResultModel result;
    private List<String> commandOutput;
    private int commandOutputIndex;

    public CommandResult(ResultModel result) {
        this.result = result;
    }

    public ResultModel getResultData() {
        return this.result;
    }

    public String getType() {
        return "model";
    }

    @Override
    public Result.Status getStatus() {
        return this.result.getStatus();
    }

    @Override
    public void resetToFirstLine() {
        this.commandOutputIndex = 0;
    }

    @Override
    public boolean hasNextLine() {
        if (this.commandOutput == null) {
            this.buildCommandOutput();
        }
        return this.commandOutputIndex < this.commandOutput.size();
    }

    @Override
    public String nextLine() {
        if (this.commandOutput == null) {
            this.buildCommandOutput();
        }
        return this.commandOutput.get(this.commandOutputIndex++);
    }

    private void buildCommandOutput() {
        this.commandOutputIndex = 0;
        this.commandOutput = new ArrayList<String>();
        Table resultTable = new TableBuilder().newTable();
        this.addSpacedRowInTable(resultTable, this.result.getHeader());
        int index = 0;
        int sectionSize = this.result.getContent().size();
        for (AbstractResultModel section : this.result.getContent().values()) {
            ++index;
            if (section instanceof DataResultModel) {
                this.buildData(resultTable, (DataResultModel)section);
            } else if (section instanceof TabularResultModel) {
                this.buildTabularCommandOutput(resultTable, (TabularResultModel)section);
            } else if (section instanceof InfoResultModel) {
                this.buildInfoOrErrorCommandOutput(resultTable, (InfoResultModel)section);
            } else {
                throw new IllegalArgumentException("Unable to process output for " + section.getClass().getName());
            }
            if (index >= sectionSize) continue;
            this.addSpacedRowInTable(resultTable, System.lineSeparator());
        }
        this.addSpacedRowInTable(resultTable, this.result.getFooter());
        this.commandOutput.addAll(resultTable.buildTableList());
    }

    private void addSpacedRowInTable(Table resultTable, String row) {
        if (StringUtils.isNotBlank((CharSequence)row)) {
            resultTable.newRow().newLeftCol(row);
        }
    }

    private void addRowInRowGroup(RowGroup rowGroup, String row) {
        if (StringUtils.isNotBlank((CharSequence)row)) {
            rowGroup.newRow().newLeftCol(row);
        }
    }

    private void buildTabularCommandOutput(Table resultTable, TabularResultModel model) {
        this.addSpacedRowInTable(resultTable, model.getHeader());
        resultTable.setColumnSeparator("   ");
        resultTable.setTabularResult(true);
        RowGroup rowGroup = resultTable.newRowGroup();
        this.buildTable(rowGroup, model);
        this.addSpacedRowInTable(resultTable, model.getFooter());
    }

    private void buildTable(RowGroup rowGroup, TabularResultModel model) {
        Row headerRow = rowGroup.newRow();
        rowGroup.setColumnSeparator(" | ");
        rowGroup.newRowSeparator(Character.valueOf('-'), false);
        Object rows = model.getContent();
        if (!rows.isEmpty()) {
            rows.keySet().forEach(headerRow::newCenterCol);
            int rowCount = ((List)rows.values().iterator().next()).size();
            for (int i = 0; i < rowCount; ++i) {
                Row oneRow = rowGroup.newRow();
                for (String column : rows.keySet()) {
                    oneRow.newLeftCol(((List)rows.get(column)).get(i));
                }
            }
        }
    }

    private void buildData(Table resultTable, DataResultModel section) {
        RowGroup rowGroup = resultTable.newRowGroup();
        rowGroup.setColumnSeparator(" : ");
        this.addRowInRowGroup(rowGroup, section.getHeader());
        for (Map.Entry entry : section.getContent().entrySet()) {
            Row newRow = rowGroup.newRow();
            String key = (String)entry.getKey();
            String[] values = ((String)entry.getValue()).split(GfshParser.LINE_SEPARATOR);
            if (values.length == 1) {
                newRow.newLeftCol(key).newLeftCol(values[0]);
                continue;
            }
            if (values.length != 0) {
                newRow.newLeftCol(key).newLeftCol(values[0]);
                for (int i = 1; i < values.length; ++i) {
                    newRow = rowGroup.newRow();
                    newRow.setColumnSeparator("   ");
                    newRow.newLeftCol("").newLeftCol(values[i]);
                }
                continue;
            }
            newRow.newLeftCol(key).newLeftCol("");
        }
        this.addRowInRowGroup(rowGroup, section.getFooter());
    }

    private void buildInfoOrErrorCommandOutput(Table resultTable, InfoResultModel model) {
        RowGroup rowGroup = resultTable.newRowGroup();
        this.addRowInRowGroup(rowGroup, model.getHeader());
        model.getContent().forEach(c -> rowGroup.newRow().newLeftCol(c));
        this.addRowInRowGroup(rowGroup, model.getFooter());
    }
}

