/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.internal.FunctionExecutionPooledExecutor;
import org.apache.geode.distributed.internal.OverflowQueueWithDMStats;
import org.apache.geode.distributed.internal.PoolStatHelper;
import org.apache.geode.distributed.internal.PooledExecutorWithDMStats;
import org.apache.geode.distributed.internal.QueueStatHelper;
import org.apache.geode.distributed.internal.SerialQueuedExecutorWithDMStats;
import org.apache.geode.internal.ScheduledThreadPoolExecutorWithKeepAlive;
import org.apache.geode.internal.monitoring.ThreadsMonitoring;
import org.apache.geode.logging.internal.executors.LoggingExecutors;
import org.apache.geode.logging.internal.executors.LoggingThreadFactory;

public class CoreLoggingExecutors {
    private static final String IDLE_THREAD_TIMEOUT_MILLIS_PROPERTY = "IDLE_THREAD_TIMEOUT";
    private static final int DEFAULT_IDLE_THREAD_TIMEOUT_MILLIS = 1800000;

    public static ExecutorService newFixedThreadPoolWithTimeout(int poolSize, long keepAliveTime, TimeUnit unit, QueueStatHelper queueStatHelper, String threadName) {
        BlockingQueue<Runnable> workQueue = CoreLoggingExecutors.createWorkQueueWithStatistics(0, queueStatHelper);
        return LoggingExecutors.newFixedThreadPool((int)poolSize, (long)keepAliveTime, (TimeUnit)unit, workQueue, (String)threadName, (boolean)true);
    }

    public static ExecutorService newFunctionThreadPoolWithFeedStatistics(int poolSize, int workQueueSize, QueueStatHelper queueStatHelper, String threadName, LoggingThreadFactory.ThreadInitializer threadInitializer, LoggingThreadFactory.CommandWrapper commandWrapper, PoolStatHelper poolStatHelper, ThreadsMonitoring threadsMonitoring) {
        BlockingQueue<Runnable> workQueue = CoreLoggingExecutors.createWorkQueueWithStatistics(workQueueSize, queueStatHelper);
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, threadInitializer, commandWrapper);
        return new FunctionExecutionPooledExecutor(poolSize, workQueue, (ThreadFactory)threadFactory, poolStatHelper, threadsMonitoring);
    }

    public static ExecutorService newSerialThreadPool(BlockingQueue<Runnable> workQueue, String threadName, LoggingThreadFactory.ThreadInitializer threadInitializer, LoggingThreadFactory.CommandWrapper commandWrapper, PoolStatHelper poolStatHelper, ThreadsMonitoring threadsMonitoring) {
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, threadInitializer, commandWrapper);
        return new SerialQueuedExecutorWithDMStats(workQueue, (ThreadFactory)threadFactory, poolStatHelper, threadsMonitoring);
    }

    public static ExecutorService newSerialThreadPoolWithFeedStatistics(int workQueueSize, QueueStatHelper queueStatHelper, String threadName, LoggingThreadFactory.ThreadInitializer threadInitializer, LoggingThreadFactory.CommandWrapper commandWrapper, PoolStatHelper poolStatHelper, ThreadsMonitoring threadsMonitoring) {
        BlockingQueue<Runnable> workQueue = CoreLoggingExecutors.createWorkQueueWithStatistics(workQueueSize, queueStatHelper);
        return CoreLoggingExecutors.newSerialThreadPool(workQueue, threadName, threadInitializer, commandWrapper, poolStatHelper, threadsMonitoring);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int poolSize, long keepAliveTime, TimeUnit unit, String threadName, ThreadsMonitoring threadsMonitoring) {
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName);
        ScheduledThreadPoolExecutorWithKeepAlive result = new ScheduledThreadPoolExecutorWithKeepAlive(poolSize, keepAliveTime, unit, (ThreadFactory)threadFactory, threadsMonitoring);
        result.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        result.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        return result;
    }

    public static ExecutorService newThreadPool(int poolSize, BlockingQueue<Runnable> workQueue, String threadName, LoggingThreadFactory.ThreadInitializer threadInitializer, LoggingThreadFactory.CommandWrapper commandWrapper, PoolStatHelper poolStatHelper, ThreadsMonitoring threadsMonitoring) {
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, threadInitializer, commandWrapper);
        return new PooledExecutorWithDMStats(poolSize, (long)CoreLoggingExecutors.getIdleThreadTimeoutMillis(), TimeUnit.MILLISECONDS, workQueue, (ThreadFactory)threadFactory, poolStatHelper, threadsMonitoring);
    }

    public static ExecutorService newThreadPoolWithFixedFeed(int poolSize, long keepAliveTime, TimeUnit unit, int workQueueSize, String threadName, LoggingThreadFactory.CommandWrapper commandWrapper, PoolStatHelper poolStatHelper, ThreadsMonitoring threadsMonitoring) {
        ArrayBlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<Runnable>(workQueueSize);
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, commandWrapper);
        return new PooledExecutorWithDMStats(poolSize, keepAliveTime, unit, workQueue, (ThreadFactory)threadFactory, poolStatHelper, threadsMonitoring);
    }

    public static ExecutorService newThreadPoolWithFeedStatistics(int poolSize, int workQueueSize, QueueStatHelper queueStatHelper, String threadName, LoggingThreadFactory.ThreadInitializer threadInitializer, LoggingThreadFactory.CommandWrapper commandWrapper, PoolStatHelper poolStatHelper, ThreadsMonitoring threadsMonitoring) {
        BlockingQueue<Runnable> workQueue = CoreLoggingExecutors.createWorkQueueWithStatistics(workQueueSize, queueStatHelper);
        return CoreLoggingExecutors.newThreadPool(poolSize, workQueue, threadName, threadInitializer, commandWrapper, poolStatHelper, threadsMonitoring);
    }

    public static ExecutorService newThreadPoolWithSynchronousFeed(int poolSize, String threadName, LoggingThreadFactory.CommandWrapper commandWrapper) {
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, commandWrapper);
        SynchronousQueue<Runnable> workQueue = new SynchronousQueue<Runnable>();
        return new PooledExecutorWithDMStats(poolSize, (long)CoreLoggingExecutors.getIdleThreadTimeoutMillis(), TimeUnit.MILLISECONDS, workQueue, (ThreadFactory)threadFactory, null, null);
    }

    public static ExecutorService newThreadPoolWithSynchronousFeed(int poolSize, long keepAliveTime, TimeUnit unit, String threadName, LoggingThreadFactory.CommandWrapper commandWrapper, PoolStatHelper poolStatHelper, ThreadsMonitoring threadsMonitoring) {
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, commandWrapper);
        SynchronousQueue<Runnable> workQueue = new SynchronousQueue<Runnable>();
        return new PooledExecutorWithDMStats(poolSize, keepAliveTime, unit, workQueue, (ThreadFactory)threadFactory, poolStatHelper, threadsMonitoring);
    }

    public static ExecutorService newThreadPoolWithSynchronousFeed(int poolSize, long keepAliveTime, TimeUnit unit, String threadName, RejectedExecutionHandler rejectionHandler, PoolStatHelper poolStatHelper) {
        SynchronousQueue<Runnable> workQueue = new SynchronousQueue<Runnable>();
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName);
        return new PooledExecutorWithDMStats(poolSize, keepAliveTime, unit, workQueue, (ThreadFactory)threadFactory, rejectionHandler, poolStatHelper, null);
    }

    public static ExecutorService newThreadPoolWithSynchronousFeed(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, String threadName, LoggingThreadFactory.ThreadInitializer threadInitializer, LoggingThreadFactory.CommandWrapper commandWrapper) {
        SynchronousQueue<Runnable> blockingQueue = new SynchronousQueue<Runnable>();
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, threadInitializer, commandWrapper);
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, blockingQueue, (ThreadFactory)threadFactory);
    }

    public static ExecutorService newThreadPoolWithSynchronousFeed(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, String threadName) {
        return CoreLoggingExecutors.newThreadPoolWithSynchronousFeed(corePoolSize, maximumPoolSize, keepAliveTime, unit, threadName, null, null);
    }

    public static ExecutorService newThreadPoolWithSynchronousFeedThatHandlesRejection(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, String threadName, LoggingThreadFactory.ThreadInitializer threadInitializer, LoggingThreadFactory.CommandWrapper commandWrapper) {
        SynchronousQueue<Runnable> blockingQueue = new SynchronousQueue<Runnable>();
        QueuingRejectedExecutionHandler rejectedExecutionHandler = new QueuingRejectedExecutionHandler(blockingQueue);
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, threadInitializer, commandWrapper);
        return new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, blockingQueue, (ThreadFactory)threadFactory, rejectedExecutionHandler);
    }

    public static ExecutorService newThreadPoolWithUnlimitedFeed(int poolSize, long keepAliveTime, TimeUnit unit, String threadName, LoggingThreadFactory.ThreadInitializer threadInitializer, LoggingThreadFactory.CommandWrapper commandWrapper, PoolStatHelper poolStatHelper, ThreadsMonitoring threadsMonitoring) {
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
        LoggingThreadFactory threadFactory = new LoggingThreadFactory(threadName, threadInitializer, commandWrapper);
        return new PooledExecutorWithDMStats(poolSize, keepAliveTime, unit, workQueue, (ThreadFactory)threadFactory, poolStatHelper, threadsMonitoring);
    }

    private CoreLoggingExecutors() {
    }

    private static BlockingQueue<Runnable> createWorkQueueWithStatistics(int workQueueSize, QueueStatHelper queueStatHelper) {
        OverflowQueueWithDMStats<Runnable> workQueue = workQueueSize == 0 ? new OverflowQueueWithDMStats<Runnable>(queueStatHelper) : new OverflowQueueWithDMStats(workQueueSize, queueStatHelper);
        return workQueue;
    }

    private static int getIdleThreadTimeoutMillis() {
        return Integer.getInteger("gemfire.IDLE_THREAD_TIMEOUT", 1800000);
    }

    @VisibleForTesting
    static class QueuingRejectedExecutionHandler
    implements RejectedExecutionHandler {
        private final BlockingQueue<Runnable> blockingQueue;

        private QueuingRejectedExecutionHandler(BlockingQueue<Runnable> blockingQueue) {
            this.blockingQueue = blockingQueue;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            try {
                this.blockingQueue.put(r);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new RejectedExecutionException("interrupted", ex);
            }
        }
    }
}

