/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.sequencelog.model;

import java.util.SortedMap;
import org.apache.geode.internal.sequencelog.model.Graph;
import org.apache.geode.internal.sequencelog.model.Vertex;

public class Edge {
    private final long timestamp;
    private final String name;
    private final String source;
    private final Vertex dest;
    private final Graph graph;

    public Edge(Graph graph, long timestamp, String name, String sourceName, Vertex destVertex) {
        this.graph = graph;
        this.timestamp = timestamp;
        this.name = name;
        this.source = sourceName;
        this.dest = destVertex;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dest == null ? 0 : this.dest.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Edge)) {
            return false;
        }
        Edge other = (Edge)obj;
        if (this.dest == null ? other.dest != null : !this.dest.equals(other.dest)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        return this.timestamp == other.timestamp;
    }

    public String toString() {
        return this.name;
    }

    public String getSourceName() {
        return this.source;
    }

    public String getName() {
        return this.name;
    }

    public Vertex getSource() {
        SortedMap<Long, Vertex> sourceMap = this.graph.getIndexedVertices().get(this.source);
        if (sourceMap == null) {
            return null;
        }
        SortedMap<Long, Vertex> headMap = sourceMap.headMap(this.dest.getTimestamp() + 1L);
        if (headMap.isEmpty()) {
            return null;
        }
        Long closestTimestamp = headMap.lastKey();
        return (Vertex)headMap.get(closestTimestamp);
    }

    public Vertex getDest() {
        return this.dest;
    }

    public long getTimestamp() {
        return this.timestamp;
    }
}

