/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.uri;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.http.uri.DefaultUriBuilder;
import java.net.URI;
import java.util.Map;

public interface UriBuilder {
    @NonNull
    public UriBuilder fragment(@Nullable String var1);

    @NonNull
    public UriBuilder scheme(@Nullable String var1);

    @NonNull
    public UriBuilder userInfo(@Nullable String var1);

    @NonNull
    public UriBuilder host(@Nullable String var1);

    @NonNull
    public UriBuilder port(int var1);

    @NonNull
    public UriBuilder path(@Nullable String var1);

    @NonNull
    public UriBuilder replacePath(@Nullable String var1);

    @NonNull
    public UriBuilder queryParam(String var1, Object ... var2);

    @NonNull
    public UriBuilder replaceQueryParam(String var1, Object ... var2);

    @NonNull
    public URI build();

    @NonNull
    public URI expand(Map<String, ? super Object> var1);

    @NonNull
    public static UriBuilder of(@NonNull URI uri) {
        ArgumentUtils.requireNonNull("uri", uri);
        return new DefaultUriBuilder(uri);
    }

    @NonNull
    public static UriBuilder of(@NonNull CharSequence uri) {
        ArgumentUtils.requireNonNull("uri", uri);
        return new DefaultUriBuilder(uri);
    }
}

