/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.normalization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.InputLocationTracker;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.merge.MavenModelMerger;
import org.apache.maven.model.normalization.ModelNormalizer;
import org.codehaus.plexus.util.StringUtils;

@Named
@Singleton
public class DefaultModelNormalizer
implements ModelNormalizer {
    private DuplicateMerger merger = new DuplicateMerger();

    @Override
    public void mergeDuplicates(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        LinkedHashMap<String, InputLocationTracker> normalized;
        Build build = model.getBuild();
        if (build != null) {
            List<Plugin> plugins = build.getPlugins();
            normalized = new LinkedHashMap<String, InputLocationTracker>(plugins.size() * 2);
            for (Plugin plugin2 : plugins) {
                String key = plugin2.getKey();
                Plugin first = (Plugin)normalized.get(key);
                if (first != null) {
                    this.merger.mergePlugin(plugin2, first);
                }
                normalized.put(key, plugin2);
            }
            if (plugins.size() != normalized.size()) {
                build.setPlugins(new ArrayList<Plugin>(normalized.values()));
            }
        }
        List<Dependency> dependencies2 = model.getDependencies();
        normalized = new LinkedHashMap(dependencies2.size() * 2);
        for (Dependency dependency : dependencies2) {
            normalized.put(dependency.getManagementKey(), dependency);
        }
        if (dependencies2.size() != normalized.size()) {
            model.setDependencies(new ArrayList<Dependency>(normalized.values()));
        }
    }

    @Override
    public void injectDefaultValues(Model model, ModelBuildingRequest request, ModelProblemCollector problems) {
        this.injectDependencyDefaults(model.getDependencies());
        Build build = model.getBuild();
        if (build != null) {
            for (Plugin plugin2 : build.getPlugins()) {
                this.injectDependencyDefaults(plugin2.getDependencies());
            }
        }
    }

    private void injectDependencyDefaults(List<Dependency> dependencies2) {
        for (Dependency dependency : dependencies2) {
            if (!StringUtils.isEmpty(dependency.getScope())) continue;
            dependency.setScope("compile");
        }
    }

    protected static class DuplicateMerger
    extends MavenModelMerger {
        protected DuplicateMerger() {
        }

        public void mergePlugin(Plugin target, Plugin source) {
            super.mergePlugin(target, source, false, Collections.emptyMap());
        }
    }
}

