/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.cli.command;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.ReflectiveAccess;
import io.micronaut.core.util.StringUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.application.ContextFactory;
import org.grails.forge.application.Project;
import org.grails.forge.application.generator.ProjectGenerator;
import org.grails.forge.cli.command.BaseCommand;
import org.grails.forge.cli.command.GormImplCandidates;
import org.grails.forge.cli.command.GormImplConverter;
import org.grails.forge.cli.command.ListFeatures;
import org.grails.forge.cli.command.ServletImplCandidates;
import org.grails.forge.cli.command.ServletImplConverter;
import org.grails.forge.cli.command.TestFrameworkCandidates;
import org.grails.forge.cli.command.TestFrameworkConverter;
import org.grails.forge.feature.AvailableFeatures;
import org.grails.forge.io.FileSystemOutputHandler;
import org.grails.forge.io.OutputHandler;
import org.grails.forge.options.GormImpl;
import org.grails.forge.options.JdkVersion;
import org.grails.forge.options.Options;
import org.grails.forge.options.ServletImpl;
import org.grails.forge.options.TestFramework;
import org.grails.forge.util.NameUtils;
import picocli.CommandLine;

public abstract class CreateCommand
extends BaseCommand
implements Callable<Integer> {
    protected final AvailableFeatures availableFeatures;
    @ReflectiveAccess
    @CommandLine.Parameters(arity="0..1", paramLabel="NAME", description={"The name of the application to create."})
    String name;
    @ReflectiveAccess
    @CommandLine.Option(names={"-t", "--test"}, paramLabel="TEST", description={"Which test framework to use. Possible values: ${COMPLETION-CANDIDATES}."}, completionCandidates=TestFrameworkCandidates.class, converter={TestFrameworkConverter.class})
    TestFramework test;
    @ReflectiveAccess
    @CommandLine.Option(names={"-g", "--gorm"}, paramLabel="GORM Implementation", description={"Which GORM Implementation to configure. Possible values: ${COMPLETION-CANDIDATES}."}, completionCandidates=GormImplCandidates.class, converter={GormImplConverter.class})
    GormImpl gormImpl;
    @ReflectiveAccess
    @CommandLine.Option(names={"-s", "--servlet"}, paramLabel="Servlet Implementation", description={"Which Servlet Implementation to configure. Possible values: ${COMPLETION-CANDIDATES}."}, completionCandidates=ServletImplCandidates.class, converter={ServletImplConverter.class})
    ServletImpl servletImpl;
    @ReflectiveAccess
    @CommandLine.Option(names={"-i", "--inplace"}, description={"Create a service using the current directory"})
    boolean inplace;
    @ReflectiveAccess
    @CommandLine.Option(names={"--list-features"}, description={"Output the available features and their descriptions"})
    boolean listFeatures;
    @ReflectiveAccess
    @CommandLine.Option(names={"--jdk", "--java-version"}, description={"The JDK version the project should target"})
    Integer javaVersion;
    private final ContextFactory contextFactory;
    private final ApplicationType applicationType;
    private final ProjectGenerator projectGenerator;

    public CreateCommand(AvailableFeatures availableFeatures, ContextFactory contextFactory, ApplicationType applicationType, ProjectGenerator projectGenerator) {
        this.availableFeatures = availableFeatures;
        this.contextFactory = contextFactory;
        this.applicationType = applicationType;
        this.projectGenerator = projectGenerator;
    }

    @NonNull
    protected abstract List<String> getSelectedFeatures();

    protected Map<String, Object> getAdditionalOptions() {
        return Collections.emptyMap();
    }

    @Override
    public Integer call() throws Exception {
        Project project;
        if (this.listFeatures) {
            new ListFeatures(this.availableFeatures, new Options(this.test, this.gormImpl, this.servletImpl, this.getJdkVersion(), this.getOperatingSystem()), this.applicationType, this.getOperatingSystem(), this.contextFactory).output(this);
            return 0;
        }
        try {
            project = NameUtils.parse(this.name);
        }
        catch (IllegalArgumentException e) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), StringUtils.isEmpty(this.name) ? "Specify an application name or use --inplace to create an application in the current directory" : e.getMessage());
        }
        FileSystemOutputHandler outputHandler = new FileSystemOutputHandler(project, this.inplace, this);
        this.generate(project, outputHandler);
        this.out("@|blue ||@ Application created at " + outputHandler.getOutputLocation());
        return 0;
    }

    public void generate(OutputHandler outputHandler) throws Exception {
        this.generate(NameUtils.parse(this.name), outputHandler);
    }

    public void generate(Project project, OutputHandler outputHandler) throws Exception {
        Options options = new Options(this.test, this.gormImpl, this.servletImpl, this.getJdkVersion(), this.getOperatingSystem(), this.getAdditionalOptions());
        this.projectGenerator.generate(this.applicationType, project, options, this.getOperatingSystem(), this.getSelectedFeatures(), outputHandler, this);
    }

    private JdkVersion getJdkVersion() {
        if (this.javaVersion == null) {
            return JdkVersion.DEFAULT_OPTION;
        }
        return JdkVersion.valueOf(this.javaVersion);
    }
}

