/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import java.util.List;
import java.util.Map;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.ByteArrayDecoder;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.DecodingException;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.codec.KotlinSerializationSupport;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class KotlinSerializationBinaryDecoder<T extends BinaryFormat>
extends KotlinSerializationSupport<T>
implements Decoder<Object> {
    private final ByteArrayDecoder byteArrayDecoder = new ByteArrayDecoder();

    public KotlinSerializationBinaryDecoder(T format, MimeType ... supportedMimeTypes) {
        super(format, supportedMimeTypes);
    }

    public void setMaxInMemorySize(int byteCount) {
        this.byteArrayDecoder.setMaxInMemorySize(byteCount);
    }

    public int getMaxInMemorySize() {
        return this.byteArrayDecoder.getMaxInMemorySize();
    }

    @Override
    public boolean canDecode(ResolvableType elementType, @Nullable MimeType mimeType) {
        return this.canSerialize(elementType, mimeType);
    }

    @Override
    public List<MimeType> getDecodableMimeTypes() {
        return this.supportedMimeTypes();
    }

    @Override
    public List<MimeType> getDecodableMimeTypes(ResolvableType targetType) {
        return this.supportedMimeTypes();
    }

    @Override
    public Flux<Object> decode(Publisher<DataBuffer> inputStream, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return Flux.error(new UnsupportedOperationException());
    }

    @Override
    public Mono<Object> decodeToMono(Publisher<DataBuffer> inputStream, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return Mono.defer(() -> {
            KSerializer<Object> serializer = this.serializer(elementType);
            if (serializer == null) {
                return Mono.error(new DecodingException("Could not find KSerializer for " + String.valueOf(elementType)));
            }
            return this.byteArrayDecoder.decodeToMono(inputStream, elementType, mimeType, hints).handle((byteArray, sink) -> {
                try {
                    sink.next(((BinaryFormat)this.format()).decodeFromByteArray((DeserializationStrategy)serializer, byteArray));
                    sink.complete();
                }
                catch (IllegalArgumentException ex) {
                    sink.error(new DecodingException("Decoding error: " + ex.getMessage(), ex));
                }
            });
        });
    }
}

