/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.value;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.core.type.Argument;
import io.micronaut.core.value.PropertyNotFoundException;
import io.micronaut.core.value.ValueResolver;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public interface PropertyResolver
extends ValueResolver<String> {
    public boolean containsProperty(@NonNull String var1);

    public boolean containsProperties(@NonNull String var1);

    @NonNull
    public <T> Optional<T> getProperty(@NonNull String var1, @NonNull ArgumentConversionContext<T> var2);

    @NonNull
    default public Collection<String> getPropertyEntries(@NonNull String name) {
        return Collections.emptySet();
    }

    @NonNull
    default public <T> Optional<T> getProperty(@NonNull String name, @NonNull Argument<T> argument) {
        return this.getProperty(name, ConversionContext.of(argument));
    }

    @NonNull
    default public Map<String, Object> getProperties(@NonNull String name) {
        return this.getProperties(name, null);
    }

    @NonNull
    default public Map<String, Object> getProperties(@Nullable String name, @Nullable StringConvention keyFormat) {
        return Collections.emptyMap();
    }

    @NonNull
    default public <T> Optional<T> getProperty(@NonNull String name, @NonNull Class<T> requiredType, @NonNull ConversionContext context) {
        return this.getProperty(name, context.with(Argument.of(requiredType)));
    }

    @Override
    @NonNull
    default public <T> Optional<T> get(@NonNull String name, @NonNull ArgumentConversionContext<T> conversionContext) {
        return this.getProperty(name, conversionContext);
    }

    @NonNull
    default public <T> Optional<T> getProperty(@NonNull String name, @NonNull Class<T> requiredType) {
        return this.getProperty(name, requiredType, (T)ConversionContext.DEFAULT);
    }

    @Nullable
    default public <T> T getProperty(@NonNull String name, @NonNull Class<T> requiredType, @Nullable T defaultValue) {
        return this.getProperty(name, requiredType).orElse(defaultValue);
    }

    @NonNull
    default public <T> T getRequiredProperty(@NonNull String name, @NonNull Class<T> requiredType) throws PropertyNotFoundException {
        return this.getProperty(name, requiredType).orElseThrow(() -> new PropertyNotFoundException(name, requiredType));
    }

    public static String nameOf(String ... path) {
        return String.join((CharSequence)".", path);
    }
}

