/*
 * Decompiled with CFR 0.152.
 */
package org.grails.cli.compiler.grape;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.Exclusion;
import org.grails.cli.compiler.dependencies.ArtifactCoordinatesResolver;
import org.grails.cli.compiler.dependencies.CompositeDependencyManagement;
import org.grails.cli.compiler.dependencies.Dependency;
import org.grails.cli.compiler.dependencies.DependencyManagement;
import org.grails.cli.compiler.dependencies.DependencyManagementArtifactCoordinatesResolver;

public class DependencyResolutionContext {
    private final Map<String, Dependency> managedDependencyByGroupAndArtifact = new HashMap<String, Dependency>();
    private final List<Dependency> managedDependencies = new ArrayList<Dependency>();
    private DependencyManagement dependencyManagement = null;
    private ArtifactCoordinatesResolver artifactCoordinatesResolver;

    private String getIdentifier(Dependency dependency) {
        return this.getIdentifier(dependency.getArtifact().getGroupId(), dependency.getArtifact().getArtifactId());
    }

    private String getIdentifier(String groupId, String artifactId) {
        return groupId + ":" + artifactId;
    }

    public ArtifactCoordinatesResolver getArtifactCoordinatesResolver() {
        return this.artifactCoordinatesResolver;
    }

    public String getManagedVersion(String groupId, String artifactId) {
        Dependency dependency = this.getManagedDependency(groupId, artifactId);
        if (dependency == null) {
            dependency = this.managedDependencyByGroupAndArtifact.get(this.getIdentifier(groupId, artifactId));
        }
        return dependency != null ? dependency.getArtifact().getVersion() : null;
    }

    public List<Dependency> getManagedDependencies() {
        return Collections.unmodifiableList(this.managedDependencies);
    }

    private Dependency getManagedDependency(String group, String artifact) {
        return this.managedDependencyByGroupAndArtifact.get(this.getIdentifier(group, artifact));
    }

    public void addManagedDependencies(List<Dependency> dependencies2) {
        this.managedDependencies.addAll(dependencies2);
        for (Dependency dependency : dependencies2) {
            this.managedDependencyByGroupAndArtifact.put(this.getIdentifier(dependency), dependency);
        }
    }

    public void addDependencyManagement(DependencyManagement dependencyManagement) {
        for (org.grails.cli.compiler.dependencies.Dependency dependency : dependencyManagement.getDependencies()) {
            ArrayList<Exclusion> aetherExclusions = new ArrayList<Exclusion>();
            for (Dependency.Exclusion exclusion : dependency.getExclusions()) {
                aetherExclusions.add(new Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), "*", "*"));
            }
            Dependency aetherDependency = new Dependency((Artifact)new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), "jar", dependency.getVersion()), "compile", false, aetherExclusions);
            this.managedDependencies.add(0, aetherDependency);
            this.managedDependencyByGroupAndArtifact.put(this.getIdentifier(aetherDependency), aetherDependency);
        }
        this.dependencyManagement = this.dependencyManagement != null ? new CompositeDependencyManagement(dependencyManagement, this.dependencyManagement) : dependencyManagement;
        this.artifactCoordinatesResolver = new DependencyManagementArtifactCoordinatesResolver(this.dependencyManagement);
    }
}

